'use strict';
/**
Abstract Model to encapsulate common functions
*/

/**
 This is using ES6 syntax
 it is syntactic sugar for conversion to JS
 classes and inheritance
 */
const _ = require("lodash");

module.exports = class AbstractModel{
    constructor(schema){
        this.schema = schema;
        this.data = {};
    }

    /**
     That last line in sanitize uses a couple of lodash functions to only
     keep variables that are in the user schema.
     _.defaults merges all variables from schemas.user
     into data that don't exist already.
     _.keys gets all the keys from the schema. _.pick only keeps the variables
     who's names were returned by _.keys. Basically it ensures this.data matches our schema exactly.
     **/
    sanitize () {
        this.data = this.data || {};
        return _.pick(_.defaults(this.data, this.schema), _.keys(this.schema));
    }

    setData(data){
        this.data = data;
    }

    set(key, value){
        this.data[key] = value;
    }

    get(key){
        return this.data[key];
    }

}