/**
Game Controller
@author gefunk
*/
const mongoose = require('mongoose');
const Game = mongoose.model('Game');

// save new employee
exports.create = function(game_data, response){	
	const game = new Game(game_data);
	game.save(function(err){
		if(err) {console.log(err);response.json( err);}
		response.json(game); 
	});
}

/**
Function Find all
*/
exports.findAll = function(response){
	console.log("In Find all");
	Game.find({}, function(err, docs){
		console.log("Returned find all", err, docs);
		if(!err){
			response.json(docs);
		} else {
			console.log(err);
			response.json(err);
		}
	});
}

/**
Delete Game
*/
exports.delete = function(id, response){
	console.log("Deleting by ID: ", id);
	Game.findByIdAndRemove(id, function(err){
		if(!err) response.json({'success': true});
		else response.json(err);
	});
}

/**
Find by Id
*/
exports.findById = function(id, response){
	console.log('Finding by id', id);
	Game.findById(id, function (err, doc) {
  		if(!err) response.json(doc);
		else response.json(err);
	}); 
}

exports.play = function(id, response){
	
}