﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace VeteransAffairs.Registries.Validation
{
    public class ValidationError
    {
		private string _propertyName = string.Empty;
        public ValidationError(string propertyName, string message)
		{
			_propertyName = propertyName;
			Message = message;
		}

		public string Message { get; set; }

		public string PropertyName
		{
			get
			{
				return _propertyName;
			}
			set
			{
				if (value == null)
				{
					value = string.Empty;
				}
				_propertyName = value;
			}
		}

		public override string ToString()
		{
			return string.Format("{0}: {1}", _propertyName, Message);
		}

    }
}
