﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;  

namespace VeteransAffairs.Registries.Validation
{
    [DataContract(IsReference = false)]   
    public class ValidationBase
    {
        private ValidationErrorsCollection _validationErrors = new ValidationErrorsCollection(); 

        public void ClearErrors()
        {
            _validationErrors.Clear();
        }

        public ValidationErrorsCollection ValidationErrors
        {
            get {return _validationErrors; }
        }

        public virtual bool Validate()
        {
            return (_validationErrors.Count == 0);
        }

    }
}
