﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
//using Microsoft.Practices.EnterpriseLibrary.ExceptionHandling;


namespace VeteransAffairs.Registries.Validation
{
    [Serializable()]
    public class VABusinessRuleViolationException : Exception       
    {
        /// <summary>
        /// The type of exception.
        /// </summary>
        private VABusinessRuleViolationCode code = VABusinessRuleViolationCode.Generic;

        public enum VABusinessRuleViolationCode
        {
            Generic = 0,
            RequiredFieldIsMissing
            
        }
        
        /// <summary>
        /// Expose th  type of business rule exception.
        /// </summary>
        public VABusinessRuleViolationCode Code
        {
            get { return code; }
            //TLB.Fortify
            //private set { code = value; }
        }

        /// <summary>
		/// Default construtor.
		/// </summary>
		public VABusinessRuleViolationException() : base()
		{
		}

		/// <summary>
		/// Constructor with one of our custom codes.
		/// </summary>
		/// <param name="message"></param>
		/// <param name="code"></param>
		public VABusinessRuleViolationException(string message, VABusinessRuleViolationCode code) : base(message)
		{
			this.code = code;
		}

		/// <summary>
		/// Constructor with exception message.
		/// </summary>
		/// <param name="message"></param>
		public VABusinessRuleViolationException(string message) : base(message)
		{
		} 

		/// <summary>
		/// Constructor with message and inner exception.
		/// </summary>
		/// <param name="message"></param>
		/// <param name="inner"></param>
		public VABusinessRuleViolationException(string message, Exception inner) 
			: base(message, inner)
		{
		}

		/// <summary>
		/// Serialization ctor.
		/// </summary>
		/// <param name="serializationInfo"></param>
		/// <param name="streamingContext"></param>
        protected VABusinessRuleViolationException(SerializationInfo serializationInfo, StreamingContext streamingContext)
			: base( serializationInfo, streamingContext )
		{
		}



    }
}
