﻿using System;
using System.Collections.Generic;
using Microsoft.Reporting.WebForms;

namespace CRS_EFR
{
    /// <summary>
    /// Summary description for ReportViewerHandler
    /// </summary>
    [Serializable]
    public class ReportViewerHandler
    {
        List<ReportParameter> _reportParameters;

        public void ClearParams()
        {
            _reportParameters.Clear();
        }

        public void AddReportVariable(string paramName, string paramValue)
        {
            ReportParameter reportParam = new ReportParameter(paramName, paramValue);
            _reportParameters.Add(reportParam);
        }

        public void SetReportParameters(ReportViewer rv)
        {

            rv.LocalReport.SetParameters(_reportParameters.ToArray());
        }

        public void SetServerReportParameters(ReportViewer rv)
        {

            rv.ServerReport.SetParameters(_reportParameters.ToArray());

        }

        public ReportViewerHandler()
        {
            //save date
            _reportParameters = new List<ReportParameter>();
        }
    }
}
