﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Data;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

namespace CRS_EFR
{
    [Serializable()]
    [System.ComponentModel.DataObject]
    public class RelatedDiagnosticsManager : BaseBO
    {
        #region Views

        public class RelatedDiagnosticsView
        {
            public int ID { get; set; }
            public string ICDCode { get; set; }
            public int ICDCodeSet { get; set; }
            public string ICDCodeName { get; set; }
            public DateTime? EncounterDate { get; set; }
            public string SiteCode { get; set; }
            public string FacilityName { get; set; }
        }

        #endregion

        #region Constructor

        public RelatedDiagnosticsManager()
        {
            _defaultSortField = "ICDCode";
        }

        #endregion

        #region LINQ queries

        /// <summary>
        /// Returns iqueryable of all Related Diagnostics.
        /// </summary>
        /// <param></param>
        /// <returns></returns>
        private IQueryable<EFR_ICD9_DIAG> LinqAll()
        {
            //populate LinqAll
            IQueryable<EFR_ICD9_DIAG> RelatedDiagnostics = (from e in _db.EFR_ICD9_DIAGs
                                                            select e);

            return RelatedDiagnostics;
        }

        /// <summary>
        /// Returns iqueryable of Related Diagnostics for a patient.
        /// </summary>
        /// <param name="PatientID"></param>
        /// <returns></returns>
        private IQueryable<EFR_ICD9_DIAG> SelectByPatientIDLinqFilter(int PatientID)
        {
            return (from e in LinqAll()
                    where e.PATIENT_ID == PatientID
                    select e);
        }

        #endregion

        #region Methods for Select

        /// <summary>
        /// Return a list of Related Diagnistics per patient
        /// </summary>
        /// <returns></returns>
        public IEnumerable<RelatedDiagnosticsView> SelectByPatientID(int PatientID, string sort)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;
            } 
            
            using (_db = GetDataContext())
            {
                //SetLoadWith(_db);

                return (from e in SelectByPatientIDLinqFilter(PatientID)

                        select new RelatedDiagnosticsView
                        {
                            ID = e.ICD9DIS_ID,
                            ICDCode = e.ICD9_CODE,
                            ICDCodeSet = e.ICD_CODESET,
                            ICDCodeName = e.ICD9_CODE_NAME,
                            EncounterDate = e.ENCOUNTER_DATETIME,
                            SiteCode = e.STD_INSTITUTION.STATIONNUMBER,
                            FacilityName = e.STD_INSTITUTION.NAME
                        }).OrderBy(sort).ToList();
            }
        }

        #endregion
    }
}
