﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Services;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business; 

/// <summary>
/// Summary description for ReferenceRangeTestUnits
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
 [System.Web.Script.Services.ScriptService]
public class ReferenceRangeTestUnits : System.Web.Services.WebService
{

    public ReferenceRangeTestUnits()
    {

        //Uncomment the following line if using designed components
        //InitializeComponent(); 
    }

    [WebMethod]
    public TestReferenceRange GetUnitAndReferenceRange(int testId, int analyteId)
    {
        UnitTestReferenceRangeManager manager = new UnitTestReferenceRangeManager();

        STD_ANALYTE_TEST_REFERENCE_RANGE range = manager.GetTestReferenceRange(testId, analyteId);

        if (range != null)



            return new TestReferenceRange {RefRange = range.REFERENCE_RANGE, UnitId = range.STD_UNITS_ID, UnitName = range.STD_UNIT.NAME};
        else
            return new TestReferenceRange {UnitId = 0, RefRange = String.Empty, UnitName = String.Empty };
    
    }

    public class TestReferenceRange
    {

        public int UnitId { get; set; }
        public string UnitName { get; set; }
        public string RefRange { get; set; }
    }
}

