using System;
using System.Linq;
using System.Web;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager;
using CRS_EFR;

namespace CRS_EFR
{
    /// <summary>
    /// Summary description for MenuBuilder
    /// </summary>
    public static class MenuBuilder
    {
        private static string[] PageList;
        private static string fontColorNavyBlue = "#1E2D54";
        private static string fontColorLightBlue = "#2e498f";

        //public MenuBuilder()
        //{
        //    //
        //    // TODO: Add constructor logic here
        //    //
        //}

        //Look at using sitemap (Database entries available)
        /// <summary>
        /// Builds a menu and takes child excluion into consideration
        /// </summary>
        /// <param name="currentUrl"></param>
        /// <param name="horizontalMenu"></param>
        /// <param name="pageTopMenuItem"></param>
        /// <param name="leftMenu"></param>
        /// <param name="pageLeftMenuItem"></param>
        /// <param name="breadCrumb"></param>
        /// <param name="accessiblePageList"></param>
        public static void BuildDynamicNavigationItems(string currentUrl, Menu horizontalMenu, string pageTopMenuItem, Menu leftMenu, string pageLeftMenuItem, Label breadCrumb, string[] accessiblePageList)
        {
            bool hideShowChildren = true;

            if (pageTopMenuItem.Equals("Patients"))
            {
                if (currentUrl.IndexOf("Patients.aspx") > 0)
                {
                    hideShowChildren = false;

                }

            }
            BuildDynamicNavigationItems(currentUrl, horizontalMenu, pageTopMenuItem, leftMenu, pageLeftMenuItem, breadCrumb, accessiblePageList, hideShowChildren);
        }
        /// <summary>
        /// Builds left menu based on top menu location and pages accessible by user
        /// </summary>
        /// <param name="currentUrl"></param>
        /// <param name="horizontalMenu"></param>
        /// <param name="pageTopMenuItem"></param>
        /// <param name="leftMenu"></param>
        /// <param name="pageLeftMenuItem"></param>
        /// <param name="breadCrumb"></param>
        /// <param name="accessiblePageList"></param>
        private static void BuildDynamicNavigationItems(string currentUrl, Menu horizontalMenu, string pageTopMenuItem, Menu leftMenu, string pageLeftMenuItem, Label breadCrumb, string[] accessiblePageList, bool showChildren)
        {
            switch (pageTopMenuItem)
            {
                case "My Tasks":
                    var parentReferral = new MenuItem("Referrals", "EFR_REFERRAL");
                    leftMenu.Items.Add(parentReferral);
                    parentReferral.ChildItems.Add(new MenuItem("New<font color='" + fontColorNavyBlue + "'> Referrals</font>" + getReferralCount(1), "EFR_REFERRAL", "", "Referrals.aspx?statusId=4"));

                    var parentAccepted = new MenuItem("Accepted<font color='" + fontColorNavyBlue + "'> Referrals</font>");
                    parentReferral.ChildItems.Add(parentAccepted);
                    parentAccepted.ChildItems.Add(new MenuItem("Open<font color='" + fontColorNavyBlue + "'> Referrals</font>", "EFR_REFERRAL", "", "Referrals.aspx?statusId=5"));
                    parentAccepted.ChildItems.Add(new MenuItem("Closed<font color='" + fontColorNavyBlue + "'> Referrals</font>", "EFR_REFERRAL", "", "Referrals.aspx?statusId=6"));
                    parentAccepted.ChildItems.Add(new MenuItem("Follow Ups", "EFR_REFERRAL", "", "BioContactFollowups.aspx"));
                    parentReferral.ChildItems.Add(new MenuItem("Ineligible<font color='" + fontColorNavyBlue + "'> Referrals</font>", "EFR_REFERRAL", "", "Referrals.aspx?statusId=9"));

                    var parentLabKits = new MenuItem("Lab Kits", "LabKitOrders");
                    leftMenu.Items.Add(parentLabKits);
                    parentLabKits.ChildItems.Add(new MenuItem("New<font color='" + fontColorNavyBlue + "'> Kits</font>", "LabKitOrders", "", "LabKitOrders.aspx?OrderType=0"));
                    parentLabKits.ChildItems.Add(new MenuItem("Tracking<font color='" + fontColorNavyBlue + "'> Kits</font>", "LabKitOrders", "", "LabKitInProcessOrders.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Tracking)));
                    parentLabKits.ChildItems.Add(new MenuItem("Received<font color='" + fontColorNavyBlue + "'> Kits</font>", "LabKitOrders", "", "LabKitInProcessOrders.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Received)));
                    parentLabKits.ChildItems.Add(new MenuItem("Voided<font color='" + fontColorNavyBlue + "'> Kits</font>", "LabKitOrders", "", "LabKitInProcessOrders.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Voided)));

                    var parentQuestionnaire = new MenuItem("Questionnaires/Forms", "EFR_QUESTIONNAIRE");
                    leftMenu.Items.Add(parentQuestionnaire);
                    parentQuestionnaire.ChildItems.Add(new MenuItem("New<font color='" + fontColorNavyBlue + "'> Questions</font>", "EFR_QUESTIONNAIRE", "", "Surveys.aspx?statusId=6"));
                    parentQuestionnaire.ChildItems.Add(new MenuItem("In Process<font color='" + fontColorNavyBlue + "'> Questions</font>", "EFR_QUESTIONNAIRE", "", "Surveys.aspx?statusId=1"));
                    parentQuestionnaire.ChildItems.Add(new MenuItem("Completed<font color='" + fontColorNavyBlue + "'> Questions</font>", "EFR_QUESTIONNAIRE", "", "Surveys.aspx?statusId=2"));

                    var parentLabOrders = new MenuItem("Lab Orders", "EFR_LABORDER");
                    leftMenu.Items.Add(parentLabOrders);
                    parentLabOrders.ChildItems.Add(new MenuItem("New<font color='" + fontColorNavyBlue + "'> Orders</font>", "EFR_LABORDER", "", "LabOrders.aspx?statusId=6"));
                    parentLabOrders.ChildItems.Add(new MenuItem("Awaiting Results", "EFR_LABORDER", "", "LabOrders.aspx?statusId=11"));

                    parentLabOrders.ChildItems.Add(new MenuItem("Voided<font color='" + fontColorNavyBlue + "'> Orders</font>", "EFR_LABORDER", "", "LabOrders.aspx?statusId=3"));
                    parentLabOrders.ChildItems.Add(new MenuItem("Closed<font color='" + fontColorNavyBlue + "'> Orders</font>", "EFR_LABORDER", "", "LabOrders.aspx?statusId=9"));

                    var parentLabResults = new MenuItem("Lab Results", "LabResults");
                    leftMenu.Items.Add(parentLabResults);
                    parentLabResults.ChildItems.Add(new MenuItem("New<font color='" + fontColorNavyBlue + "'> Results</font>", "LabResults", "", "LabResults.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.New)));
                    parentLabResults.ChildItems.Add(new MenuItem("In Process<font color='" + fontColorNavyBlue + "'> Results</font>", "LabResults", "", "LabResults.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.InProcess)));
                    parentLabResults.ChildItems.Add(new MenuItem("Accepted<font color='" + fontColorNavyBlue + "'> Results</font>", "LabResults", "", "LabResults.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Accepted)));
                    parentLabResults.ChildItems.Add(new MenuItem("Voided<font color='" + fontColorNavyBlue + "'> Results</font>", "LabResults", "", "LabResults.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Voided)));

                    var parentIntprtnDiagnosis = new MenuItem("Interpretation & Follow Up&nbsp;", "EFR_LABINTERPRETATION");
                    leftMenu.Items.Add(parentIntprtnDiagnosis);
                    parentIntprtnDiagnosis.ChildItems.Add(new MenuItem("New<font color='" + fontColorNavyBlue + "'> Interpret</font>", "EFR_LABINTERPRETATION", "", "LabResultsInterpretation.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.New)));
                    parentIntprtnDiagnosis.ChildItems.Add(new MenuItem("In Process<font color='" + fontColorNavyBlue + "'> Interpret</font>", "EFR_LABINTERPRETATION", "", "LabResultsInterpretation.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.InProcess)));
                    parentIntprtnDiagnosis.ChildItems.Add(new MenuItem("Interpreted", "EFR_LABINTERPRETATION", "", "LabResultsInterpretation.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)));

                    var parentReferralContactLogs = new MenuItem("Contact Logs", "EFR_CONTACTLOGS");
                    leftMenu.Items.Add(parentReferralContactLogs);
                    parentReferralContactLogs.ChildItems.Add(new MenuItem("All Contacts", "EFR_CONTACTLOGS", "", "ReferralContactLogs.aspx"));

                    break;

                case "Administration":
                    leftMenu.Items.Add(new MenuItem("Users", "EFR ADMIN LIST USERS", "", "AdminListUsers.aspx"));
                    leftMenu.Items.Add(new MenuItem("Role Matrix", "EFR ADMIN USER ROLE", "", "AdminEditUsersRoles.aspx"));
                    leftMenu.Items.Add(new MenuItem("Reference Ranges", "REFERENCE RANGES", "", "AdminListReferenceRanges.aspx"));
                    leftMenu.Items.Add(new MenuItem("Auto Triage", "EFR AUTO TRIAGE", "", "AutoReferralTriage.aspx"));
                    leftMenu.Items.Add(new MenuItem("DoD Fragment Data", "EFR ADMIN DOD FRAGMENT DATA EXTRACT", "", "AdminDoDFragment.aspx"));
                    break;

                case "Patients":
                    var patients = new MenuItem("Patient Lookup", "EFR_PATIENTS");

                    leftMenu.Items.Add(patients);


                    if (showChildren)
                    {
                        string patientId = HttpContext.Current.Request.QueryString["patientId"];
                        patients.Selectable = false;
                        patients.ChildItems.Add(new MenuItem("Patient Information", "EFR_PATIENTS", "", string.Format("Patient.aspx?patientId={0}", patientId)));
                        patients.ChildItems.Add(new MenuItem("Workflows", "EFR_PATIENTS", "", string.Format("PatientWorkflows.aspx?patientId={0}", patientId)));
                        patients.ChildItems.Add(new MenuItem("Related Diagnoses", "EFR_PATIENTS", "", string.Format("PatientRelatedDiagnoses.aspx?patientId={0}", patientId)));
                        UserAccountManager currentUser = (UserAccountManager)HttpContext.Current.User;
                        if (currentUser.IsInRole(EFRSharedConstant.EfrUserRoleTefscCoordinator)
                            || currentUser.IsInRole(EFRSharedConstant.EfrUserRoleProvider)
                            || currentUser.IsInRole(EFRSharedConstant.EfrUserRoleNurse))
                        {
                            patients.ChildItems.Add(new MenuItem("Related Lab Tests", "EFR_PATIENTS", "", string.Format("PatientRelatedLabTests.aspx?patientId={0}", patientId)));
                        }
                        patients.ChildItems.Add(new MenuItem("Imaging", "EFR_PATIENTS", "", string.Format("PatientImaging.aspx?patientId={0}", patientId)));
                    }
                    break;
                case "Reporting":


                    var parentReporting = new MenuItem("Reporting", "EFR_REPORTING");
                    leftMenu.Items.Add(parentReporting);
                    parentReporting.ChildItems.Add(new MenuItem("Referrals (counts)", "EFR_REFERRAL_REPORT", "", "ReportReferral.aspx"));
                    parentReporting.ChildItems.Add(new MenuItem("Referrals by Site", "EFR_SITE_REFERRAL_REPORT", "", "ReportReferralBySite.aspx"));
                    parentReporting.ChildItems.Add(new MenuItem("Follow-up Referrals", "EFR_FOLLOWUP_REFERRAL_REPORT", "", "ReportFollowupReferral.aspx"));
                    parentReporting.ChildItems.Add(new MenuItem("DoD Fragment Files", "EFR_DODFRAGMENT_REPORT", "", "ReportDoDFragment.aspx"));
                    parentReporting.ChildItems.Add(new MenuItem("# Unique Individuals", "EFR_UNIQUEINDIVIDUALS_REPORT", "", "ReportUniqueIndividuals.aspx"));

                    var parentDataExport = new MenuItem("Data Exports", "EFR_DATAEXPORT");
                    leftMenu.Items.Add(parentDataExport);
                    parentDataExport.ChildItems.Add(new MenuItem("Referrals", "EFR_DATAEXPORT_REFERRAL", "", "DataExportReferral.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("Follow-up Referrals", "EFR_DATAEXPORT_FOLLOWUP_REFERRAL", "", "DataExportFollowUpReferral.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("Bio Questionnaires", "EFR_DATAEXPORT_BIOQUESTIONNAIRE", "", "DataExportBioQuestionnaire.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("Fragment Forms", "EFR_DATAEXPORT_FRAGMENTFORM", "", "DataExportFragmentForm.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("Bio Labs", "EFR_DATAEXPORT_BIOLAB", "", "DataExportBioLab.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("Fragment Labs", "EFR_DATAEXPORT_FRAGMENTLAB", "", "DataExportFragmentLab.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("Related Diagnoses", "EFR_DATAEXPORT_RELATEDDIAGNOSES", "", "DataExportRelatedDiagnoses.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("Contact Logs", "EFR_DATAEXPORT_CONTACTLOG", "", "DataExportContactLog.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("Patients", "EFR_DATAEXPORT_PATIENTS", "", "DataExportPatient.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("VTA Data Extract", "EFR_DATAEXPORT_VTAPATIENTS", "", "DataExportVTAPatient.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("DoD Fragment Data", "EFR_DATAEXPORT_PATIENTS", "", "DataExportDoDFragment.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("Related Lab Tests", "EFR_DATAEXPORT_PATIENTS", "", "DataExportRelatedLabTests.aspx"));
                    parentDataExport.ChildItems.Add(new MenuItem("Patient Imaging", "EFR_DATAEXPORT_IMAGING", "", "DataExportImaging.aspx"));
                    break;

                default:
                    leftMenu.Items.Add(new MenuItem("Top Menu Not Registered"));
                    break;
            }

            //Disable all menu items
            foreach (MenuItem item in leftMenu.Items)
                ChangeMenuState(item, false);

            //Enable selection for the accessible items only
            for (int i = 0; i < accessiblePageList.GetLength(0); i++)
                ChangeMenuState(leftMenu.FindItem(accessiblePageList[i]), true);

            SetMenuItemHighlight(leftMenu.Items);
        }

        /// <summary>
        /// Changes menu state recursively
        /// </summary>
        /// <param name="item"></param>
        /// <param name="flag"></param>
        private static void ChangeMenuState(MenuItem item, bool flag)
        {
            if (item != null)
            {
                if (flag == false) item.Selectable = flag;
                if (flag == true && item.ChildItems.Count == 0) item.Selectable = flag;
                if (item.ChildItems.Count > 0)
                    foreach (MenuItem subitem in item.ChildItems)
                        ChangeMenuState(subitem, flag);
            }
        }

        /// <summary>
        /// Changes menu state recursively
        /// </summary>
        /// <param name="item"></param>
        /// <param name="flag"></param>
        private static void ChangeMenuState(MenuItem item)
        {

            if (PageList.Contains(item.Value))
                item.Selectable = true;
            else
                item.Selectable = false;

            if (item.NavigateUrl == "" && item.Target == "") item.Selectable = false;
            if (item.ChildItems.Count > 0)
                foreach (MenuItem subitem in item.ChildItems)
                    ChangeMenuState(subitem);
        }

        /// <summary>
        /// Search and highlight appropriate menu item
        /// </summary>
        /// <param name="menu">Collection of Menu Items</param>
        /// <param name="value">Item to Search For</param>
        private static void SetMenuItemHighlight(MenuItemCollection menu)
        {
            bool elemSelected;
            string[] pathElems = HttpContext.Current.Request.Url.PathAndQuery.Split(new char[] { '/' });
            SelectAndHighLightElement(menu, pathElems[pathElems.Length - 1], out elemSelected);

            if (!elemSelected)
            {
                string origUrl = SessionItemValue.Get(HttpContext.Current.Session["selectedMenuUrl"]);
                if (!string.IsNullOrEmpty(origUrl))
                {
                    SelectAndHighLightElement(menu, origUrl, out elemSelected);
                }
            }
        }

        public static void GetLeftMenuList(Menu leftMenu, string[] pageList)
        {
            if (leftMenu != null)
            {
                //Add all the menu items
                leftMenu.Items.Clear();

                MenuItem parentReferral = new MenuItem("Referrals", "EFR_REFERRAL");
                leftMenu.Items.Add(parentReferral);
                parentReferral.ChildItems.Add(new MenuItem("New" + getReferralCount(1), "EFR_REFERRAL", "", "Referrals.aspx?statusId=4"));

                MenuItem parentAccepted = new MenuItem("Accepted");
                parentReferral.ChildItems.Add(parentAccepted);

                parentAccepted.ChildItems.Add(new MenuItem("In Process", "EFR_REFERRAL", "", "Referrals.aspx?statusId=5"));

                parentAccepted.ChildItems.Add(new MenuItem("Completed", "EFR_REFERRAL", "", "Referrals.aspx?statusId=6"));

                parentReferral.ChildItems.Add(new MenuItem("Ineligible", "EFR_REFERRAL", "", "Referrals.aspx?statusId=9"));

                MenuItem parentLabWork = new MenuItem("Lab Work", "LabWork");
                leftMenu.Items.Add(parentLabWork);

                MenuItem ParentLabKitOrders = new MenuItem("Lab Kits", "LabKitOrders");
                parentLabWork.ChildItems.Add(ParentLabKitOrders);
                ParentLabKitOrders.ChildItems.Add(new MenuItem("New", "LabKitOrders", "", "LabKitOrders.aspx?OrderType=0"));
                ParentLabKitOrders.ChildItems.Add(new MenuItem("Ordered", "LabKitOrders", "", "LabKitInProcessOrders.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Tracking)));
                ParentLabKitOrders.ChildItems.Add(new MenuItem("Received", "LabKitOrders", "", "LabKitInProcessOrders.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Received)));
                ParentLabKitOrders.ChildItems.Add(new MenuItem("Voided", "LabKitOrders", "", "LabKitInProcessOrders.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Voided)));

                MenuItem parentQuestionnaire = new MenuItem("Questionnaires", "EFR_QUESTIONNAIRE");
                leftMenu.Items.Add(parentQuestionnaire);

                parentQuestionnaire.ChildItems.Add(new MenuItem("New", "EFR_QUESTIONNAIRE", "", "Surveys.aspx?statusId=6"));
                parentQuestionnaire.ChildItems.Add(new MenuItem("In Process", "EFR_QUESTIONNAIRE", "", "Surveys.aspx?statusId=1"));
                parentQuestionnaire.ChildItems.Add(new MenuItem("Completed", "EFR_QUESTIONNAIRE", "", "Surveys.aspx?statusId=2"));

                MenuItem parentLabOrders = new MenuItem("Lab Orders", "EFR_LABORDER");
                leftMenu.Items.Add(parentLabOrders);

                parentLabOrders.ChildItems.Add(new MenuItem("New", "EFR_LABORDER", "", "LabOrders.aspx?statusId=6"));
                parentLabOrders.ChildItems.Add(new MenuItem("In Process", "EFR_LABORDER", "", "LabOrders.aspx?statusId=1"));
                parentLabOrders.ChildItems.Add(new MenuItem("Completed", "EFR_LABORDER", "", "LabOrders.aspx?statusId=2"));
                parentLabOrders.ChildItems.Add(new MenuItem("Voided", "EFR_LABORDER", "", "LabOrders.aspx?statusId=3"));
                parentLabOrders.ChildItems.Add(new MenuItem("Closed", "EFR_LABORDER", "", "LabOrders.aspx?statusId=9"));

                MenuItem parentLabResults = new MenuItem("Lab Results", "LabResults");
                leftMenu.Items.Add(parentLabResults);

                parentLabResults.ChildItems.Add(new MenuItem("New", "LabResults", "", "LabResults.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.New)));
                parentLabResults.ChildItems.Add(new MenuItem("In Process", "LabResults", "", "LabResults.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.InProcess)));
                parentLabResults.ChildItems.Add(new MenuItem("Accepted", "LabResults", "", "LabResults.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Accepted)));
                parentLabResults.ChildItems.Add(new MenuItem("Voided", "LabResults", "", "LabResults.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Voided)));

                MenuItem parentIntprtnDiagnosis = new MenuItem("Interpretation & Follow Up&nbsp;", "EFR_LABINTERPRETATION");
                leftMenu.Items.Add(parentIntprtnDiagnosis);
                parentIntprtnDiagnosis.ChildItems.Add(new MenuItem("New", "EFR_LABINTERPRETATION", "", "InterpretationAndDiagnosis.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.New)));
                parentIntprtnDiagnosis.ChildItems.Add(new MenuItem("In Process", "EFR_LABINTERPRETATION", "", "LabResultsInterpretation.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.InProcess)));
                parentIntprtnDiagnosis.ChildItems.Add(new MenuItem("Interpreted", "EFR_LABINTERPRETATION", "", "InterpretationAndDiagnosis.aspx?OrderType=" + Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)));


                PageList = pageList;
                //Enable selection for the accessible items only
                foreach (MenuItem item in leftMenu.Items)
                {
                    ChangeMenuState(item);
                }

                SetMenuItemHighlight(leftMenu.Items);

            }

        }

        public static void SelectAndHighLightElement(MenuItemCollection menu, string url, out bool selected)
        {

            foreach (MenuItem elem in menu)
            {
                if (elem.NavigateUrl.Equals(url, StringComparison.CurrentCultureIgnoreCase))
                {
                    HttpContext.Current.Session["selectedMenuUrl"] = SessionItemFactory.Create(url);

                    selected = true;

                    if (elem.Selectable)
                    {
                        elem.Selected = true;
                        elem.Text = elem.Text.Replace(fontColorNavyBlue, fontColorLightBlue);
                    }
                    return;

                }
                else
                {
                    if (elem.ChildItems.Count > 0)

                        SelectAndHighLightElement(elem.ChildItems, url, out selected);

                }
            }

            selected = false;

        }

        public static string getReferralCount(int statusToCount)
        {
            string _returnText = "";

            //RegistryEntitiesDataContext db = new RegistryEntitiesDataContext();

            //using (db)
            //{

            //    var referrals = (from c in db.REFERRALs where c.STD_REFERRAL_STATUS_ID == statusToCount select c);

            //    int referralCount;
            //    referralCount = referrals.Count();

            //    if (referralCount > 0)
            //    {
            //        _returnText = " (" + referralCount.ToString() + ")";
            //    }
            //    else 
            //    {
            //        _returnText = "";
            //    }

            //};

            return _returnText;
        }
    }
}