﻿using System.Net;

namespace CRS_EFR
{
    internal class WebRequestorCore
    {
        internal static HttpWebRequest CreateRequest(string requestUrl)
        {
            var request = WebRequest.Create(requestUrl) as HttpWebRequest;
            if (request == null)
                throw new WebException(string.Format("{0}: failed to create web request", requestUrl));

            return request;
        }

        internal static string GetResponse(
            WebRequest request,
            string userId)
        {
            return request.TryGetResponse(userId);
        }

        internal static string GetResponse(
            WebRequest request,
            string userId,
            byte[] data)
        {
            return request.TryGetResponse(userId, data);
        }
    }
}

