﻿using Newtonsoft.Json;
using Newtonsoft.Json.Schema;
using Newtonsoft.Json.Schema.Generation;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace CRS_EFR
{
    public static class JsonSchemaValidator
    {
        private static Dictionary<Type, JSchema> _supportedTypes;

        static JsonSchemaValidator()
        {
            JSchemaGenerator generator = new JSchemaGenerator();

            _supportedTypes = new Dictionary<Type, JSchema>
        {
            { typeof(StudyQueryResponse), generator.Generate(typeof(StudyQueryResponse)) }
        };
        }

        public static T DeserializeAndValidate<T>(string json)
        {
            var type = typeof(T);

            if (!_supportedTypes.ContainsKey(type))
                throw new Exception("JsonSchemaValidator: Type not spported.");

            T result = default(T);

            JSchema schema = _supportedTypes[type];

            var schemaJson = schema.ToString();

            using (var reader = new JsonTextReader(new StringReader(json)))
            using (var validatingReader = new JSchemaValidatingReader(reader)
            {
                Schema = JSchema.Parse(schemaJson)
            })
            {
                var messages = new List<string>();

                validatingReader.ValidationEventHandler += (o, a) => messages.Add(a.Message);

                var serializer = new JsonSerializer();

                result = serializer.Deserialize<T>(validatingReader);

                if (messages != null && messages.Any())
                    throw new Exception($"JsonSchemaValidator: Invalid Json Response: {string.Join(",", messages)}.");
            }

            return result;
        }
    }
}