﻿using VeteransAffairs.Registries.Business.Utilities;

namespace CRS_EFR
{
    public class VistaImagingConfigurationService
    {
        private const string CACHE_KEY_NAMESPACE = "VeteransAffairs.Registries.BusinessManager";
        private const string CACHE_KEY_CLASS = "VistaImagingConfigurationService";

        private VistaImagingConfigurationRepository _vistaImagingConfigurationRepository;
        private VistaImagingConfigurationRepository ConfigurationRepository
        {
            get
            {
                if (_vistaImagingConfigurationRepository == null)
                    _vistaImagingConfigurationRepository = new VistaImagingConfigurationRepository();

                return _vistaImagingConfigurationRepository;
            }
        }

        static VistaImagingConfigurationService()
        {
            CacheHelper.Clear(GetCacheKey());
        }

        public VistaImagingConfiguration GetConfiguration()
        {
            return CacheHelper.GetAdd(GetCacheKey(), () =>
            {
                return ConfigurationRepository.GetConfiguration();
            });
        }

        private static string GetCacheKey()
        {
            return new CacheKey(
                CACHE_KEY_NAMESPACE,
                CACHE_KEY_CLASS,
                "GetConfiguration")
                    .Build();
        }
    }
}