﻿using System.Data;

namespace CRS_EFR
{
    public class VistaImagingConfigurationRepository
    {
        private const string CONNECT_STRING_NAME = "RegistryConnectionString";
        private const string USP_GET_CONFIGURATION = "EFR.usp_GetVistaImagingServicesConfiguration";

        internal VistaImagingConfiguration GetConfiguration()
        {
            using (var configurationTable = SqlProvider.ExecuteSPDataTable(
                CONNECT_STRING_NAME,
                USP_GET_CONFIGURATION))
            {
                if (configurationTable != null
                    && configurationTable.Rows != null
                    && configurationTable.Rows.Count > 0)
                {
                    var configurationRow = configurationTable.Rows[0];

                    return GetStationConfiguration(configurationRow);
                }
            }

            return null;
        }

        private VistaImagingConfiguration GetStationConfiguration(DataRow dr)
        {
            var certificateThumbprint = dr.Field<string>("CERTIFICATE_THUMBPRINT");
            var tokenEndpoint = dr.Field<string>("TOKEN_ENDPOINT");
            var studyQueryEndpoint = dr.Field<string>("STUDY_QUERY_ENDPOINT");

            return new VistaImagingConfiguration(
                certificateThumbprint,
                tokenEndpoint,
                studyQueryEndpoint);
        }
    }

}