﻿using System;
using System.Net;
using System.Web.Security.AntiXss;

namespace CRS_EFR
{

    [Serializable()]
    public class Study
    {
        public bool isSensitive { get; set; }
        public int imageCount { get; set; }

        /// <summary>
        /// Property strings : need to be HTML encoded
        /// </summary>
        public string acquisitionDate { get; set; }
        public string contextId { get; set; }
        public string patientICN { get; set; }
        public string procedureDescription { get; set; }
        public string securityToken { get; set; }
        public string siteName { get; set; }
        public string siteNumber { get; set; }
        public string specialtyDescription { get; set; }
        public string studyClass { get; set; }
        public string studyDate { get; set; }
        public string studyDescription { get; set; }
        public string studyId { get; set; }
        public string studyType { get; set; }
        public string type { get; set; }

        /// <summary>
        /// URLs : need to be url encoded
        /// </summary>
        public string detailsUrl { get; set; }
        public string manageUrl { get; set; }
        public string reportUrl { get; set; }
        public string thumbnailUrl { get; set; }
        public string viewerUrl { get; set; }

        public void EncodeJsonStrings()
        {
            acquisitionDate = AntiXssEncoder.HtmlEncode(acquisitionDate, false);
            contextId = AntiXssEncoder.HtmlEncode(contextId, false);
            patientICN = AntiXssEncoder.HtmlEncode(patientICN, false);
            procedureDescription = AntiXssEncoder.HtmlEncode(procedureDescription, false);
            securityToken = AntiXssEncoder.HtmlEncode(securityToken, false);
            siteName = AntiXssEncoder.HtmlEncode(siteName, false);
            siteNumber = AntiXssEncoder.HtmlEncode(siteNumber, false);
            specialtyDescription = AntiXssEncoder.HtmlEncode(specialtyDescription, false);
            studyClass = AntiXssEncoder.HtmlEncode(studyClass, false);
            studyDate = AntiXssEncoder.HtmlEncode(studyDate, false);
            studyDescription = AntiXssEncoder.HtmlEncode(studyDescription, false);
            studyId = AntiXssEncoder.HtmlEncode(studyId, false);
            studyType = AntiXssEncoder.HtmlEncode(studyType, false);
            type = AntiXssEncoder.HtmlEncode(type, false);

            // The urls come to us encoded already, so we need to decode, then re-encode
            detailsUrl = AntiXssEncoder.UrlEncode(WebUtility.UrlDecode(detailsUrl));
            manageUrl = AntiXssEncoder.UrlEncode(WebUtility.UrlDecode(manageUrl));
            reportUrl = AntiXssEncoder.UrlEncode(WebUtility.UrlDecode(reportUrl));
            thumbnailUrl = AntiXssEncoder.UrlEncode(WebUtility.UrlDecode(thumbnailUrl));
            viewerUrl = AntiXssEncoder.UrlEncode(WebUtility.UrlDecode(viewerUrl));
        }
    }

}