﻿using System;
using System.Linq;

namespace CRS_EFR
{
    public class ImageStudies
    {
        private const string STUDY_TYPE_IMAGE = "IMAGE";

        private readonly Study[] _studies;

        public ImageStudies(Study[] studies)
        {
            _studies = studies;
        }

        public Study[] EncodedImageStudies
        {
            get
            {
                if (_studies != null && _studies.Any())
                {
                    var tryGetImageStudies = _studies
                        .Where(s => s.studyType.Equals(STUDY_TYPE_IMAGE, StringComparison.OrdinalIgnoreCase));

                    if (tryGetImageStudies != null && tryGetImageStudies.Any())
                        foreach (var study in tryGetImageStudies)
                            study.EncodeJsonStrings();

                    return tryGetImageStudies.ToArray();
                }

                return null;
            }
        }

        public int? ImageStudyCount
        {
            get
            {
                if (_studies != null && _studies.Any())
                {
                    return _studies
                        .Where(s => s.studyType.Equals(STUDY_TYPE_IMAGE, StringComparison.OrdinalIgnoreCase))
                        .Count();
                }

                return null;
            }
        }
    }
}