﻿namespace CRS_EFR
{

    public class PatientImageDetail
    {
        public int Id { get; }
        public int PatientId { get; }
        public int? ImageFragmentCountId { get; }
        public int? ImageTypeId { get; }

        public decimal? LargestFragmentLength { get; }
        public decimal? LargestFragmentWidth { get; }
        public decimal? SmallestFragmentLength { get; }
        public decimal? SmallestFragmentWidth { get; }

        public bool? FragmentVerified { get; }
        public bool? SystemIdentified { get; }
        public bool? Reviewed { get; }
        public bool? IncludeInReport { get; }

        public string StudyId { get; }
        public string StudyDescription { get; }
        public string Comments { get; }
        public string ImageReasonOtherText { get; }
        public string ImageTypeOtherText { get; }

        public PatientImageDetail(
            int id,
            int patientId,
            int? imageFragmentCountId,
            int? imageTypeId,
            decimal? largestFragmentLength,
            decimal? largestFragmentWidth,
            decimal? smallestFragmentLength,
            decimal? smallestFragmentWidth,
            bool? fragmentVerified,
            bool? systemIdentified,
            bool? reviewed,
            bool? includeInReport,
            string studyId,
            string studyDescription,
            string comments,
            string imageReasonOtherText,
            string imageTypeOtherText)
        {
            Id = id;
            PatientId = patientId;
            ImageFragmentCountId = imageFragmentCountId;
            ImageTypeId = imageTypeId;

            LargestFragmentLength = largestFragmentLength;
            LargestFragmentWidth = largestFragmentWidth;
            SmallestFragmentLength = smallestFragmentLength;
            SmallestFragmentWidth = smallestFragmentWidth;

            FragmentVerified = fragmentVerified;
            SystemIdentified = systemIdentified;
            Reviewed = reviewed;
            IncludeInReport = includeInReport;

            StudyId = studyId;
            StudyDescription = studyDescription;
            Comments = comments;
            ImageReasonOtherText = imageReasonOtherText;
            ImageTypeOtherText = imageTypeOtherText;
        }
    }
}