﻿using System;

namespace CRS_EFR
{
    public class PatientImageAnalysis
    {
        public bool? ImagesInCprsFlag { get; }
        public bool? FragmentVerifiedFlag { get; }
        public bool? BoneFractureDocumentedFlag { get; }
        public bool? FragmentsInJointSpaceFlag { get; }
        public int? StandardImageFragmentSizeId { get; }
        public string JointSpace { get; }
        public string OtherObservations { get; }
        public DateTime? DateReviewed { get; }

        public PatientImageAnalysis(
            bool? imagesInCprsFlag,
            bool? fragmentVerifiedFlag,
            bool? boneFractureDocumentedFlag,
            bool? fragmentsInJointSpaceFlag,
            int? standardImageFragmentSizeId,
            string jointSpace,
            string otherObservations,
            DateTime? dateReviewed)
        {
            ImagesInCprsFlag = imagesInCprsFlag;
            FragmentVerifiedFlag = fragmentVerifiedFlag;
            BoneFractureDocumentedFlag = boneFractureDocumentedFlag;
            FragmentsInJointSpaceFlag = fragmentsInJointSpaceFlag;
            StandardImageFragmentSizeId = standardImageFragmentSizeId;
            JointSpace = jointSpace;
            OtherObservations = otherObservations;
            DateReviewed = dateReviewed;
        }
    }
}