﻿using System.Collections.Generic;
using System.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

namespace CRS_EFR
{
    public class PatientImageDetailManager : BaseBO
    {
        private readonly PatientImageRepository _patientImageRepository;
        private readonly PatientImageDetailRepository _patientImageDetailRepository;

        private readonly object _locker;

        public PatientImageDetailManager()
        {
            _patientImageRepository = new PatientImageRepository();
            _patientImageDetailRepository = new PatientImageDetailRepository();

            _locker = new object();
        }

        public static IEnumerable<string> LoadReferenceImageBodyParts()
        {
            return PatientImageDetailRepository.LoadReferenceImageBodyParts();
        }

        public static IEnumerable<string> LoadReferenceImageFragmentCounts()
        {
            return PatientImageDetailRepository.LoadReferenceImageFragmentCounts();
        }

        public static IEnumerable<string> LoadReferenceImageReasons()
        {
            return PatientImageDetailRepository.LoadReferenceImageReasons();
        }

        public static IEnumerable<string> LoadReferenceImageTypes()
        {
            return PatientImageDetailRepository.LoadReferenceImageTypes();
        }

        public PatientImageDetail GetPatientImageDetails(int patientImageId)
        {
            return _patientImageDetailRepository.GetPatientImageDetails(patientImageId);
        }

        public PatientImageReviewMap[] GetImageBodyParts(int patientImageId)
        {
            return _patientImageDetailRepository.GetImageBodyParts(patientImageId);
        }

        public PatientImageReviewMap[] GetImageReasons(int patientImageId)
        {
            return _patientImageDetailRepository.GetImageReasons(patientImageId);
        }

        public int UpdatePatientImage(
            object[] parameters, 
            IReadOnlyList<int> imageBodyParts, 
            IReadOnlyList<int> imagingReasons,
            string userId)
        {
            var eventArgs = new BOSaveSuccessEventArgs { SaveStatusArg = SaveStatus.SaveFail };

            lock (_locker)
            {
                int result = 0;

                _patientImageDetailRepository.InsertUpdatePatientImageReview(
                    parameters, 
                    imageBodyParts, 
                    imagingReasons,
                    userId);

                eventArgs.SaveStatusArg = SaveStatus.SaveSuccess;

                RaiseSaveEvent(this, eventArgs);

                return result;
            }
        }

        
    }
}
