﻿using System;
using System.IO;
using System.Net;
using System.Text;

namespace CRS_EFR
{
    internal static class HttpWebRequestExtensions
    {
        public static string TryGetResponse(
            this WebRequest request,
            string userId,
            byte[] data = null)
        {
            const string source = "HttpWebRequestExtensions.TryGetResponse";

            Uri uri = request.RequestUri;
            string requestUri = uri != null && !string.IsNullOrEmpty(uri.ToString()) ? uri.ToString() : "Not set.";
            string requestMethod = request != null && !string.IsNullOrEmpty(request.Method) ? request.Method : "Not set.";

            try
            {
                using (var response = request.GetResponse() as HttpWebResponse)
                {
                    if (response == null)
                        throw new WebException($"{requestUri}: Response is null");

                    if (response.StatusCode != HttpStatusCode.OK)
                        throw new WebException($"{requestUri}: request failed");

                    var responseStream = response.GetResponseStream();
                    if (responseStream == null)
                        throw new WebException($"{requestUri}: ResponseStream is null");

                    using (var reader = new StreamReader(responseStream))
                    {
                        if (reader != null)
                            return reader.ReadToEnd();
                    }
                }

                return null;
            }
            catch (WebException we)
            {
                var requestData = data != null ? Encoding.UTF8.GetString(data) : "Not set.";
                var comments = $"Request Method: {requestMethod}, Request Url: {requestUri}, Request Data: {requestData}";
                var message = "No response data available (possible timeout).";

                WebResponse webResponse = we.Response;
                if (webResponse != null)
                {
                    using (Stream responseStream = webResponse.GetResponseStream())
                    {
                        if (responseStream != null)
                        {
                            using (var reader = new StreamReader(responseStream))
                            {
                                if (reader != null)
                                    message = reader.ReadToEnd();
                            }
                        }
                    }
                }

                Logging.WriteLog(
                        userId,
                        source,
                        message,
                        comments,
                        we);

                throw we;
            }
        }
    }
}