﻿using BitFactory.Logging;
using System.Configuration;
using System;

namespace CRS_EFR
{
    public class Logging
    {
        private const int REGISTRY_ID = 1;
        private const string PROCESS = "EFR Logger";

        private static readonly bool _logToDb;
        private static readonly string _logFileLocation;

        static Logging()
        {
            string tryGetConfigValue = ConfigurationManager.AppSettings["LogToDB"];
            _logToDb = !string.IsNullOrEmpty(tryGetConfigValue) && tryGetConfigValue == "true";

            _logFileLocation = $@"{ConfigurationManager.AppSettings["LogsPath"].ToString()}\{DateTime.Today.Year}\{DateTime.Today.Month}\{DateTime.Today.Day}.log";
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="loginUserId"></param>
        /// <param name="source"></param>
        /// <param name="ex"></param>
        public static void WriteLog(
            string loginUserId,
            string source,
            Exception ex)
        {
            string message = $"Login UserId: {loginUserId}::: Error: {ex.Message.ToString()}::: StackTrace: {ex.StackTrace.ToString()}";

            WriteLog(
                message,
                source,
                true);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="loginUserId"></param>
        /// <param name="message"></param>
        public static void WriteLog(
            string loginUserId,
            string source,
            string message)
        {
            WriteLog(
                message,
                source,
                createdBy: loginUserId);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="loginUserId"></param>
        /// <param name="source"></param>
        /// <param name="comments"></param>
        /// <param name="e"></param>
        public static void WriteLog(
            string loginUserId,
            string source,
            string comments,
            Exception e)
        {
            if (e != null)
            {
                var message = $"Exception: {e.Message}";

                WriteLog(
                    message,
                    source,
                    true,
                    comments,
                    loginUserId);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="loginUserId"></param>
        /// <param name="source"></param>
        /// <param name="message"></param>
        /// <param name="comments"></param>
        /// <param name="e"></param>
        public static void WriteLog(
            string loginUserId,
            string source,
            string message,
            string comments,
            Exception e)
        {
            if (e != null)
            {
                WriteLog(
                    message,
                    source,
                    true,
                    $"{comments} ::: Exception: {e.ToString()}",
                    loginUserId);
            }
        }

        private static void WriteLog(
            string message,
            string source,
            bool isError = false,
            string comments = null,
            string createdBy = PROCESS)
        {
            message = $"Source: {source} ::: {message}";

            HandleLogToFile(message, comments);

            HandleLogToDb(message, isError, comments, createdBy);
        }

        private static void HandleLogToFile(
            string message,
            string comments)
        {
            if (!string.IsNullOrEmpty(message))
            {
                Logger fileLogger = new FileLogger(_logFileLocation);

                if (string.IsNullOrEmpty(comments))
                    fileLogger.LogError(message);
                else
                    fileLogger.LogError(message, comments);
            }
        }

        /// <summary>
        /// @StdRegistry = EFR = 1
        /// </summary>
        /// <param name="message">@Message varchar(max)</param>
        /// <param name="isError">@IsError BIT</param>
        /// <param name="comments">@Comments varchar(max)</param>
        /// <param name="createdBy">@CreatedBy varchar(30)</param>
        private static void HandleLogToDb(
            string message,
            bool isError = false,
            string comments = null,
            string createdBy = null)
        {
            if (createdBy == null)
                createdBy = PROCESS;

            if (_logToDb)
            {
                SqlProvider.ExecuteScalar(
                    "RegistryConnectionString",
                    "CRS_SP_INS_CRSDBLOG",
                    new object[]
                    {
                    REGISTRY_ID,
                    isError ? 1 : 0,
                    PROCESS,
                    message,
                    comments,
                    createdBy
                    });
            }
        }
    }

}
