﻿using System;
using System.Collections.Generic;
using System.Data.Linq;
using System.Linq;
using System.Linq.Expressions; 
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager;

namespace CRS_EFR
{
    public class FollowupManager:BaseBO
    {
        public FollowupManager()
        {
            _defaultSortField = "DueDate";

        }

        private IQueryable<ReferralFollowUp> LinqAll(string searchValue, bool reminder)
        {

            Expression<Func<WKF_CASE_ACTIVITY, bool>> bioLNExpression;

            
            if (String.IsNullOrEmpty(searchValue))
            {
                bioLNExpression  = s => true;
            }
            else
            {
                bioLNExpression = s => s.WKF_CASE.REFERRAL.PATIENT.LAST_NAME.Contains(searchValue);   
            }

            
            Expression<Func<CONTACT_LOG, bool>> contactLNExpression;

            if (String.IsNullOrEmpty(searchValue))
            {
                contactLNExpression  = s => true;
                 
            }
            else
            {
                contactLNExpression = s => s.REFERRAL.PATIENT.LAST_NAME.Contains(searchValue);
            }

            Expression<Func<WKF_CASE_ACTIVITY, bool>> bioReminderDateExpression;

            if (reminder)
            {
                bioReminderDateExpression = s => s.FOLLOWUP_REMINDER_DATE <= DateTime.Today;
            }
            else
            {
                bioReminderDateExpression = s => true;

            }

            Expression<Func<CONTACT_LOG, bool>> contactReminderDateExpression;

            if (reminder)
            {
                contactReminderDateExpression = s => s.DATE_REMIND_ME_ON <= DateTime.Today;

            }
            else
            {
                contactReminderDateExpression = s => true;

            }
            var result = (from a in _db.WKF_CASE_ACTIVITies.Where(bioLNExpression).Where(bioReminderDateExpression)   
                          where a.FOLLOWUP_REQUIRED_FLAG == true && a.FOLLOWUP_WKF_CASE_ID == null
                          && a.FOLLOWUP_DECLINED_DATE == null 
                          select new ReferralFollowUp
                          {
                              ReferralId = a.WKF_CASE.REFERRAL_ID.Value,
                              StationNumber = a.WKF_CASE.REFERRAL.STD_INSTITUTION.STATIONNUMBER,
                              InstitutionName = a.WKF_CASE.REFERRAL.STD_INSTITUTION.NAME,
                              ContactId = 0,
                              ActivityId = a.WKF_CASE_ACTIVITY_ID,
                              PatientLastName  = a.WKF_CASE.REFERRAL.PATIENT.LAST_NAME,
                              PatientFirstName = a.WKF_CASE.REFERRAL.PATIENT.FIRST_NAME,
                              PatientMI = a.WKF_CASE.REFERRAL.PATIENT.MIDDLE_NAME,    
                              Reason = "Needs Follow-Up Biomonitoring",
                              DueDate = a.FOLLOWUP_PLAN_DATE,
                              ReminderDate = a.FOLLOWUP_REMINDER_DATE,
                              FollowUpType = "Biomonitoring",
                              
                             
                          }).Concat(
                          from c in _db.CONTACT_LOGs.Where(contactLNExpression).Where(contactReminderDateExpression)  
                          where c.FOLLOWUP_REQUIRED_FLAG == true && c.FOLLOWUP_COMPL_DATE == null
                          select new ReferralFollowUp
                          {
                              ReferralId = c.REFERRAL_ID,
                              StationNumber = c.REFERRAL.STD_INSTITUTION.STATIONNUMBER,
                              InstitutionName = c.REFERRAL.STD_INSTITUTION.NAME,
                              ContactId = c.CONTACT_LOG_ID,
                              ActivityId = 0,
                              PatientLastName = c.REFERRAL.PATIENT.LAST_NAME,
                              PatientFirstName = c.REFERRAL.PATIENT.FIRST_NAME,
                              PatientMI = c.REFERRAL.PATIENT.MIDDLE_NAME,   
                              Reason = "Needs Follow-Up Contact",
                              DueDate = c.FOLLOWUP_REQUIRED_DATE,
                              ReminderDate = c.DATE_REMIND_ME_ON,
                              FollowUpType = "Contact"

                          });
            
            return result;

        }

        private void SetLoadWith(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }

        private IQueryable<ReferralFollowUp>  SelectLinqFilter(string value)
        {
            var linqFilter = LinqAll(value, false);

            return linqFilter;
 
        }

        public IEnumerable<ReferralFollowUp> SelectAll(string searchValue, string sort, int startRow, int maxRows)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                
                List<ReferralFollowUp> entities = SelectLinqFilter(searchValue).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
               

                return entities;
                  
            }         
        }

        public int SelectAllCount(string searchValue)
        {
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                return SelectLinqFilter(searchValue).Count();
            }
        }

        private IQueryable<ReferralFollowUp> SelectEventReminderLinqFilter()
        {
            //no need to search for name here so passing null as serach criteria
            var linqFilter = LinqAll(null, true);

            return linqFilter;

        }

        public IEnumerable<ReferralFollowUp> SelectEventReminderAll(string sort, int startRow, int maxRows)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            using (_db = GetDataContext())
            {
                SetLoadWith(_db);

                List<ReferralFollowUp> entities = SelectEventReminderLinqFilter().OrderBy(sort).Skip(startRow).Take(maxRows).ToList();


                return entities;

            }
        }

        public int SelectEventReminderAllCount()
        {
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                return SelectEventReminderLinqFilter().Count();
            }
        }

        public class ReferralFollowUp
        {
           
            public int ReferralId { get; set; }
            public string StationNumber { get; set; }
            public string InstitutionName { get; set; }
            public int ContactId { get; set; }
            public int ActivityId { get; set; }
            public string PatientLastName { get; set; }
            public string PatientFirstName { get; set; }
            public string PatientMI { get; set; }
            public string FollowUpType { get; set; }
            public string Reason { get; set; }
            public DateTime? DueDate { get; set; }
            public DateTime? ReminderDate { get; set; }
            public string PatientFullName
            {
                get
                {
                    return PatientLastName + ", " + PatientFirstName + " " + PatientMI;

                }
            }

            public string NormalizedDueDate 
            {
                get
                {
                    return DueDate.HasValue ? DueDate.Value.ToString("d") : String.Empty;

                }
            }

            public string NormalizedReminderDate 
            {
                get
                {
                    return ReminderDate.HasValue ? ReminderDate.Value.ToString("d") : String.Empty;

                }
            }
        }        
    }
}
