﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager;

namespace CRS_EFR
{
    public class RelatedLabTestManager:BaseBO 
    {

        /// <summary>
        /// Select related lab tests by patient ID
        /// </summary>
        /// <param name="patientId"></param>
        /// <returns></returns>
        public List<PatientRelatedLabTests> SelectRelatedLabTests(int PatientID)
        {
            using (_db = GetDataContext())
            {
                List<RELATED_LAB_TEST> labs = SelectRelatedLabTestsLinqFilter(PatientID).ToList();

                List<PatientRelatedLabTests> relatedTests = new List<PatientRelatedLabTests>();

                string labName = string.Empty;
                string specimenType = string.Empty;
                foreach (RELATED_LAB_TEST lab in labs)
                {
                    if (lab.LAB_TEST_NAME != labName && lab.SPECIMEN_TYPE != specimenType)
                    {
                        labName = lab.LAB_TEST_NAME;
                        specimenType = lab.SPECIMEN_TYPE;

                        PatientRelatedLabTests relatedTest = new PatientRelatedLabTests();
                        relatedTest.PatientID = PatientID;
                        relatedTest.LabName = labName;
                        relatedTest.SpecimentType = specimenType;

                        relatedTests.Add(relatedTest);
                    }
                }

                return relatedTests;
            }

           
        }


        private IQueryable<RELATED_LAB_TEST> SelectRelatedLabTestsLinqFilter(int patientId)
        {
            IQueryable<RELATED_LAB_TEST> linqFilter = (from e in _db.RELATED_LAB_TESTs
                                                   where e.PATIENT_ID == patientId
                                                   orderby e.LAB_TEST_NAME, e.SPECIMEN_TYPE
                                                   select e);
            return linqFilter;
        }

        /// <summary>
        /// Select related lab tests by patient ID, lab name, and specimen type
        /// </summary>
        /// <param name="patientId"></param>
        /// <param name="labName"></param>
        /// <param name="specimenType"></param>
        /// <returns></returns>
        public List<RELATED_LAB_TEST> SelectRelatedLabTestsDetail(int patientId,
            string labName, string specimenType)
        {
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                return SelectRelatedLabTestsDetailLinqFilter(patientId, labName, specimenType).ToList();
            }
        }


        private IQueryable<RELATED_LAB_TEST> SelectRelatedLabTestsDetailLinqFilter(
            int patientId, string labName, string specimenType)
        {
            IQueryable<RELATED_LAB_TEST> linqFilter = (from e in _db.RELATED_LAB_TESTs
                                                       where e.PATIENT_ID == patientId
                                                       && e.LAB_TEST_NAME.Equals(labName)
                                                       && e.SPECIMEN_TYPE.Equals(specimenType)
                                                       orderby e.LAB_COMPLETE_DATE descending 
                                                       select e);
            return linqFilter;
        }

        private void SetLoadWith(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<RELATED_LAB_TEST>(e => e.STD_INSTITUTION_REQUESTING);
            lo.LoadWith<RELATED_LAB_TEST>(e => e.STD_INSTITUTION_RESULTING);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }
    }

    public class PatientRelatedLabTests
    {
        public int PatientID { get; set; }
        public string LabName { get; set; }
        public string SpecimentType { get; set; }
    }
}
