﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Data;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

namespace CRS_EFR
{
    public enum EfrBaseControlType
    {
        None = 0,
        Label = 1,
        TextBox = 2,
        RadioButtonList = 3,
        DropDownList = 4
    }

    [Serializable()]
    [System.ComponentModel.DataObject]
    public class EFRBaseControlManager : BaseBO
    {


        public List<EFR_VIEW_LOOKUP> SelectLookupList(string lookupCategory)
        {
            using (_db = GetDataContext())
            {
                if (EFRGlobal.ViewLookupAll == null)
                {
                    EFRGlobal.ViewLookupAll = SelectViewLookupAll().ToList();
                }

                List<EFR_VIEW_LOOKUP> entities = (from e in EFRGlobal.ViewLookupAll
                                              where e.LOOKUP_TYPE == lookupCategory
                                              select e).ToList();

                return entities;

            }
        }
        
        /// <summary>
        /// Select all values from VIEW_LOOKUP view
        /// </summary>
        /// <returns></returns>
        private IQueryable<EFR_VIEW_LOOKUP> SelectViewLookupAll()
        {
            IQueryable<EFR_VIEW_LOOKUP> linqFilter = (from e in _db.EFR_VIEW_LOOKUPs
                                    orderby e.LOOKUP_TYPE, e.SORT_ORDER, e.NAME
                                    select e);
            return linqFilter;
        }

    }
}
