﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Linq.Expressions;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager.VITAS
{
    [Serializable()]
    [System.ComponentModel.DataObject]
    public class VitasProviderManager : BaseBO
    {
        private UserAccountManager _user = (UserAccountManager)System.Threading.Thread.CurrentPrincipal;

        public VitasProviderManager() 
        {
            _defaultSortField = "PROVIDER_ID";

        }

        private IQueryable<PROVIDER> LinqAll()
        {
            //populate LinqAll
            IQueryable<PROVIDER> tempLinq = (from e in _db.PROVIDERs
                                                 select e);

            return tempLinq;
        }

        #region Method for Check Existence
        
        public bool ProviderExists(int id)
        {
            using (_db = GetDataContext())
            {
                int count = (from e in _db.PROVIDERs where e.PROVIDER_ID == id select e).Count();
                
                if (count > 0)
                {
                    return true;
                }
                else 
                {
                    return false;
                }
            }
        }

        #endregion

        #region Methods for Select

        public IEnumerable<PROVIDER> Select(string sort, int startRow, int maxRows)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            using (_db = GetDataContext())
            {
                List<PROVIDER> entities;
                entities = SelectLinqFilter().OrderBy(sort).Skip(startRow).Take(maxRows).ToList();

                return entities;
                 
            }
        }

        public int SelectCount(string sort, int startRow, int maxRows)
        {
            using (_db = GetDataContext())
            {
                return SelectLinqFilter().Count();
            }
        }

        private IQueryable<PROVIDER> SelectLinqFilter()
        {
            IQueryable<PROVIDER> linqFilter = LinqAll();
            return linqFilter;
        }

        #endregion

        #region Methods for SelectByID

        public PROVIDER SelectByID(int id)
        {
            using (_db = GetDataContext())
            {
                PROVIDER provider = SelectByIDLinqFilter(id).SingleOrDefault();

                return provider;

            }

        }

        public PROVIDER SelectByNTUserName(string userName)
        {
            using (_db = GetDataContext())
            {
                return (from t in _db.PROVIDERs
                                     where t.NTUSERNAME.Equals(userName)
                                     select t).FirstOrDefault();

            }

        }

        private IQueryable<PROVIDER> SelectByIDLinqFilter(int id)
        {
            IQueryable<PROVIDER> linqFilter = LinqAll();

            linqFilter = from t in linqFilter where t.PROVIDER_ID == id select t;

            return linqFilter;
        }

        #endregion

        #region Methods for SelectBySearchCriteria


        #endregion


        #region EnforceBusinessRules



        #endregion
    }
}
