﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Linq.Expressions;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;
using System.Web.Configuration;

namespace VeteransAffairs.Registries.BusinessManager.VITAS
{
    [Serializable()]
    [System.ComponentModel.DataObject]
    public class ReportingServiceManager
    {
        SSRS.ReportingService2005 _reportingService;


        /// <summary>
        /// Initilze the ReportingServiceManager.
        /// </summary>
        public ReportingServiceManager(string adminUserName, string adminUserPassword, string adminUserdomain)
        {
            _reportingService = new VeteransAffairs.Registries.BusinessManager.SSRS.ReportingService2005();
            _reportingService.Url = GetConfigEntry("ReportingServer") + "/ReportService2005.asmx";
            _reportingService.Credentials = new System.Net.NetworkCredential(adminUserName, adminUserPassword, adminUserdomain);
        }

        /// <summary>
        /// Add a user to report builder model folder 
        /// and to the system policies as a System User
        /// </summary>
        /// <param name="domain"></param>
        /// <param name="userName"></param>
        /// <param name="folderName"></param>
        /// <returns></returns>
        public bool AddUserToReportBuilder(string domain, string userName, string folderName)
        {
            bool result = false;
            bool userFound = false;
            string rolePath;

            try
            {
                SSRS.CatalogItem[] items = _reportingService.ListChildren("/", true);

                foreach (SSRS.CatalogItem item in items)
                {
                    if (item.Name == folderName && item.Type.ToString() == "Folder")
                    {
                        rolePath = item.Path;
                        bool inheritParent;
                        SSRS.Policy[] policies = _reportingService.GetPolicies(item.Path, out inheritParent);
                        SSRS.Policy currentUserPolicy = null;
                        SSRS.Policy[] newPolicies = new SSRS.Policy[policies.Length + 1];
                        int index = 0;

                        foreach (SSRS.Policy policy in policies)
                        {
                            newPolicies[index] = policy;
                            index++;

                            if (policy.GroupUserName.ToLower() == domain.ToLower() + @"\" + userName.ToLower())
                            {
                                userFound = true;
                                result = true;
                            }
                        }

                        if (!userFound)
                        {
                            currentUserPolicy = new SSRS.Policy();

                            SSRS.Role[] roles = new SSRS.Role[2];
                            SSRS.Role role = new SSRS.Role();
                            role.Name = "Browser";
                            role.Description = "Browser";
                            roles[0] = role;
                            role = new SSRS.Role();
                            role.Name = "Report Builder";
                            role.Description = "Report Builder";
                            roles[1] = role;
                            currentUserPolicy.Roles = roles;

                            currentUserPolicy.GroupUserName = domain + @"\" + userName;

                            newPolicies[index] = currentUserPolicy;

                            try
                            {
                                _reportingService.SetPolicies(rolePath, newPolicies);
                                result = AddUserToSystemPolicy(domain, userName, folderName)
                                        && AddUserToHomeFolder(domain, userName, folderName);
                            }
                            catch
                            {
                                result = false;
                            }
                        }

                        break;
                    }
                }
            }
            catch
            {
                result = false;
            }
            return result;
        }

        /// <summary>
        /// Add a user to system policies as a System User
        /// Remove the user from the model folder access if this operation is failed.
        /// </summary>
        /// <param name="domain"></param>
        /// <param name="userName"></param>
        /// <param name="folderName"></param>
        /// <returns></returns>
        private bool AddUserToSystemPolicy(string domain, string userName, string folderName)
        {
            bool result = false;
            bool userFound = false;

            SSRS.Policy[] policies = _reportingService.GetSystemPolicies();
            SSRS.Policy[] newPolicies = new SSRS.Policy[policies.Length + 1];
            int index = 0;

            foreach (SSRS.Policy policy in policies)
            {
                newPolicies[index] = policy;
                index++;
                if (policy.GroupUserName.ToLower() == domain.ToLower() + @"\" + userName.ToLower())
                {
                    userFound = true;
                    result = true;
                    break;
                }
            }

            if (!userFound)
            {
                SSRS.Policy currentUserPolicy = null;
                
                currentUserPolicy = new SSRS.Policy();

                SSRS.Role[] roles = new SSRS.Role[1];
                SSRS.Role role = new SSRS.Role();
                role.Name = "System User";
                role.Description = "System User";
                roles[0] = role;
                currentUserPolicy.Roles = roles;

                currentUserPolicy.GroupUserName = domain + @"\" + userName;

                newPolicies[index] = currentUserPolicy;

                try
                {
                    _reportingService.SetSystemPolicies(newPolicies);
                    result = true;
                }
                catch 
                {
                    RemoveUserFromReportBuilder(userName, folderName);
                    result = false;
                }
            }
            return result;
        }

      

        /// <summary>
        /// Remove a user from system policies as a System User
        /// </summary>
        /// <param name="domain"></param>
        /// <param name="userName"></param>
        /// <param name="folderName"></param>
        /// <returns></returns>
        private bool RemoveUserFromSystemPolicy(string userName)
        {
            bool result = false;
            bool userFound = false;

            SSRS.Policy[] policies = _reportingService.GetSystemPolicies();
            SSRS.Policy[] newPolicies = new SSRS.Policy[policies.Length - 1];
            int index = 0;
            string userNameWithoutDomain = string.Empty;

            foreach (SSRS.Policy policy in policies)
            {
                string[] userInfo = policy.GroupUserName.Split(new char[] { '\\' });
                if (userInfo.Length == 2)
                {
                    userNameWithoutDomain = userInfo[1];
                }
                if (!string.IsNullOrEmpty(userNameWithoutDomain)
                    && userNameWithoutDomain.ToLower() == userName.ToLower())
                {
                    userFound = true;
                }
                else if (index < policies.Length - 1)
                {
                    newPolicies[index] = policy;
                    index++;
                }
            }

            if (userFound)
            {
                try
                {
                    _reportingService.SetSystemPolicies(newPolicies);
                    result = true;
                }
                catch
                {
                    result = false;
                }
            }
            else
            {
                result = true;
            }

            return result;
        }


        /// <summary>
        /// Remove a user from report builder model folder
        /// </summary>
        /// <param name="domain"></param>
        /// <param name="userName"></param>
        /// <param name="folderName"></param>
        /// <returns></returns>
        public bool RemoveUserFromReportBuilder(string userName, string folderName)
        {
            bool result = false;
            bool userFound = false;
            string rolePath;
            SSRS.CatalogItem[] items = _reportingService.ListChildren("/", true);

            foreach (SSRS.CatalogItem item in items)
            {
                if (item.Name == folderName && item.Type.ToString() == "Folder")
                {
                    rolePath = item.Path;
                    bool inheritParent;
                    SSRS.Policy[] policies = _reportingService.GetPolicies(item.Path, out inheritParent);
                    SSRS.Policy[] newPolicies = new SSRS.Policy[policies.Length - 1];
                    int index = 0;
                    string userNameWithoutDomain = string.Empty;

                    foreach (SSRS.Policy policy in policies)
                    {
                        string[] userInfo = policy.GroupUserName.Split(new char[] { '\\' });
                        if (userInfo.Length == 2)
                        {
                            userNameWithoutDomain = userInfo[1];
                        }
                        if (!string.IsNullOrEmpty(userNameWithoutDomain) 
                            && userNameWithoutDomain.ToLower() == userName.ToLower())
                        {
                            userFound = true;
                        }
                        else if (index < policies.Length - 1)
                        {
                            newPolicies[index] = policy;
                            index++;
                        }
                    }

                    if (userFound)
                    {
                        try
                        {
                            _reportingService.SetPolicies(rolePath, newPolicies);
                            result = RemoveUserFromSystemPolicy(userName) 
                                && RemoveUserFromHomeFolder(userName);
                        }
                        catch
                        {
                            result = false;
                        }
                    }
                    else
                    {
                        result = true;
                    }

                    break;
                }
            }
            return result;
        }


        /// <summary>
        /// Add a user to Home folder in SSRS with Report Builder role
        /// Remove the user from the model folder access if this operation is failed.
        /// </summary>
        /// <param name="domain"></param>
        /// <param name="userName"></param>
        /// <param name="folderName"></param>
        /// <returns></returns>
        private bool AddUserToHomeFolder(string domain, string userName, string folderName)
        {
            bool result = false;
            bool userFound = false;

            bool inheritParent;
            SSRS.Policy[] policies = _reportingService.GetPolicies("/", out inheritParent);
            SSRS.Policy currentUserPolicy = null;
            SSRS.Policy[] newPolicies = new SSRS.Policy[policies.Length + 1];
            int index = 0;

            foreach (SSRS.Policy policy in policies)
            {
                newPolicies[index] = policy;
                index++;

                if (policy.GroupUserName.ToLower() == domain.ToLower() + @"\" + userName.ToLower())
                {
                    userFound = true;
                    result = true;
                }
            }

            if (!userFound)
            {
                currentUserPolicy = new SSRS.Policy();

                SSRS.Role[] roles = new SSRS.Role[1];
                SSRS.Role role = new SSRS.Role();
                role.Name = "Report Builder";
                role.Description = "Report Builder";
                roles[0] = role;
                currentUserPolicy.Roles = roles;

                currentUserPolicy.GroupUserName = domain + @"\" + userName;

                newPolicies[index] = currentUserPolicy;

                try
                {
                    _reportingService.SetPolicies("/", newPolicies);
                    result = true;
                }
                catch
                {
                    RemoveUserFromReportBuilder(userName, folderName);
                    result = false;
                }
            }

            return result;
        }


        /// <summary>
        /// Remove user from Home folder in SSRS
        /// </summary>
        /// <param name="userName"></param>
        /// <returns></returns>
        private bool RemoveUserFromHomeFolder(string userName)
        {
            bool result = false;
            bool userFound = false;

            bool inheritParent;
            SSRS.Policy[] policies = _reportingService.GetPolicies("/", out inheritParent);
            SSRS.Policy[] newPolicies = new SSRS.Policy[policies.Length - 1];
            int index = 0;
            string userNameWithoutDomain = string.Empty;

            foreach (SSRS.Policy policy in policies)
            {
                string[] userInfo = policy.GroupUserName.Split(new char[] { '\\' });
                if (userInfo.Length == 2)
                {
                    userNameWithoutDomain = userInfo[1];
                }
                if (!string.IsNullOrEmpty(userNameWithoutDomain)
                    && userNameWithoutDomain.ToLower() == userName.ToLower())
                {
                    userFound = true;
                }
                else if (index < policies.Length - 1)
                {
                    newPolicies[index] = policy;
                    index++;
                }
            }

            if (userFound)
            {
                try
                {
                    _reportingService.SetPolicies("/", newPolicies);
                    result = true;
                }
                catch
                {
                    result = false;
                }
            }
            else
            {
                result = true;
            }
            return result;
        }
        
        /// <summary>
        /// Dispose the web service connection
        /// </summary>
        public void Dispose()
        {
            _reportingService.Dispose();
        }

        /// <summary>
        /// Get an App Settings config entry from web.config file
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        private string GetConfigEntry(string key)
        {
            string Val = string.Empty ;   
            if (WebConfigurationManager.AppSettings.Count > 0)
                    Val = WebConfigurationManager.AppSettings.Get(key);

            return Val;
        }
    }
}
