﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Linq.Expressions;
using System.Text;
using System.Data.Linq;
using System.Reflection;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager.Utilities
{
    [Serializable()]
    [System.ComponentModel.DataObject]
    public class MDWSLog : BaseBO
    {
        private readonly DateTime callStarted;

        public MDWSLog()
        {
            _defaultSortField = "CALL_ID DESC";
            callStarted = DateTime.Now;
        }

        //TLB.Fortify
        //private IQueryable<MDWS_LOG> LinqAll()
        //{
        //    //populate LinqAll
        //    IQueryable<MDWS_LOG> tempLinq = (from e in _db.MDWS_LOGs
        //                                     select e);
        //    return tempLinq;
        //}

        //TLB.Fortify
        //private void SetLoadWith(RegistriesDataAccess db)
        //{
        //    DataLoadOptions lo = new DataLoadOptions();
        //    db.LoadOptions = lo;
        //    db.DeferredLoadingEnabled = false;
        //}

        #region Method for Check Existence

        #endregion

        #region Methods for Select

        #endregion

        #region Methods for SelectByID

        #endregion

        #region Methods for Update

        /// <summary>
        /// Save MDWS Log data to database.
        /// </summary>
        /// <returns></returns>
        public int LogMDWSCall(MDWS_LOG log)
        {
            int returnStatus = 0;

            log.SetAsChangeTrackingRoot(EntityState.New, true);
            log.SetAsInsertOnSubmit();

            MDWS_LOG logCopy = log.Clone();
            returnStatus = Save(logCopy);

            return returnStatus;
        }

        #endregion

        #region EnforceBusinessRules

        public int EnforceBusinessRules(ref MDWS_LOG log)
        {
            return 0;
        }

        #endregion

        #region Private Methods

        private int Save(MDWS_LOG log)
        {
            int returnStatus = 0;
            BOSaveSuccessEventArgs eventArgs = new BOSaveSuccessEventArgs();

            _db = GetDataContext();
            _db.DeferredLoadingEnabled = false;
            log.SynchroniseWithDataContext(_db);

            ChangeSet changeSet = _db.GetChangeSet();

            if (changeSet.Deletes.Count > 0 || changeSet.Inserts.Count > 0
            || changeSet.Updates.Count > 0)
            {
                try
                {
                    returnStatus = -1;
                    eventArgs.SavedItemId = -1;
                    eventArgs.SaveStatusArg = SaveStatus.SaveFail;
                    
                    DateTime now = DateTime.Now;
                    foreach (object o in changeSet.Inserts)
                    {
                        Type type = o.GetType();
                        PropertyInfo propCreated = type.GetProperty("CREATED");
                        propCreated.SetValue(o, callStarted, null);
                        PropertyInfo propUpdated = type.GetProperty("UPDATED");
                        propUpdated.SetValue(o, now, null);
                    }

                    _db.SubmitChanges(ConflictMode.ContinueOnConflict);

                    returnStatus = eventArgs.SavedItemId = log.CALL_ID;
                    eventArgs.SaveStatusArg = SaveStatus.SaveSuccess;
                    //RaiseSaveEvent(this, eventArgs);
                }
                catch (ChangeConflictException)
                {
                    _db.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);

                    returnStatus = eventArgs.SavedItemId = log.CALL_ID;
                    eventArgs.SaveStatusArg = SaveStatus.SaveSuccess;
                    //RaiseSaveEvent(this, eventArgs);
                }
                //catch (Exception ex)
                //{
                //    returnStatus = -1;
                //    eventArgs.SavedItemId = -1;
                //    eventArgs.SaveStatusArg = SaveStatus.SaveFail;
                //    RaiseSaveEvent(this, eventArgs);
                //    Console.Write(ex.Message);
                //}
                
                RaiseSaveEvent(this, eventArgs);
            }
            _db.Dispose();

            return returnStatus;
        }

        #endregion
    }
}
