﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data.Linq;
using System.Linq.Expressions; 
using System.Text;
using System.Web;
using System.Web.UI;
using System.Text.RegularExpressions;
using System.Globalization;
using System.Threading;
using System.Reflection;
using VeteransAffairs.Registries.Business.Utilities;

namespace VeteransAffairs.Registries.BusinessManager.Utilities
{
    public static class LINQExtensions
    {

        //TLB.Fortify
        /// <summary>
        /// extension to find an entity or create one if none found 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="table"></param>
        /// <param name="find"></param>
        /// <param name="create"></param>
        /// <returns></returns>
        //public static T FindOrCreate<T>(this EntitySet<T> table, Func<T, bool> find, Action<T> create) where T : class, new()
        //{
        //    T val = table.FirstOrDefault(find);
        //    if (val == null)
        //    {
        //        val = new T();
        //        create(val);
        //        //table.InsertOnSubmit(val);
        //    }
        //    return val;
        //}

        //TLB.Fortify
        //public static T FindOrCreate<T>(this EntitySet<T> table, Func<T, bool> find) where T : class, new()
        //{
        //    return FindOrCreate(table, find, a => { });
        //} 




        public static IQueryable<T> PatientLike<T>(this IQueryable<T> data, string propertyOrFieldName, string value)
        {
            //string fieldSearch = "LAST_NAME";

            var param = Expression.Parameter(typeof(T), "PATIENT");

            // e => e.WKF_CASE.PATIENT.LAST_NAME.Contains()
            var name = Expression.PropertyOrField(Expression.PropertyOrField(Expression.PropertyOrField(param, "WKF_CASE"), "PATIENT"), propertyOrFieldName);
            var search = Expression.Constant(value, typeof(string));

            var body = Expression.Call(name, "Contains", null, search);

            Expression<Func<T, bool>> lambda;
            if (String.IsNullOrEmpty(value))
            {
                lambda = x => true;
            }
            else
            {
                lambda = Expression.Lambda<Func<T, bool>>(body, param);
            }

            return data.Where(lambda);
        } 
        /// <summary>
        /// extension method converts list to a list of key-value pairs for dropdown binding
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="enumeration">Original list</param>
        /// <returns>Key-Value pair list</returns
        public static IEnumerable<KeyValuePair<int, T>> AsIndexed<T>(this IEnumerable<T> enumeration)
        {    
            // Check to see that enumeration is not null    
            if (enumeration == null)        
                throw new ArgumentNullException("enumeration");    
            int i = 0;    
            foreach (var item in enumeration)    
            {        
                yield return new KeyValuePair<int, T>(i++, item);    
            }
        }

        /// <summary>
        /// Checks whether the source is in a list.
        /// </summary>
        /// <typeparam name="T">The type of node being traversed by the query.</typeparam>
        /// <param name="source">The item to check.</param>
        /// <param name="values">The values to check against.</param>
        /// <returns>true if the item is in the list; otherwise, false.</returns>
        public static bool In<T>(this T source, params T[] values) where T : IEquatable<T>
        {
            if (values == null)
                throw new ArgumentNullException("values");

            return In(source, ((IEnumerable<T>)values));
        }

        /// <summary>
        /// Checks whether the source is in a subquery.
        /// </summary>
        /// <typeparam name="T">The type of node being traversed by the query.</typeparam>
        /// <param name="source">The item to check.</param>
        /// <param name="values">The resultset from the subquery to check against.</param>
        /// <returns>true if the item is in the subquery's result; otherwise, false.</returns>
        public static bool In<T>(this T source, IEnumerable<T> values) where T : IEquatable<T>
        {
            if (source == null)
                throw new ArgumentNullException("source");

            if (values == null)
                throw new ArgumentNullException("values");

            foreach (T listValue in values)
            {
                if ((default(T).Equals(source) && default(T).Equals(listValue)) ||
                    (!default(T).Equals(source) && source.Equals(listValue)))
                {
                    return true;
                }
            }

            return false;
        }


        /// <summary>
        /// Order By extension that works for IEnumerables just like dynamic linq for IQueryables 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="input">IEnumerable to order by</param>
        /// <param name="queryString"></param>
        /// <returns></returns>
        public static IEnumerable<T> OrderBy<T>(this IEnumerable<T> input, string queryString)
        {
            if (string.IsNullOrEmpty(queryString))
                return input;

            int i = 0;
            foreach (string propname in queryString.Split(','))
            {
                var subContent = propname.Split(' ');
                if ( subContent.Length == 1 )
                      
                {
                    if (i == 0)
                        input = input.OrderBy(x => GetPropertyValue(x, subContent[0].Trim()));
                    else
                        input = ((IOrderedEnumerable<T>)input).ThenBy(x => GetPropertyValue(x, subContent[0].Trim()));
                }
                else
                {
                    if (i == 0)
                        input = input.OrderByDescending(x => GetPropertyValue(x, subContent[0].Trim()));
                    else
                        input = ((IOrderedEnumerable<T>)input).ThenByDescending(x => GetPropertyValue(x, subContent[0].Trim()));
                }
                i++;
            }

            return input;
        }

        private static object GetPropertyValue(object obj, string property)
        {
            System.Reflection.PropertyInfo propertyInfo = obj.GetType().GetProperty(property);
            return propertyInfo.GetValue(obj, null);
        } 



    }


    public static class NonLINQExtensions
    {
        /// <summary>
        /// extension method for single character repetition
        /// </summary>
        /// <param name="chatToRepeat">Character to repeat</param>
        /// <param name="repeat">How many times</param>
        /// <returns></returns>
        public static string Repeat(this char chatToRepeat, int repeat)
        {

            return new string(chatToRepeat, repeat);
        }

        /// <summary>
        /// extension method for string pattern repetition 
        /// </summary>
        /// <param name="stringToRepeat">String to repeat</param>
        /// <param name="repeat">How many times</param>
        /// <returns></returns>
        public static string Repeat(this string stringToRepeat, int repeat)
        {
            var builder = new StringBuilder(repeat);
            for (int i = 0; i < repeat; i++)
            {
                builder.Append(stringToRepeat);
            }
            return builder.ToString();
        }

        /// <summary>
        /// extension method for redirect syntax improvement
        /// </summary>
        /// <param name="response">The System.Web.HttpResponse 
        /// to which this method is added.</param>
        /// <param name="newUrl">The target location containing a 
        /// composite format string.</param>
        /// <param name="args">A System.Object to format.</param>
        public static void Redirect(this System.Web.HttpResponse response,
                    string newUrl, params object[] args)
        {
            HttpContext.Current.Response.Redirect(string.Format(newUrl, args));
        }

        /// <summary>
        /// enumerates all controls for a given container
        /// </summary>
        /// <param name="parent">parent container</param>
        /// <returns></returns>
        public static IEnumerable<Control> GetAllControls(this Control parent)
        {
            foreach (Control control in parent.Controls)
            {
                yield return control;
                foreach (Control descendant in control.GetAllControls())
                {
                    yield return descendant;
                }
            }
        }
        /// <summary>
        /// Extension method to return specified length of last characters from a string
        /// </summary>
        /// <param name="stringFrom"></param>
        /// <param name="length">Number of characters</param>
        /// <returns></returns>
        public static string LastChars(this string stringFrom, int length)
        {
            if(string.IsNullOrEmpty(stringFrom)) return string.Empty;
            if (stringFrom.Length < length) return string.Empty;
            return stringFrom.Substring(stringFrom.Length - length, length);
        }


        /// <summary>
        /// Extension method to split sring by a pattern
        /// </summary>
        /// <param name="input">original string</param>
        /// <param name="delimiter">pattern for split</param>
        /// <returns></returns>
        public static string[] Split(this string input, string delimiter)
        {
            return Regex.Split(input, delimiter);   

        }

        /// <summary>
        /// Extension method to convert a string to proper casing
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public static string ToTitleCase(this string input)
        {
            string result = String.Empty; 
            try 
            {                
                TextInfo textInfo = Thread.CurrentThread.CurrentCulture.TextInfo ; 
                result = textInfo.ToTitleCase(input.ToLower()); 
            } 
            catch 
            { 
                result = input; 
            } 
            
            return result; 
     
        }

        /// <summary>
        /// Extension string to split string by separator and preventing
        /// and preventing split on escape character
        /// </summary>
        /// <param name="input"></param>
        /// <param name="separator"></param>
        /// <param name="escapeCharacter"></param>
        /// <returns></returns>
        public static IEnumerable<string> Split(this string input,
                                        string separator,
                                        char escapeCharacter)
        {
            int startOfSegment = 0;
            int index = 0;
            while (index < input.Length)
            {
                index = input.IndexOf(separator, index);
                if (index > 0 && input[index - 1] == escapeCharacter)
                {
                    index += separator.Length;
                    continue;
                }
                if (index == -1)
                {
                    break;
                }
                yield return input.Substring(startOfSegment, index - startOfSegment).Replace(escapeCharacter.ToString(), String.Empty);
                index += separator.Length;
                startOfSegment = index;
            }
            yield return input.Substring(startOfSegment).Replace(escapeCharacter.ToString(), String.Empty);
        }

        /// <summary>
        /// Will get the string value for a given enums value, this will
        /// only work if you assign the StringValue attribute to
        /// the items in your enum.
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static string GetStringValue(this Enum value)
        {
            // Get the type
            Type type = value.GetType();

            // Get fieldinfo for this type
            FieldInfo fieldInfo = type.GetField(value.ToString());

            // Get the stringvalue attributes
            StringValueAttribute[] attribs = fieldInfo.GetCustomAttributes(
                typeof(StringValueAttribute), false) as StringValueAttribute[];

            // Return the first if there was a match.
            if (attribs != null && attribs.Length > 0)
            {
                return attribs[0].StringValue;
            }
            else
            {
                return null;
            }
        }

        public static bool IsNullOrEmpty(this string str)
        {
            return String.IsNullOrEmpty(str); 

        }
        /// <summary>
        /// convenience method for !String.IsNullOrEmpty syntax
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static bool NotNullOrEmpty(this string str)
        {
            return !String.IsNullOrEmpty(str);

        }

        /// <summary>
        /// In CamelCase, adds spaces prior to each Upper Case Character
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        public static string AddSpacesToCamelCase(this string s)
        {

            //if (s.Length == 0)
            //{
            //    return "";
            //}
            //else
            //{
            //    StringBuilder sb = new StringBuilder();

            //    for (int i = 0; i < s.Length; i++)
            //    {
            //        if (i>0 && char.IsUpper(s[i]))
            //        {
            //            sb.Append(" ");
            //        }

            //        sb.Append(s[i]);
            //    }
            //    return sb.ToString();
            //}

            var words = Regex.Split(s, "(?=[A-Z])");

            return words.Length <= 1 ? s : String.Join(" ", words);
        }
    }

   
}


