﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.Linq;
using System.Globalization;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.Business.Utilities;
using System.Data.SqlClient;


namespace VeteransAffairs.Registries.BusinessManager.Utilities
{
    [System.ComponentModel.DataObject]
    public static class DropDownLists
    {
        private static RegistriesCommonManager _commonManager = new RegistriesCommonManager();

        private static RegistriesDataAccess GetDataContext()
        {
            RegistriesDataAccess db = new RegistriesDataAccess();
            return db;
        }

        #region TBI DropDownLists

        public static List<STD_REFERRALST> GetReferralStatusList()
        {
            List<STD_REFERRALST> ReferralStatuses;
            RegistriesDataAccess _db1 = GetDataContext();

            ReferralStatuses = (from e in _db1.STD_REFERRALSTs 
                                   where e.INACTIVE_FLAG == false  
                                   orderby e.SORT_ORDER 
                                   select e).ToList();

           
            _db1.Dispose();


             
            return ReferralStatuses;
        }

        public static List<STD_TBIREFERRALST> GetTBIOtherConsultStatusList()
        {
            List<STD_TBIREFERRALST> tBIOtherConsultStatuses;
            RegistriesDataAccess _db1 = GetDataContext();

            tBIOtherConsultStatuses = (from e in _db1.STD_TBIREFERRALSTs where e.INACTIVE_FLAG == false orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return tBIOtherConsultStatuses;
        }

        //public static List<KeyValuePair<int, string>> GetTBIOtherConsultStatusList()
        //{
        //    using (RegistriesDataAccess _db1 = GetDataContext())
        //    {
        //        var tBIOtherConsultStatuses = (from e in _db1.STD_TBIREFERRALSTs orderby e.SORT_ORDER select new KeyValuePair<int, string>(e.ID, e.NAME));
        //        return tBIOtherConsultStatuses.ToList(); 
        //    }
        //}

        //public static List<KeyValuePair<int, string>> GetTBISheduleStatusList()
        //{
        //    using (RegistriesDataAccess _db1 = GetDataContext())
        //    {
        //        var tBIScheduleStatuses = (from e in _db1.STD_TBISCHEDULESTs orderby e.SORT_ORDER select new KeyValuePair<int, string>(e.ID, e.NAME));
        //        return tBIScheduleStatuses.ToList();
        //    }

        //}

        public static List<STD_TBISCHEDULEST> GetTBISheduleStatusList()
        {
            List<STD_TBISCHEDULEST> tBIScheduleStatuses;
            RegistriesDataAccess _db1 = GetDataContext();

            tBIScheduleStatuses = (from e in _db1.STD_TBISCHEDULESTs where e.INACTIVE_FLAG == false orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return tBIScheduleStatuses;
        }

        //public static List<KeyValuePair<int, string>> GetTBIReferralStatusList()
        //{
        //    using (RegistriesDataAccess _db1 = GetDataContext())
        //    {
        //        var tBIReferralStatuses = (from e in _db1.STD_REFERRALSTs orderby e.SORT_ORDER select new KeyValuePair<int, string>(e.ID, e.NAME));
        //        return tBIReferralStatuses.ToList(); 
        //    }

        //}

        public static List<STD_REFERRALST> GetTBIReferralStatusList()
        {
            List<STD_REFERRALST> tBIReferralStatuses;
            RegistriesDataAccess _db1 = GetDataContext();

            tBIReferralStatuses = (from e in _db1.STD_REFERRALSTs 
                                   where e.INACTIVE_FLAG == false
                                   where e.CODE.StartsWith("TBI_")
                                   orderby e.SORT_ORDER
                                   select e).ToList();

            _db1.Dispose();

            return tBIReferralStatuses;
        }

        public static List<STD_TBIEVALDELAYTYPE> GetTBIDelayTypeList()
        {
            List<STD_TBIEVALDELAYTYPE> tBIDelayTypes;
            RegistriesDataAccess _db1 = GetDataContext();

            tBIDelayTypes = (from e in _db1.STD_TBIEVALDELAYTYPEs where e.INACTIVE_FLAG == false orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return tBIDelayTypes;
        }

        //public static List<KeyValuePair<int, string>> GetTBIDelayTypeList()
        //{
            
        //    using (RegistriesDataAccess _db1 = GetDataContext())
        //    {
        //        var tBIDelayTypes = (from e in _db1.STD_TBIEVALDELAYTYPEs orderby e.SORT_ORDER select new KeyValuePair<int, string>(e.ID, e.NAME));
        //        return tBIDelayTypes.ToList(); 
        //    }
        //}

        public static List<STD_TBITEAMTYPE> GetTBIResponsibleTeam()
        {
            List<STD_TBITEAMTYPE> getTBIResponsibleTeam;
            RegistriesDataAccess _db1 = GetDataContext();

            getTBIResponsibleTeam = (from e in _db1.STD_TBITEAMTYPEs where e.INACTIVE_FLAG == false orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return getTBIResponsibleTeam;
        }

        public static List<STD_GENDER> GetGenderList()
        {
            List<STD_GENDER> genders;
            RegistriesDataAccess _db1 = GetDataContext();
            genders = (from e in _db1.STD_GENDERs orderby e.NAME select e).ToList();

            Func<STD_GENDER, int> genderSelector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }                
                else
                {
                    return 0;
                }
            };

            var result = genders.OrderBy(genderSelector).ThenBy(c => c.NAME).ToList(); 


            _db1.Dispose();

            return result;
        }

        public static List<STD_GENDER> GetVITASGenderList()
        {
            List<STD_GENDER> genders;
            RegistriesDataAccess _db1 = GetDataContext();
            genders = (from e in _db1.STD_GENDERs orderby e.NAME select e).ToList();

            Func<STD_GENDER, int> genderSelector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            genders = genders.OrderBy(genderSelector).ThenBy(c => c.NAME).ToList();
            //var result = genders.Where(c => c.NAME == "Male" || c.NAME == "Female").OrderByDescending(c => c.NAME).ToList(); 
            //var result = genders.Where(c => c.NAME != "Other" && c.NAME != "Unknown").OrderBy(c => c.NAME).ToList();

            //var nonSpecificGenders = genders.Where(c => c.NAME == "Other" || c.NAME == "Unknown").ToList();
           
            //foreach (var gender in nonSpecificGenders){
            //    result.Add(gender);
            //}
          
            _db1.Dispose();

            return genders;


        }
        public static List<STD_MARITALSTATUS> GetMaritalStatusList()
        {
            List<STD_MARITALSTATUS> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            //returnList = (from e in _db1.STD_MARITALSTATUS orderby e.NAME select e).ToList();

            returnList = (from e in _db1.STD_MARITALSTATUS
                            where e.NAME != "Unknown"
                            orderby e.NAME
                            select e).ToList();

            List<STD_MARITALSTATUS> returnListUnknown = (from e in _db1.STD_MARITALSTATUS
                                                       where e.NAME == "Unknown"
                                                        select e).ToList();

            returnList.AddRange(returnListUnknown);

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_RACE> GetRaceList()
        {
            List<STD_RACE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            //returnList = (from e in _db1.STD_RACEs orderby e.NAME select e).ToList();

            returnList = (from e in _db1.STD_RACEs
                          where e.NAME != "Unknown"
                          orderby e.NAME
                          select e).ToList();

            List<STD_RACE> returnListUnknown = (from e in _db1.STD_RACEs
                                                       where e.NAME == "Unknown"
                                                       select e).ToList();

            returnList.AddRange(returnListUnknown);

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_ETHNICITY> GetEthnicityList()
        {
            List<STD_ETHNICITY> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ETHNICITies orderby e.NAME select e).ToList();

            _db1.Dispose();

            return returnList;
        }


        public static List<STD_TBI_FRG> GetTBIFRGList()
        {
            List<STD_TBI_FRG> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_TBI_FRGs orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_SERVICEBRANCH> GetMilitaryServiceBranchList()
        {
            List<STD_SERVICEBRANCH> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            //returnList = (from e in _db1.STD_SERVICEBRANCHes orderby e.NAME select e).ToList();

            returnList = (from e in _db1.STD_SERVICEBRANCHes
                          where e.NAME != "OTHER"
                          orderby e.ID
                          select e).Take(5).ToList();

            // Not needed - stakeholder only wants 5 main services
            //List<STD_SERVICEBRANCH> returnListOther = (from e in _db1.STD_SERVICEBRANCHes
            //                                             where e.NAME == "OTHER"
            //                                             select e).ToList();

            //returnList.AddRange(returnListOther);
            _db1.Dispose();

            return returnList.OrderBy(L => L.NAME).ToList();
        }

        public static List<STD_POLYTRAUMA_ENTRY_TYPE> GetPolytraumaEntryType() {
            List<STD_POLYTRAUMA_ENTRY_TYPE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_POLYTRAUMA_ENTRY_TYPEs
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_MILITARYDUTYST> GetMilitartyServiceStatusList()
        {
            List<STD_MILITARYDUTYST> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_MILITARYDUTYSTs 
                          where e.INACTIVE_FLAG == false
                          orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_TBIDSCHRGST> GetTBIDischargeStatusList()
        {
            List<STD_TBIDSCHRGST> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_TBIDSCHRGSTs 
                          where e.INACTIVE_FLAG == false
                          orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_COMBATLOCATION> GetPolyTraumaCombatLocationList()
        {
            List<STD_COMBATLOCATION> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_COMBATLOCATIONs
                          where e.CODE.StartsWith("PL") && e.NAME != "Other foreign theatre"
                          orderby e.NAME
                          select e).ToList();


            List<STD_COMBATLOCATION> returnListOtherForeignTheater = (from e in _db1.STD_COMBATLOCATIONs
                          where e.CODE.StartsWith("PL") && e.NAME == "Other foreign theatre"
                          orderby e.NAME
                          select e).ToList();

            returnList.AddRange(returnListOtherForeignTheater);
            _db1.Dispose();

            return returnList;
        }

        public static List<STD_TBIEMERGINGETIOLOGY> GetEmergingEtiologyList()
        {
            List<STD_TBIEMERGINGETIOLOGY> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_TBIEMERGINGETIOLOGies
                          where e.INACTIVE_FLAG == false
                          orderby e.SORT_ORDER
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_TBIDISCHARGETO> GetRehabDischargeToList()
        {
            List<STD_TBIDISCHARGETO> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_TBIDISCHARGETOs 
                          where e.INACTIVE_FLAG == false
                          orderby e.SORT_ORDER 
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_TBIDISCHARGETO> GetRehabDischargeToList_InclInactive()
        {
            List<STD_TBIDISCHARGETO> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_TBIDISCHARGETOs
                          orderby e.SORT_ORDER 
                          select e).ToList();
            _db1.Dispose();
            return returnList;
        }

        public static List<STD_TBIDISCHARGETO> GetPTRPRehabDischargeToList() {
            List<STD_TBIDISCHARGETO> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_TBIDISCHARGETOs
                          where e.INACTIVE_FLAG == false && e.CODE != "PTRP"
                          orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_POLYTRAUMA_EMPLOYMENT_STATUS> GetEmploymentStatus()
        {
            List<STD_POLYTRAUMA_EMPLOYMENT_STATUS> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_POLYTRAUMA_EMPLOYMENT_STATUS 
                          where e.INACTIVE_FLAG == false
                          orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_TBIIFOLLOWUPLIST> GetPolyTraumaFollowupList()
        {
            List<STD_TBIIFOLLOWUPLIST> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_TBIIFOLLOWUPLISTs
                          where e.INACTIVE_FLAG == false
                          orderby e.SORT_ORDER
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_TBIINJURYLIST> GetPolyTraumaInjuryDetailList()
        {
            List<STD_TBIINJURYLIST> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_TBIINJURYLISTs
                          where e.INACTIVE_FLAG == false
                          orderby e.SORT_ORDER
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_TBIPROVIDERLOC> GetPolyTraumaProviderLocationList()
        {
            List<STD_TBIPROVIDERLOC> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_TBIPROVIDERLOCs
                          where e.INACTIVE_FLAG == false
                          orderby e.SORT_ORDER
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }



        public static List<STD_INSTITUTION> GetVAMCList()
        {
            List<STD_INSTITUTION> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            DataLoadOptions lo = new DataLoadOptions();
            
            lo.LoadWith<STD_INSTITUTION>(e => e.STD_INSTITUTION_PARENT); //loads parent institution of any institution in order to get the VISN

            _db1.LoadOptions = lo;
            _db1.DeferredLoadingEnabled = false;
            
            IQueryable<STD_INSTITUTION> institutions = (from e in _db1.STD_INSTITUTIONs
                          where
                          //JH 9/10/2009 : Not filtering on inactive dates since the data is external and the logic is unknown to this system
                          //(e.ACTIVATIONDATE == null || e.ACTIVATIONDATE <= _db1.GetSystemDate())
                          //&&
                          //(e.DEACTIVATIONDATE == null || e.DEACTIVATIONDATE >= _db1.GetSystemDate())
                          //&&
                          e.VISN_ID != null 
                          select e);

            returnList = (from e in institutions
                          orderby e.VISN_ID, e.STATIONNUMBER, e.NAME
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_INSTITUTION_PARENT> GetTBIRolesPermittedVAMCList()
        {
            UserAccountManager _user = (UserAccountManager)System.Threading.Thread.CurrentPrincipal;
            
            List<STD_INSTITUTION_PARENT> returnList;
            
            IQueryable<STD_INSTITUTION> filteredInstitutions;

            RegistriesDataAccess _db1 = GetDataContext();

            DataLoadOptions lo = new DataLoadOptions();
            
            lo.LoadWith<STD_INSTITUTION>(e => e.STD_INSTITUTION_PARENT); //loads parent institution of any institution in order to get the VISN

            _db1.LoadOptions = lo;
            _db1.DeferredLoadingEnabled = false;

            if (!_user.IsSuperUser)
            {
                //rule: add filter to return only items within the list of institutions accessible by the user
                List<USER_ROLE> activeUserRoles = (from e in _commonManager.GetAllUserRoles()
                                                        where e.INACTIVE_FLAG == false
                                                        && e.USER_ID == _user.UserId
                                                        && e.STD_ROLE.INACTIVE_FLAG == false
                                                        && e.STD_ROLE.STD_REGISTRY_ID == _user.RegistryId
                                                        && !(e.STD_ROLE.CODE.Contains("POLYTRAUMA"))
                                                        select e).ToList();

                int[] accessibleInstitutions = (from a in activeUserRoles select a.STD_INSTITUTION_ID).Distinct().ToArray();

                filteredInstitutions = (from e in _db1.STD_INSTITUTIONs
                                        where
                                        accessibleInstitutions.Contains(e.ID)
                                        select e);

            }
            else
            {
                filteredInstitutions = (from e in _db1.STD_INSTITUTIONs
                                        select e);
            }


            IQueryable<STD_INSTITUTION_PARENT> institutions = (from e in filteredInstitutions
                          where
                          e.VISN_ID != null
                          &&
                          e.PARENT_ID != null
                          select e.STD_INSTITUTION_PARENT).Distinct();

            returnList = (from e in institutions
                          orderby e.ID
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_INSTITUTION> GetTBIRolesPermittedStationsPerVISN(int VisnId)
        {
            UserAccountManager _user = (UserAccountManager)System.Threading.Thread.CurrentPrincipal;
            
            List<STD_INSTITUTION> returnList;
            
            IQueryable<STD_INSTITUTION> filteredInstitutions;

            RegistriesDataAccess _db1 = GetDataContext();

            DataLoadOptions lo = new DataLoadOptions();
            
            lo.LoadWith<STD_INSTITUTION>(e => e.STD_INSTITUTION_PARENT); //loads parent institution of any institution in order to get the VISN

            _db1.LoadOptions = lo;
            _db1.DeferredLoadingEnabled = false;

            if (!_user.IsSuperUser)
            {
                //rule: add filter to return only items within the list of institutions accessible by the user
                List<USER_ROLE> activeUserRoles = (from e in _commonManager.GetAllUserRoles()
                                                        where e.INACTIVE_FLAG == false
                                                        && e.USER_ID == _user.UserId
                                                        && e.STD_ROLE.STD_REGISTRY_ID == _user.RegistryId
                                                        && e.STD_ROLE.INACTIVE_FLAG == false
                                                        && !(e.STD_ROLE.CODE.Contains("POLYTRAUMA"))
                                                        select e).ToList();

                int[] accessibleInstitutions = (from a in activeUserRoles select a.STD_INSTITUTION_ID).Distinct().ToArray();

                filteredInstitutions = (from e in _db1.STD_INSTITUTIONs
                                        where
                                        accessibleInstitutions.Contains(e.ID)
                                        select e);

            }
            else
            {
                filteredInstitutions = (from e in _db1.STD_INSTITUTIONs
                                        select e);
            }


            IQueryable<STD_INSTITUTION> institutions = (from e in filteredInstitutions
                          where
                          e.VISN_ID == VisnId
                          &&
                          e.PARENT_ID != null
                          select e).Distinct();

            returnList = (from e in institutions
                          orderby e.STATIONNUMBER, e.NAME
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        

        public static List<STD_INSTITUTION> GetVISNStationDivisionList()
        {
            List<STD_INSTITUTION> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            DataLoadOptions lo = new DataLoadOptions();

            lo.LoadWith<STD_INSTITUTION>(e => e.STD_INSTITUTION_PARENT); //loads parent institution of any institution in order to get the VISN

            _db1.LoadOptions = lo;
            _db1.DeferredLoadingEnabled = false;

            IQueryable<STD_INSTITUTION> institutions = (from e in _db1.STD_INSTITUTIONs
                                                        where
                                                            //JH 9/10/2009 : Not filtering on inactive dates since the data is external and the logic is unknown to this system
                                                            //(e.ACTIVATIONDATE == null || e.ACTIVATIONDATE <= _db1.GetSystemDate())
                                                            //&&
                                                            //(e.DEACTIVATIONDATE == null || e.DEACTIVATIONDATE >= _db1.GetSystemDate())
                                                            //&&
                                                        e.VISN_ID != null
                                                        //|| e.STD_FACILITYTYPE_ID == 1009241
                                                        select e);

            returnList = (from e in institutions
                          orderby e.VISN_ID, e.STATIONNUMBER, e.NAME
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_INSTITUTION> GetVISNStationOnlyList()
        {
            List<STD_INSTITUTION> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            DataLoadOptions lo = new DataLoadOptions();

            lo.LoadWith<STD_INSTITUTION>(e => e.STD_INSTITUTION_PARENT); //loads parent institution of any institution in order to get the VISN

            _db1.LoadOptions = lo;
            _db1.DeferredLoadingEnabled = false;

            IQueryable<STD_INSTITUTION> institutions = (from e in _db1.STD_INSTITUTIONs
                                                        where
                                                            //JH 9/10/2009 : Not filtering on inactive dates since the data is external and the logic is unknown to this system
                                                            //(e.ACTIVATIONDATE == null || e.ACTIVATIONDATE <= _db1.GetSystemDate())
                                                            //&&
                                                            //(e.DEACTIVATIONDATE == null || e.DEACTIVATIONDATE >= _db1.GetSystemDate())
                                                            //&&
                                                        e.VISN_ID != null
                                                        && e.STATIONNUMBER.Length == 3
                                                        //|| e.STD_FACILITYTYPE_ID == 1009241
                                                        select e);

            returnList = (from e in institutions
                          orderby e.VISN_ID, e.STATIONNUMBER, e.NAME
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_INSTITUTION> GetVISNOnlyList()
        {
            List<STD_INSTITUTION> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            DataLoadOptions lo = new DataLoadOptions();

            lo.LoadWith<STD_INSTITUTION>(e => e.STD_INSTITUTION_PARENT); //loads parent institution of any institution in order to get the VISN

            _db1.LoadOptions = lo;
            _db1.DeferredLoadingEnabled = false;

            IQueryable<STD_INSTITUTION> institutions = (from e in _db1.STD_INSTITUTIONs
                                                        where
                                                            //JH 9/10/2009 : Not filtering on inactive dates since the data is external and the logic is unknown to this system
                                                            //(e.ACTIVATIONDATE == null || e.ACTIVATIONDATE <= _db1.GetSystemDate())
                                                            //&&
                                                            //(e.DEACTIVATIONDATE == null || e.DEACTIVATIONDATE >= _db1.GetSystemDate())
                                                            //&&
                                                        e.STD_FACILITYTYPE_ID == 1009241
                                                        select e);

            returnList = (from e in institutions
                          orderby e.ID
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_POLYTRAUMA_VAMC> GetPolyTraumaVAMCList()
        {
            //Performance Enhancement

            UserAccountManager currentUser = (UserAccountManager)System.Web.HttpContext.Current.User;

            List<STD_POLYTRAUMA_VAMC> returnList = new List<STD_POLYTRAUMA_VAMC>();

            SqlDataReader sReader = SqlProvider.ExecuteSPReader("RegistryConnectionString", "CRS_SP_GET_POLYTRAUMA_VAMC_BY_USERID", new object[] { currentUser.RegistryId, currentUser.UserId, currentUser.IsSuperUser });
            returnList = new List<STD_POLYTRAUMA_VAMC>();

            while (sReader.Read())
            {
                STD_POLYTRAUMA_VAMC tmpVAMC = new STD_POLYTRAUMA_VAMC();
                tmpVAMC.ID = (int)(sReader["ID"]);
                tmpVAMC.VisnID = (sReader["VISNID"]).ToString();
                tmpVAMC.station_number = (sReader["STATION_NUMBER"]).ToString();
                tmpVAMC.base_station_number = (sReader["BASE_STATION_NUMBER"]).ToString();
                tmpVAMC.institution_id = (int)(sReader["INSTITUTION_ID"]);
                tmpVAMC.Name = (sReader["NAME"]).ToString();

                returnList.Add(tmpVAMC);
            }

            return returnList;

            //List<STD_POLYTRAUMA_VAMC> returnList = GetPolyTraumaVAMCAdminList();

            //if (!currentUser.IsSuperUser)
            //{
            //    int[] instituionPermissions = currentUser.GetInstitutions();
            //    returnList = (from e in returnList
            //                  where instituionPermissions.Contains(e.institution_id)
            //                  orderby e.VisnID, e.station_number, e.Name
            //                  select e).ToList();
            //}

            //return returnList;
        }

        public static List<STD_POLYTRAUMA_VAMC> GetPolyTraumaVAMCAdminList()
        {
            List<STD_POLYTRAUMA_VAMC> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_POLYTRAUMA_VAMCs
                          orderby e.VisnID, e.station_number, e.Name
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }


        public static List<STD_TBIFACILITYSRC> GetTBIFacilitySourceList()
        {
            List<STD_TBIFACILITYSRC> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_TBIFACILITYSRCs 
                          where e.INACTIVE_FLAG == false 
                          orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX> GetSeverityLevelIndexTBIList() {
            List<STD_POLYTRAUMA_SEVERITY_LEVEL_INDEX> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_POLYTRAUMA_SEVERITY_LEVEL_INDEXes
                          where e.INACTIVE_FLAG == false
                          orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_PERSON_LIVING_WITH> GetPersonLivingWith() {
            List<STD_PERSON_LIVING_WITH> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_PERSON_LIVING_WITHs
                          where e.INACTIVE_FLAG == false
                          orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<KeyValuePair<int, string>> GetInsitutionList()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();

            objReturn = (from inst in _db1.STD_INSTITUTIONs orderby inst.STATIONNUMBER, inst.NAME where inst.VISN_ID != null select new KeyValuePair<int, string>(inst.ID, "(" + inst.STATIONNUMBER + ") " + inst.NAME)).ToList();

            _db1.Dispose();

            return objReturn;
        }

        public static List<KeyValuePair<string, string>> GetInsitutionListByName()
        {
            List<KeyValuePair<string, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();

            objReturn = (from inst in _db1.STD_INSTITUTIONs
                    orderby inst.STATIONNUMBER, inst.NAME
                    where inst.VISN_ID != null
                    select new KeyValuePair<string, string>(inst.NAME, "(" + inst.STATIONNUMBER + ") " + inst.NAME)).ToList();

            _db1.Dispose();

            return objReturn;
        }

        public static List<KeyValuePair<string, string>> GetRecallIDs()
        {
            List<KeyValuePair<string, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();

            objReturn = (from e in _db1.IM_RECALLs
                    orderby e.SOURCE_RECALL_ID
                    select new KeyValuePair<string, string>(e.SOURCE_RECALL_ID, e.SOURCE_RECALL_ID)).ToList();

            _db1.Dispose();

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetClinicalReminderList()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();

            objReturn = (from rem in _db1.STD_REMINDERCLASSes orderby rem.DESCRIPTION_TEXT select new KeyValuePair<int, string>(rem.ID, rem.DESCRIPTION_TEXT)).ToList();

            _db1.Dispose();

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetWorkflowTypeList()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            int[] wfTypeIds = { 3, 4 };

            RegistriesDataAccess _db1 = GetDataContext();

            objReturn = (from wft in _db1.STD_WKFCASETYPEs orderby wft.Name where wfTypeIds.Contains(wft.ID) select new KeyValuePair<int, string>(wft.ID, wft.Name)).ToList();

            _db1.Dispose();

            return objReturn;
        }


        /// <summary>
        /// Utility to convert database nulls to empty strings if necessary
        /// </summary>
        /// <param name="input"></param>
        /// <returns></returns>
        public static string ConvertNullToEmptyString(string input)
        {
            return (input == null ? "" : input);
        }

        /// <summary>
        /// Gets all shipment status. Used primarily for Lab kit orders. 
        /// </summary>
        /// <returns></returns>
        public static List<KeyValuePair<int, string>> GetShippingStatus()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();
            objReturn = (from t in _db1.STD_SHIPMENTSTs where t.INACTIVE_FLAG==false select new KeyValuePair<int, string>(t.ID, t.CODE)).ToList();

            _db1.Dispose();

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetServiceBranchList()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            int[] sBranchIds = { 1, 2, 3, 4, 5, 6 };

            RegistriesDataAccess _db1 = GetDataContext();

            objReturn = (from sbs in _db1.QUES_STD_SERVICEBRANCHes  orderby sbs.NAME where sBranchIds.Contains( sbs.ID ) select new KeyValuePair<int, string>(sbs.ID, sbs.NAME)).ToList();

            _db1.Dispose();

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetInjuryLocationList()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            int[] iLocIds = { 1506506, 1617779, 1617777, 1617780 };

            RegistriesDataAccess _db1 = GetDataContext();

            objReturn = (from locs in _db1.STD_COMBATLOCATIONs orderby locs.NAME where iLocIds.Contains( locs.ID ) select new KeyValuePair<int, string>(locs.ID, locs.NAME)).ToList();

            _db1.Dispose();

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetVAMCReferralList()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();

            objReturn = (from refs in _db1.QUES_STD_VAMCs where refs.INACTIVE_FLAG == false select new KeyValuePair<int, string>(refs.ID, refs.NAME)).ToList();

            _db1.Dispose();

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetTestNameList()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();

            objReturn = (from test in _db1.STD_TEST_NAMEs where test.INACTIVE_FLAG == false orderby test.NAME select new KeyValuePair<int, string>(test.ID, test.NAME)).ToList();

            _db1.Dispose();

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetBiomionitoringTestUnits()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();

            objReturn = (from unit in _db1.STD_UNITs where unit.INACTIVE_FLAG == false orderby unit.SORT_ORDER select new KeyValuePair<int, string>(unit.ID, unit.NAME)).ToList();

            _db1.Dispose();

            return objReturn;
        }
        //public static List<KeyValuePair<int, string>> GetTreatmentFacilitiesList()
        //{
        //    RegistriesDataAccess _db1 = GetDataContext();

        //    return (from refs in _db1.QUES_STD_TREATMENT_LOCATIONs  where refs.INACTIVE_FLAG == false select new KeyValuePair<int, string>(refs.ID, refs.NAME)).ToList();

        //}

        /// <summary>
        /// Gets all analysis methods. 
        /// </summary>
        /// <returns></returns>
        public static List<STD_ANALYSISMETHOD> GetAnalysisMethods()
        {
            List<STD_ANALYSISMETHOD> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();
            objReturn = (from t in _db1.STD_ANALYSISMETHODs where t.INACTIVE_FLAG == false select t).ToList();

            _db1.Dispose();

            return objReturn;
        }
        /// <summary>
        /// Gets biomonitoring analysis methods
        /// </summary>
        /// <returns></returns>
        public static List<KeyValuePair<int, string>> GetBiomonitoringAnalysisMethods()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();
            objReturn = (from meth in _db1.STD_ANALYSISMETHODs where meth.INACTIVE_FLAG == false && meth.BIOMONITORING_FLAG == true orderby meth.NAME select new KeyValuePair<int, string>(meth.ID, meth.NAME)).ToList();

            _db1.Dispose();

            CustomComparer cc = new CustomComparer();

            objReturn.Sort(cc);

            return objReturn;

        }

        /// <summary>
        /// Gets interpretation letter signing clinician list
        /// </summary>
        /// <returns></returns>
        public static List<KeyValuePair<int, string>> GetInterpretationLetterSigningClinicianList()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();
            objReturn = (from e in _db1.STD_SIGNING_CLINICIANs orderby e.ID select new KeyValuePair<int, string>(e.ID, e.NAME)).ToList();

            _db1.Dispose();

            CustomComparer cc = new CustomComparer();

            objReturn.Sort(cc);

            return objReturn;

        }
        /// <summary>
        /// Gets fragment analysis types. 
        /// </summary>
        /// <returns></returns>
        public static List<STD_FRAGMENT_ANALYSIS_TYPE> GetFragmentAnalysisTypes()
        {
            List<STD_FRAGMENT_ANALYSIS_TYPE> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();
            objReturn = (from t in _db1.STD_FRAGMENT_ANALYSIS_TYPEs select t).ToList();

            _db1.Dispose();

            return objReturn;
        }

        
        /// <summary>
        /// Gets fragment analyte types. 
        /// </summary>
        /// <returns></returns>
        public static List<KeyValuePair<int, string>> GetAnalytes()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();
            objReturn = (from t in _db1.STD_ANALYTETYPEs 
                   where t.FRAGMENT_FLAG == true && t.INACTIVE_FLAG == false 
                   orderby t.NAME 
                   select new KeyValuePair<int, string>(t.ID, t.NAME)).ToList();

            _db1.Dispose();

            CustomComparer cc = new CustomComparer();
            objReturn.Sort(cc);

            return objReturn;
        
        }
        /// <summary>
        /// Gets biomonitoring analytes
        /// </summary>
        /// <returns></returns>
        public static List<KeyValuePair<int, string>> GetBiomonitoringAnalytes()
        {
            List<KeyValuePair<int, string>> objReturn = null;

            RegistriesDataAccess _db1 = GetDataContext();
            //return (from t in _db1.STD_ANALYTETYPEs where t.INACTIVE_FLAG == false && t.BIOMONITORING_FLAG  == true orderby t.NAME select new KeyValuePair<int, string>(t.ID, t.NAME)).ToList();
            objReturn = (from t in _db1.STD_ANALYTETYPEs where t.INACTIVE_FLAG == false && t.BIOMONITORING_FLAG == true orderby t.NAME select new KeyValuePair<int, string>(t.ID, t.NAME)).ToList();

            _db1.Dispose();

            CustomComparer cc = new CustomComparer();
            objReturn.Sort(cc);

            return objReturn;
            
        }

        /// <summary>
        /// Gets biomonitoring followup durations
        /// </summary>
        /// <returns></returns>
        public static List<KeyValuePair<int, string>> GetBiomonitoringFollowupDurations()
        {
            List<KeyValuePair<int, string>> results = null;
            RegistriesDataAccess _db1 = GetDataContext();
            //return (from t in _db1.STD_ANALYTETYPEs where t.INACTIVE_FLAG == false && t.BIOMONITORING_FLAG  == true orderby t.NAME select new KeyValuePair<int, string>(t.ID, t.NAME)).ToList();
            results = (from t in _db1.STD_DURATIONs orderby t.SORT_ORDER select new KeyValuePair<int, string>(t.ID, t.NAME)).ToList();
            _db1.Dispose();
            return results;

        }

        public static Dictionary<int, string> GetMonthNames()
        {

            DateTimeFormatInfo mfi = new DateTimeFormatInfo(); 
                        
            var dictionary = new Dictionary<int, string>();


            dictionary.Add(0, "(unknown)");
            for (int month = 1; month <= 12; month++)
            {
                dictionary.Add(month, mfi.GetMonthName(month));  
            }

            return dictionary;

        }

        public static Dictionary<int, string> GetMonthDays()
        {

           
            var dictionary = new Dictionary<int, string>();

            dictionary.Add(0, "(unknown)");

            for (int day = 1; day <= 31; day++)
            {
                dictionary.Add(day, day.ToString());
            }

            return dictionary;

        }

        #endregion

        #region DVEIR DropDownLists



        public static List<STD_ER_ICD9_CODE> GetICD9Codes_All()
        {
            return GetICD9Codes(ICD9Types.Unknown);
        }

        public static List<STD_ER_ICD9_CODE> GetICD9Codes_EyeDiagnosticCodes()
        {
            return GetICD9Codes(ICD9Types.EyeDiagnosis);
        }

        public static List<STD_ER_ICD9_CODE> GetICD9Codes_EyeDiagnosticProcedureCodes()
        {
            return GetICD9Codes(ICD9Types.EyeProcedure);
        }

        public static List<STD_ER_ICD9_CODE> GetICD9Codes_NonOcular()
        {
            return GetICD9Codes(ICD9Types.NotEyeDiagnosis | ICD9Types.NotEyeProcedure);
        }

        public static List<STD_ER_ICD9_CODE> GetICD9Codes(ICD9Types types)
        {
            List<STD_ER_ICD9_CODE> returnList = null;
            RegistriesDataAccess db = GetDataContext();
            IQueryable<STD_ER_ICD9_CODE> query = GetICD9Query(db, types).OrderBy(c => c.CODE);
            returnList = query.ToList();
            db.Dispose();
            return returnList;
        }

        /// <summary>
        /// Searches for ICD9 codes of the specified types for descriptions containing words in the text string.
        /// Descriptions may contain any of the words in the search text.
        /// </summary>
        /// <param name="types">Types of ICD9 codes to search for</param>
        /// <param name="text">Search terms separated by ' ', ',', ';', or '|'. An empty string will return all results</param>
        /// <param name="maxSearchTerms">The maximum number of terms to search for. Any terms beyond this limit will be ignored.</param>
        /// <returns></returns>
        public static List<STD_ER_ICD9_CODE> ICD9Search(ICD9Types types, string text, int maxSearchTerms)
        {
            List<STD_ER_ICD9_CODE> returnList = new List<STD_ER_ICD9_CODE>();
            List<string> terms = text.Split(new char[] { ' ', ',', ';', '|' }, StringSplitOptions.RemoveEmptyEntries).ToList(); ;
            if (terms.Count > maxSearchTerms)
                terms = terms.Take(maxSearchTerms).ToList();

            RegistriesDataAccess db = GetDataContext();

            IQueryable<STD_ER_ICD9_CODE> query = GetICD9Query(db, types);
            List<STD_ER_ICD9_CODE> queryList = query.ToList();
            foreach (string term in terms)
                returnList.AddRange(queryList.Where(c => CodeSearch(c.DESCRIPTION_TEXT, term)));
            returnList = returnList.Distinct().OrderBy(c => c.CODE).ToList();

            db.Dispose();

            return returnList;
        }

        private static IQueryable<STD_ER_ICD9_CODE> GetICD9Query(RegistriesDataAccess db, ICD9Types types)
        {
            IQueryable<STD_ER_ICD9_CODE> query = db.STD_ER_ICD9_CODEs.Where(c => !c.INACTIVE_FLAG);
            if ((types & ICD9Types.EyeDiagnosis) > 0)
                query = query.Where(c => c.EYE_DIAGNOSIS_FLAG);
            if ((types & ICD9Types.NotEyeDiagnosis) > 0)
                query = query.Where(c => !c.EYE_DIAGNOSIS_FLAG);
            if ((types & ICD9Types.EyeProcedure) > 0)
                query = query.Where(c => c.EYE_PROCEDURE_FLAG);
            if ((types & ICD9Types.NotEyeProcedure) > 0)
                query = query.Where(c => !c.EYE_PROCEDURE_FLAG);
            return query;
        }

        private static bool CodeSearch(string description, string term)
        {
            bool match = false;

            //replace special characters with spaces
            StringBuilder sb = new StringBuilder();
            foreach (char c in description)
            {
                if ((c >= '0' && c <= '9') || (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') || c == ' ')
                    sb.Append(c);
                else
                    sb.Append(' ');
            }
            string cleanDescription = sb.ToString().ToUpper();
            string cleanTerm = term.ToUpper();

            // partial word search on terms with at least 4 characters.
            // whole word match only for shorter terms
            if (term.Length < 4)
            {
                string paddedDesc = " " + cleanDescription + " ";
                string paddedTerm = " " + cleanTerm + " ";
                if (paddedDesc.ToUpper().Contains(paddedTerm.ToUpper()))
                    match = true;
            }
            else
            {
                if (cleanDescription.Contains(cleanTerm))
                    match = true;
            }
            return match;
        }

        public static List<STD_ER_CPT4_CODE> GetProcedureCodes()
        {
            List<STD_ER_CPT4_CODE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ER_CPT4_CODEs where e.INACTIVE_FLAG == false orderby e.CODE select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_ER_IMG_MTHD> GetImagingMethodologyCodes()
        {
            List<STD_ER_IMG_MTHD> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ER_IMG_MTHDs where e.INACTIVE_FLAG == false orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_ER_INJURY_TYPE> GetInjuryTypes()
        {
            List<STD_ER_INJURY_TYPE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ER_INJURY_TYPEs where e.INACTIVE_FLAG == false orderby e.CODE select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_ER_INJRY_CAUSE> GetInjuryCauses()
        {
            List<STD_ER_INJRY_CAUSE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ER_INJRY_CAUSEs where e.INACTIVE_FLAG == false orderby e.CODE select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_ER_INJRY_METHOD> GetInjuryMethods()
        {
            List<STD_ER_INJRY_METHOD> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ER_INJRY_METHODs where e.INACTIVE_FLAG == false orderby e.CODE select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_ER_INJURY_PLACE> GetInjuryPlaces()
        {
            List<STD_ER_INJURY_PLACE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ER_INJURY_PLACEs where e.INACTIVE_FLAG == false orderby e.CODE select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_ER_ACUITY_MTHD> GetDVEIRAcuityMethods()
        {
            List<STD_ER_ACUITY_MTHD> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ER_ACUITY_MTHDs where e.INACTIVE_FLAG == false orderby e.CODE select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        //JH 5/27/2010 - Removed for DVEIR build 2
        //public static List<STD_ER_COMA_SCALE> GetGlasgowComaScaleCodes()
        //{
        //    List<STD_ER_COMA_SCALE> returnList;
        //    RegistriesDataAccess _db1 = GetDataContext();

        //    returnList = (from e in _db1.STD_ER_COMA_SCALEs where e.INACTIVE_FLAG == false orderby e.SORT_ORDER select e).ToList();

        //    _db1.Dispose();

        //    return returnList;
        //}
        
        public static List<STD_ER_PROSTHETIC_TYPE> GetProstheticDevices()
        {
            List<STD_ER_PROSTHETIC_TYPE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ER_PROSTHETIC_TYPEs where e.INACTIVE_FLAG == false orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }


        public static List<STD_ER_VFQ_QUESTIONNAIRE_TYPE> GetVFQ_QuestionnaireType()
        {
            List<STD_ER_VFQ_QUESTIONNAIRE_TYPE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ER_VFQ_QUESTIONNAIRE_TYPEs where e.INACTIVE_FLAG == false orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_ER_LID_ISSUE> GetStdLidIssue()
        {
            List<STD_ER_LID_ISSUE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ER_LID_ISSUEs where e.INACTIVE_FLAG == false orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_ER_BROW_ISSUE> GetStdBrowIssue()
        {
            List<STD_ER_BROW_ISSUE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_ER_BROW_ISSUEs where e.INACTIVE_FLAG == false orderby e.SORT_ORDER select e).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<T> GetStdIssueFor<T>() where T : LINQEntityBase //System.Data.Linq.Table<T>
        {
            List<T> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            System.Data.Linq.Table<T> myTable = _db1.GetTable(typeof(T)) as Table<T>;

            returnList = myTable.ToList();
            returnList = (from e in returnList
                          where
                              //where e.INACTIVE_FLAG == false orderby e.SORT_ORDER select e).ToList();
                              (bool)(from p in e.GetType().GetProperties()
                                     where p.Name.Equals("INACTIVE_FLAG")
                                     select p.GetValue(e, null)).FirstOrDefault()
                                == false
                          orderby
                                (int)(from p in e.GetType().GetProperties()
                                      where p.Name.Equals("SORT_ORDER")
                                      select p.GetValue(e, null)).FirstOrDefault()
                          select e).ToList();

            _db1.Dispose();

            return returnList;
        }
        #endregion


        #region VITAS DropDownLists

        public static List<STD_STATE> GetStateList()
        {
            List<STD_STATE> states;
            RegistriesDataAccess _db1 = GetDataContext();
            states = (from e in _db1.STD_STATEs orderby e.NAME select e).ToList();

            Func<STD_STATE, int> stateSelector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            var result = states.OrderBy(stateSelector).ThenBy(c => c.NAME).ToList();

            _db1.Dispose();

            return result;


        }

        public static List<STD_IM_SPECIALTY_AREA> GetImplantSpecialtyArea()
        {
            List<STD_IM_SPECIALTY_AREA> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_SPECIALTY_AREAs
                          where e.INACTIVE_FLAG == false && !e.NAME.Equals("Null Value") select e).ToList();

            Func<STD_IM_SPECIALTY_AREA, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ThenBy(c => c.NAME).ToList(); 

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_IM_IMPLANT_TYPE> GetImplantType()
        {
            List<STD_IM_IMPLANT_TYPE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_IMPLANT_TYPEs
                          where e.INACTIVE_FLAG == false && !e.NAME.Equals("Null Value")
                          select e).ToList();

            Func<STD_IM_IMPLANT_TYPE, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ThenBy(c => c.NAME).Distinct(new ImplantEqualityComparer()).ToList(); 

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_IM_DEVICE_STATUS> GetImplantDeviceStatus()
        {
            List<STD_IM_DEVICE_STATUS> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_DEVICE_STATUS
                          where e.INACTIVE_FLAG == false && !e.NAME.Equals("Null Value")
                          select e).ToList();

            Func<STD_IM_DEVICE_STATUS, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ThenBy(c => c.NAME).ToList(); 

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_IM_NO_ACTION_TAKEN> GetActionsNotTakenReasons()
        {
            List<STD_IM_NO_ACTION_TAKEN> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_NO_ACTION_TAKENs
                          where e.INACTIVE_FLAG == false && !e.NAME.Equals("Null Value")
                          select e).ToList();

            Func<STD_IM_NO_ACTION_TAKEN, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ThenBy(c => c.NAME).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_IM_EXPLANTED_REASON> GetReasonExplanted()
        {
            List<STD_IM_EXPLANTED_REASON> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_EXPLANTED_REASONs
                          where e.INACTIVE_FLAG == false && !e.NAME.Equals("Null Value")
                          select e).ToList();

            Func<STD_IM_EXPLANTED_REASON, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ThenBy(c => c.NAME).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_IM_MANUFACTURE> GetImplantManufactures()
        {
            List<STD_IM_MANUFACTURE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_MANUFACTUREs
                          where e.INACTIVE_FLAG == false && !e.NAME.Equals("Null Value")
                          select e).ToList();

            Func<STD_IM_MANUFACTURE, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ThenBy(c => c.NAME).ToList(); 

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_IM_MATERIAL_TYPE> GetImplantMaterialType()
        {
            List<STD_IM_MATERIAL_TYPE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_MATERIAL_TYPEs
                          where e.INACTIVE_FLAG == false && !e.NAME.Equals("Null Value")
                          select e).ToList();

            Func<STD_IM_MATERIAL_TYPE, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ThenBy(c => c.NAME).ToList(); 

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_INSTITUTION> GetImplantFacility()
        {
            List<STD_INSTITUTION> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_INSTITUTIONs
                          where !e.NAME.Equals("Null Value")
                          select e).ToList();

            Func<STD_INSTITUTION, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ThenBy(c => c.NAME).ToList(); 

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_IM_DISTRIBUTOR> GetImplantDistributor()
        {
            List<STD_IM_DISTRIBUTOR> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_DISTRIBUTORs
                          where e.INACTIVE_FLAG == false && !e.NAME.Equals("Null Value")
                          select e).ToList();

            Func<STD_IM_DISTRIBUTOR, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ThenBy(c => c.NAME).ToList(); 

            _db1.Dispose();

            return returnList;
        }


        public static List<STD_IM_INFORMATIN_SOURCE> GetImplantInformationSource()
        {
            List<STD_IM_INFORMATIN_SOURCE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_INFORMATIN_SOURCEs
                          where e.INACTIVE_FLAG == false && !e.NAME.Equals("Null Value")
                          select e).ToList();
            
            Func<STD_IM_INFORMATIN_SOURCE, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ThenBy(c => c.NAME).ToList(); 

            _db1.Dispose();

            return returnList;
        }

        public static List<KeyValuePair<int, string>> GetImplantTypesBySpecialtyArea(int? specialtyAreaId)
        {
            List<KeyValuePair<int, string>> results = null;

            RegistriesDataAccess _db1 = GetDataContext();
            
            //Dictionary<int, string> implantTypes = (from it in _db1.STD_IM_SPECIALTY_AREA_IMPLANT_TYPEs 
            //                                            where it.STD_IM_SPECIALTY_AREA_ID == specialtyAreaId select new KeyValuePair<int, string>(it.ID, it.STD_IM_IMPLANT_TYPE.NAME)).ToDictionary(;

            //var results = _db1.STD_IM_SPECIALTY_AREA_IMPLANT_TYPEs.Where(sa => sa.STD_IM_SPECIALTY_AREA_ID == specialtyAreaId).OrderBy( s => s.STD_IM_IMPLANT_TYPE.NAME).Select( t => t.STD_IM_IMPLANT_TYPE).ToList();

            results = (from items in _db1.STD_IM_IMPLANT_TYPEs where items.STD_IM_SPECIALTY_AREA_IMPLANT_TYPEs.Any(it => it.STD_IM_SPECIALTY_AREA_ID == specialtyAreaId) select new KeyValuePair<int, string>(items.ID, items.NAME)).ToList();

            _db1.Dispose();

            return results; 
        }

        public static List<STD_IM_ACTION_TYPE> GetActionType()
        {
            List<STD_IM_ACTION_TYPE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_ACTION_TYPEs
                          where e.INACTIVE_FLAG == false && !e.NAME.Equals("Null Value")
                          select e).ToList();

            Func<STD_IM_ACTION_TYPE, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            //returnList = returnList.OrderBy(selector).ThenBy(c => c.NAME).ToList();
            returnList = returnList.OrderBy(selector).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_IM_TARGET_DATE> GetRecallTargetDate()
        {
            List<STD_IM_TARGET_DATE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_TARGET_DATEs
                          where e.INACTIVE_FLAG == false && !e.NAME.Equals("Null Value")
                          select e).ToList();

            Func<STD_IM_TARGET_DATE, int> selector = item =>
            {
                if (item.NAME == "Other")
                {
                    return 1;
                }
                else if (item.NAME == "Unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ToList();

            _db1.Dispose();

            return returnList;
        }

        public static List<STD_IM_NOTIFICATION_TYPE> GetVITASNotificationTypes()
        {
            List<STD_IM_NOTIFICATION_TYPE> returnList;
            RegistriesDataAccess _db1 = GetDataContext();

            returnList = (from e in _db1.STD_IM_NOTIFICATION_TYPEs
                          where e.INACTIVE_FLAG == false 
                                && !e.CODE.ToLower().Equals("null value")
                                && !e.CODE.ToLower().Equals("alert")
                          select e).ToList();

            Func<STD_IM_NOTIFICATION_TYPE, int> selector = item =>
            {
                if (item.NAME.ToLower() == "other")
                {
                    return 1;
                }
                else if (item.NAME.ToLower() == "unknown")
                {
                    return 2;
                }
                else
                {
                    return 0;
                }
            };

            returnList = returnList.OrderBy(selector).ToList();

            _db1.Dispose();

            return returnList;
        }


        #endregion


        private class ImplantEqualityComparer : IEqualityComparer<STD_IM_IMPLANT_TYPE> 
        {
            public bool Equals(STD_IM_IMPLANT_TYPE x, STD_IM_IMPLANT_TYPE y) 
            { 
                return (x.NAME.Equals(y.NAME) && x.ID == y.ID); 
            
            } 
            
            public int GetHashCode(STD_IM_IMPLANT_TYPE obj)            
            { 
                
                return obj.ID.GetHashCode(); 
            
            } 
               
        } 

        private class CustomComparer : IComparer<KeyValuePair<int, string>>
        {

            public int Compare(KeyValuePair<int, string> left, KeyValuePair<int, string> right)
            {
                if (left.Value.ToLower() == right.Value.ToLower())
                    return 0;

                if (left.Value.ToLower() == "other")
                    return Int32.MaxValue;

                if (right.Value.ToLower() == "other")
                    return Int32.MinValue;

                return Comparer<string>.Default.Compare(left.Value, right.Value);
            }
        } 

    }

    [Flags]
    public enum ICD9Types
    {
        Unknown =           0,
        EyeDiagnosis =      1 << 0,
        NotEyeDiagnosis =   1 << 1,
        EyeProcedure =      1 << 2,
        NotEyeProcedure =   1 << 3
    }
}
