﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Business;
using System.Data.Linq;


namespace VeteransAffairs.Registries.BusinessManager
{



    public class UnitTestReferenceRangeManager: BaseBO 
    {
        private void SetLoadWith(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();

            lo.LoadWith<STD_ANALYTE_TEST_REFERENCE_RANGE>(e => e.STD_UNIT);
            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false; 
           
        }

        public STD_ANALYTE_TEST_REFERENCE_RANGE GetTestReferenceRange(int testId, int analyteId)
        {
            STD_ANALYTE_TEST_REFERENCE_RANGE entity;
            _db = GetDataContext();
            SetLoadWith(_db);
            entity = (from trr in _db.STD_ANALYTE_TEST_REFERENCE_RANGEs where trr.STD_TEST_NAME_ID == testId && trr.STD_ANALYTE_TYPE_ID == analyteId select trr).FirstOrDefault();
            _db.Dispose();

            return entity;
        }

        public string GetTestUnitNameById(int unitId)
        {
            STD_UNIT entity;
            _db = GetDataContext();
            SetLoadWith(_db);
            entity = (from su in _db.STD_UNITs where su.ID == unitId select su).FirstOrDefault();
            _db.Dispose();

            return entity.NAME;


        }

        public string GetAnalysisMethodById(int methodId)
        {
            STD_ANALYSISMETHOD method;
            _db = GetDataContext();
            //SetLoadWith(_db);
            method = (from am in _db.STD_ANALYSISMETHODs where am.ID == methodId select am).FirstOrDefault();
            _db.Dispose();

            return method.NAME;
        }

        public string GetFragmentAnalysisTypeById(int typeId)
        {
            STD_FRAGMENT_ANALYSIS_TYPE type;
            _db = GetDataContext();
            //SetLoadWith(_db);
            type = (from at in _db.STD_FRAGMENT_ANALYSIS_TYPEs where at.ID == typeId select at).FirstOrDefault();
            _db.Dispose();

            return type.NAME;
        }

        public string GetAnalyteTypeById(int typeId)
        {
            STD_ANALYTETYPE type;
            _db = GetDataContext();
            //SetLoadWith(_db);
            type = (from at in _db.STD_ANALYTETYPEs where at.ID == typeId select at).FirstOrDefault();
            _db.Dispose();

            return type.NAME;
        }

    }
}
