﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Text;
using System.Data;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager
{
    [Serializable]
    public class RolePermissionsManager:BaseBO
    {
        RegistriesCommonManager _commonManager = new RegistriesCommonManager();

         public RolePermissionsManager() 
        {
            _defaultSortField = "ROLE_PERMISSION_ID";
            
        }
        
        
        private IQueryable<ROLE_PERMISSION> LinqAll()
        {
            //populate LinqAll
            return (from e in _db.ROLE_PERMISSIONs 
                    select e);
                //add all business filtering rules 
        
        }

        private void SetLoadWith(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();

            lo.LoadWith<ROLE_PERMISSION>(i => i.STD_APPPAGE_ID );
            
            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }


        #region Methods for Select

        public IEnumerable<ROLE_PERMISSION> Select(string sort, int startRow, int maxRows)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                return SelectLinqFilter().OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
            }
        }

        public int SelectCount(string sort, int startRow, int maxRows)
        {
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                return SelectLinqFilter().Count();
            }
        }

        private IQueryable<ROLE_PERMISSION> SelectLinqFilter()
        {
            IQueryable<ROLE_PERMISSION> linqFilter = LinqAll();
            return linqFilter;
        }

        #endregion

        #region Methods for SelectByID

        public IEnumerable<ROLE_PERMISSION> SelectByID(int id)
        {
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                return SelectByIDLinqFilter(id).ToList();
            }
        }

        private IQueryable<ROLE_PERMISSION> SelectByIDLinqFilter(int id)
        {
            IQueryable<ROLE_PERMISSION> linqFilter = LinqAll();
            
            linqFilter = from t in linqFilter where t.ROLE_PERMISSION_ID == id select t;

            return linqFilter;
        }
        /// <summary>
        /// Returns roles for a selected permission (object?)
        /// </summary>
        /// <param name="permCode"></param>
        /// <returns></returns>
        public int[] SelectRoles(string permCode)
        {
            using(_db = GetDataContext())
            {
                return(( from role in _db.ROLE_PERMISSIONs 
                         join perm in _commonManager.GetAllAppPages() on role.STD_APPPAGE_ID equals perm.ID
                         where perm.CODE == permCode
                         select role.STD_ROLE_ID).ToArray()); 
            }
        }

        public int SelectLeastRestrictiveAccessLevel(int roleId, string permCode)
        {
            using (_db = GetDataContext())
            {
                return (from rolePerm in _db.ROLE_PERMISSIONs
                        join perm in _commonManager.GetAllAppPages() on rolePerm.STD_APPPAGE_ID equals perm.ID
                        where rolePerm.STD_ROLE_ID == roleId && perm.CODE == permCode
                        select rolePerm.STD_ROLE_ID).FirstOrDefault(); //TODO - Change STD_ROLE_CD to ACCESS LEVEL
            }
        }

        #endregion


    }
}
