﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Linq.Dynamic;
using System.Data;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager
{
    [Serializable()]
    [System.ComponentModel.DataObject]
    public class RoleManager : BaseBO
    {
        private RegistriesCommonManager _commonManager = new RegistriesCommonManager();
          
        public RoleManager() 
        {
            _defaultSortField = "ID";
        }
        
        
        private List<STD_ROLE> LinqAll()
        {
            //populate LinqAll
            return _commonManager.GetAllRoles();
        
        }

        private List<STD_ROLE> LinqAllActive()
        {
            //populate LinqAll
            return (from e in _commonManager.GetAllRoles()
                    where e.INACTIVE_FLAG == false
                    select e).ToList();
        }

        private void SetLoadWith(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            
            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }

        private void SetLoadWithForListViews(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            
            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }

        #region Methods for Select

        public IEnumerable<STD_ROLE> Select(string sort, int startRow, int maxRows)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            IEnumerable<STD_ROLE> objReturn = null;

            _db = GetDataContext();
            SetLoadWith(_db);
            objReturn = SelectLinqFilter().OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
            _db.Dispose();

            return objReturn;
        }

        public int SelectCount(string sort, int startRow, int maxRows)
        {
            int objReturn = 0;

            _db = GetDataContext();
            SetLoadWith(_db);
            objReturn = SelectLinqFilter().Count();

            _db.Dispose();

            return objReturn;
        }

        private IQueryable<STD_ROLE> SelectLinqFilter()
        {
            return (from e in _db.STD_ROLEs
                    orderby e.SORT_ORDER
                    select e
                    );
        }

        #endregion

        #region Methods for SelectByID

        public IEnumerable<STD_ROLE> SelectByID(int id)
        {
            IEnumerable<STD_ROLE> objReturn = null;

            _db = GetDataContext();
            SetLoadWith(_db);
            objReturn = SelectByIDLinqFilter(id).ToList();
            _db.Dispose();

            return objReturn;
        }

        private List<STD_ROLE> SelectByIDLinqFilter(int id)
        {
            List<STD_ROLE> linqFilter = LinqAll();

            linqFilter = (from t in linqFilter 
                          where t.ID == id select t).ToList();

            return linqFilter;
        }

        public IEnumerable<STD_ROLE> SelectByCode(string code)
        {
            IEnumerable<STD_ROLE> objReturn = null;

            _db = GetDataContext();
            SetLoadWith(_db);
            objReturn = SelectByCodeLinqFilter(code).ToList();
            _db.Dispose();

            return objReturn;
        }

        private List<STD_ROLE> SelectByCodeLinqFilter(string code)
        {
            List<STD_ROLE> linqFilter = LinqAll();

            linqFilter = (from t in linqFilter
                          where t.CODE == code
                          select t).ToList();

            return linqFilter;
        }

        #endregion

        #region Methods for SelectByRegistryCode

        /// <summary>
        /// Returns active roles per Registry Code
        /// </summary>
        public IEnumerable<STD_ROLE> SelectActiveByRegistryCode(string RegistryCode)
        {
         
            int _registryId = _commonManager.GetRegistryId(RegistryCode);

            _db = GetDataContext();
            SetLoadWithForListViews(_db);

            List<STD_ROLE> entities;
            entities = SelectActiveByRegistryCodeLinqFilter(_registryId).ToList();

                
            _db.Dispose();

            return entities;
        }

        private List<STD_ROLE> SelectActiveByRegistryCodeLinqFilter(int id)
        {
            List<STD_ROLE> linqFilter = LinqAllActive();

            linqFilter = (from t in linqFilter 
                          where t.STD_REGISTRY_ID == id select t).ToList();

            return linqFilter;
        }

        #endregion

    }
}

