﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager
{
    [Serializable()]
    [System.ComponentModel.DataObject]
    public static class RegistriesGlobal
    {
        private static List<USER_ROLE> userRoleAll;
        private static List<STD_ROLE> roleAll;
        private static List<USER> userAll;
        private static List<STD_REGISTRY> registryAll;
        private static List<USER_REGISTRy> userRegistryAll;
        private static USER currentUser;
        private static List<STD_APPPAGE> appPageAll;
        private static List<STD_INSTITUTION> stdInstitutionAll;
        private static List<STD_GUI_CONTROL> stdGuiControlAll;

        /// <summary>
        /// All user roles in USER_ROLE table
        /// </summary>
        public static List<USER_ROLE> UserRoleAll 
        {
            get { return userRoleAll; }
            set { userRoleAll = value; }
        }


        /// <summary>
        /// All the roles in STD_ROLE table
        /// </summary>
        public static List<STD_ROLE> RoleAll
        {
            get { return roleAll; }
            set { roleAll = value; }
        }

        /// <summary>
        /// All the users in USER table
        /// </summary>
        public static List<USER> UserAll
        {
            get { return userAll; }
            set { userAll = value; }
        }

        /// <summary>
        /// All the registries in STD_REGISTRY table
        /// </summary>
        public static List<STD_REGISTRY> RegistryAll
        {
            get { return registryAll; }
            set { registryAll = value; }
        }

        /// <summary>
        /// All the user registries in USER_REGISTRy table
        /// </summary>
        public static List<USER_REGISTRy> UserRegistryAll
        {
            get { return userRegistryAll; }
            set { userRegistryAll = value; }
        }


        /// <summary>
        /// The Current User
        /// </summary>
        public static USER CurrentUser
        {
            get { return currentUser; }
            set { currentUser = value; }
        }

        /// <summary>
        /// All the app pages in STD_APPPAGE table
        /// </summary>
        public static List<STD_APPPAGE> AppPageAll
        {
            get { return appPageAll; }
            set { appPageAll = value; }
        }

        /// <summary>
        /// All the institutions in STD_INSTITUTION table
        /// </summary>
        public static List<STD_INSTITUTION> StdInstitutionAll
        {
            get { return stdInstitutionAll; }
            set { stdInstitutionAll = value; }
        }


        /// <summary>
        /// All the records in STD_GUI_CONTROL table
        /// </summary>
        public static List<STD_GUI_CONTROL> StdGuiControlAll
        {
            get { return stdGuiControlAll; }
            set { stdGuiControlAll = value; }
        }
    }
}
