﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;  
using System.Linq.Dynamic;
using System.Web;
using System.Text;
using System.Data;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager
{
    [Serializable()]
    [System.ComponentModel.DataObject]
    public class PatientManager : BaseBO
    {
        private UserAccountManager _user = (UserAccountManager)System.Threading.Thread.CurrentPrincipal;
        private RegistriesCommonManager _commonManager = new RegistriesCommonManager();

        public PatientManager() 
        {
            _defaultSortField = "PATIENT_ID";
            
        }

        private IQueryable<PATIENT> LinqAll()
        {

            //populate LinqAll
            IQueryable<PATIENT> tempLinq = (from e in _db.PATIENTs
                                                 select e);

            //add all business filtering rules 
            if (!_user.IsSuperUser)
            {
                tempLinq = (from e in _db.PATIENTs
                                join r in _db.USER_ROLEs
                                on e.STD_INSTITUTION_ID equals r.STD_INSTITUTION_ID
                            where r.INACTIVE_FLAG == false
                                && r.USER_ID == _user.UserId
                                && r.STD_ROLE.STD_REGISTRY_ID == _user.RegistryId
                                && r.STD_ROLE.INACTIVE_FLAG == false
                            select e).Distinct();
            }

            //TO DO : Look if need to create a subclass for TBI patients that filter on institution
            return tempLinq;

        }

        //public int? GetPatientIdBySSN(string SSN)
        //{
        //    using (_db = GetDataContext())
        //    {

        //        int? patientId = (from t in _db.PATIENTs where t.SSN == SSN select t.PATIENT_ID).FirstOrDefault();

        //        return patientId;
                
        //    }
        //}

        public string GetPatientICNBySSN(string Snum)
        {
            _db = GetDataContext();
            string patientICN = (from t in _db.vwSurveyPatientUnions where t.Snum == Snum select t.Patient_ICN).FirstOrDefault();

            _db.Dispose();

            return patientICN;
        }

        public string GetPatientICNBySnum(string Snum)
        {
            _db = GetDataContext();
            string patientICN = (from t in _db.vwSurveyPatientUnions where t.Snum == Snum select t.Patient_ICN).FirstOrDefault();

            _db.Dispose();

            return patientICN;
        }

        public string GetPatientNameByICN(string ICN)
        {
            _db = GetDataContext();
            string patientICN = (from t in _db.vwSurveyPatientUnions where t.Patient_ICN == ICN select t.Last_Name + ", " + t.First_Name + " " + t.Middle_Name).FirstOrDefault();

            _db.Dispose();

            return patientICN;
        }

        public string GetPatientNameBySSN(string Snum)
        {
            _db = GetDataContext();
            string patientName = (from t in _db.vwSurveyPatientUnions where t.Snum == Snum select (t.Last_Name + ", " + t.First_Name + " " + t.Middle_Name)).FirstOrDefault();

            _db.Dispose();

            return patientName;
        }
        private void SetLoadWith(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<PATIENT>(e => e.STD_INSTITUTION);
            lo.LoadWith<STD_INSTITUTION>(e => e.STD_INSTITUTION_PARENT);
            lo.LoadWith<PATIENT>(e => e.STD_COMBATLOCATION);
            lo.LoadWith<PATIENT>(e => e.STD_GENDER);
            lo.LoadWith<PATIENT>(e => e.STD_MARITALSTATUS);
            lo.LoadWith<PATIENT>(e => e.STD_RACE);
            lo.LoadWith<PATIENT>(e => e.STD_ETHNICITY);
            lo.LoadWith<PATIENT>(e => e.STD_SERVICEBRANCH);
            
            lo.LoadWith<PATIENT>(e => e.REGISTRY_DEMOGRAPHICs);
            lo.AssociateWith<PATIENT>(p => p.REGISTRY_DEMOGRAPHICs.Where(rd => rd.STD_REGISTRY.ID == _user.RegistryId));
            
            lo.LoadWith<REGISTRY_DEMOGRAPHIC>(e => e.STD_ADDRESSTYPE);
            //lo.LoadWith<REGISTRY_DEMOGRAPHIC>(e => e.STD_STATE);


            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;


        }

        private void SetLoadWithForListViews(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            //lo.LoadWith<PATIENT>(e => e.STD_INSTITUTION);
            lo.LoadWith<STD_INSTITUTION>(e => e.STD_INSTITUTION_PARENT);
            lo.LoadWith<PATIENT>(e => e.STD_SERVICEBRANCH);
            //lo.LoadWith<PATIENT>(e => e.REFERRALs);
            lo.LoadWith<REFERRAL>(e => e.STD_INSTITUTION);

            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }

        #region Method for Check Existence
        
        public bool PatientExists(int id)
        {
            _db = GetDataContext();
            int count = (from e in _db.PATIENTs where e.PATIENT_ID == id select e).Count();
            _db.Dispose();

            if (count > 0)
            {
                return true;
            }
            else 
            {
                return false;
            }
        }

        #endregion

        #region Methods for Select

        public IEnumerable<PATIENT> Select(string sort, int startRow, int maxRows)
        {
            List<PATIENT> entities = null;
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            _db = GetDataContext();

            SetLoadWithForListViews(_db);
            
            entities = SelectLinqFilter().OrderBy(sort).Skip(startRow).Take(maxRows).ToList();

            _db.Dispose();

            return entities;
        }

        public int SelectCount(string sort, int startRow, int maxRows)
        {
            int objReturn = 0;

            _db = GetDataContext();
            SetLoadWithForListViews(_db);
            objReturn = SelectLinqFilter().Count();
            _db.Dispose();

            return objReturn;
        }

        private IQueryable<PATIENT> SelectLinqFilter()
        {
            IQueryable<PATIENT> linqFilter = LinqAll();
            return linqFilter;
        }

        #endregion

        #region Methods for SelectByID

        public PATIENT SelectByID(int id)
        {
            _db = GetDataContext();
            SetLoadWith(_db);
            PATIENT patient = SelectByIDLinqFilter(id).FirstOrDefault();

            if (patient != null)
            {
                patient.SetAsChangeTrackingRoot(true);

                int status = patient.EnforceBusinessRules(true, _db);
            }

            _db.Dispose();

            return patient;

        }

        /// <summary>
        /// Select by Patient ID
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public PATIENT SelectByPatientID(int id)
        {
            _db = GetDataContext();
            PATIENT patient = (from e in _db.PATIENTs
                                where e.PATIENT_ID == id
                                select e).FirstOrDefault();

            _db.Dispose();

            return patient;
        }

        private IQueryable<PATIENT> SelectByIDLinqFilter(int id)
        {
            IQueryable<PATIENT> linqFilter = LinqAll();
            
            linqFilter = from t in linqFilter where t.PATIENT_ID == id select t;

            return linqFilter;
        }

        private IQueryable<PATIENT> SelectBySSNLinqFilter(string ssn)
        {
            IQueryable<PATIENT> linqFilter = LinqAll();

            linqFilter = from t in linqFilter where t.Snum == ssn select t;

            return linqFilter;

        }

        public PATIENT SelectBySSN(string ssn)
        {
            _db = GetDataContext();

            SetLoadWith(_db);
            PATIENT patient = SelectBySSNLinqFilter(ssn).SingleOrDefault();

            if (patient != null)
            {
                patient.SetAsChangeTrackingRoot(true);

                int status = patient.EnforceBusinessRules(true, _db);
            }

            _db.Dispose();

            return patient;
        }

        #endregion


        #region Methods for SelectCriteriaSearch

        public IEnumerable<PATIENT> SelectCriteriaSearch(string fromDate, string toDate, string station, string visn, string snum, string lastName, string status,
            string sort, int startRow, int maxRows, bool searchReferrals)
        {
            IEnumerable<PATIENT> entities = null;
                if (string.IsNullOrEmpty(sort))
                {
                    sort = _defaultSortField;

                }

                _db = GetDataContext();
                SetLoadWithForListViews(_db);
                
                entities = SelectCriteriaSearchLinqFilter(fromDate, toDate, station, visn, snum, lastName, status, searchReferrals).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
                _db.Dispose();

                return entities;

        }

        public int SelectCriteriaSearchCount(string fromDate, string toDate, string station, string visn, string snum, string lastName, string status, string sort, int startRow, int maxRows, bool searchReferrals)
        {
            int objReturn = 0;

            _db = GetDataContext();
            SetLoadWithForListViews(_db);
            objReturn = SelectCriteriaSearchLinqFilter(fromDate, toDate, station, visn, snum, lastName, status, searchReferrals).Count();
            _db.Dispose();

            return objReturn;
        }

        private IQueryable<PATIENT> SelectCriteriaSearchLinqFilter(string startDate, string endDate, string station, string visn, string ssn, string lastName, string status, bool referrals)
        {
            IQueryable<PATIENT> linqFilter = LinqAll();
 
            

            List<Expression<Func<PATIENT, bool>>> whereList = new List<Expression<Func<PATIENT, bool>>>();
            List<Expression<Func<REFERRAL, bool>>> whereReferralList = new List<Expression<Func<REFERRAL, bool>>>();

            //build patient filters 1st            
            //build ssn filter 
            Expression<Func<PATIENT, bool>> ssnExpression;

            if (String.IsNullOrEmpty(ssn))
            {
                ssnExpression = s => true;
            }
            else
            {
                ssnExpression = s => s.Snum.Replace("-", "").Replace(" ", "") == ssn.Replace("-", "").Replace(" ", "");
            }

            whereList.Add(ssnExpression); 
            //last name filter 
            Expression<Func<PATIENT, bool>> lnExpression;

            if (String.IsNullOrEmpty(lastName))
            {
                lnExpression = s => true;

            }
            else
            {
                lnExpression = s => s.LAST_NAME.Contains(lastName);  
            }
             
            whereList.Add(lnExpression);

            foreach (var condition in whereList)
            {
                  
                linqFilter = linqFilter.Where(condition);

            }
            //if we don't search and filter out any referrals stop here 
            if (!referrals)
            {

                return linqFilter;
            }

            //now start buildign referral filters
            Expression<Func<REFERRAL, bool>> startDateExpression;
            if (String.IsNullOrEmpty(startDate))
            {
                startDateExpression = r => true;

            }
            else
            {

                //startDateExpression = s => s.REFERRALs.Any(r => r.REFERRAL_DATE >= DateTime.Parse(startDate));
                startDateExpression = r => r.REFERRAL_DATE >= DateTime.Parse(startDate);
            }

            whereReferralList.Add(startDateExpression);



            //referral end date
            Expression<Func<REFERRAL, bool>> endDateExpression;

            if (String.IsNullOrEmpty(endDate))
            {
                endDateExpression = r => true;

            }
            else
            {

                //endDateExpression = s => s.REFERRALs.Any(r => r.REFERRAL_DATE <= DateTime.Parse(endDate));
                endDateExpression = r => r.REFERRAL_DATE <= DateTime.Parse(endDate);
            }

            whereReferralList.Add(endDateExpression);

            //referral status 
            Expression<Func<REFERRAL, bool>> statusExpression;

            if (String.IsNullOrEmpty(status) || int.Parse(status) == 0)
            {
                statusExpression = r => true;

            }
            else
            {
                //statusExpression = s => s.REFERRALs.Any( r => r.STD_REFERRALSTS_ID == int.Parse(status) );
                statusExpression = r => r.STD_REFERRALSTS_ID == int.Parse(status);
            }

            //whereList.Add(statusExpression); 
            whereReferralList.Add(statusExpression);


            //visn number
            //Expression<Func<PATIENT, bool>> parentvisnExpression;
            Expression<Func<REFERRAL, bool>> visnExpression;
            if (String.IsNullOrEmpty(visn) || int.Parse(visn) == 0)
            {
                visnExpression = r => true;

            }
            else
            {
                
                visnExpression = r => r.STD_INSTITUTION != null && r.STD_INSTITUTION.VISN_ID == int.Parse(visn);

            }

            //whereList.Add(visnExpression); 
            whereReferralList.Add(visnExpression);
            //station expression 
            //Expression<Func<PATIENT, bool>> instExpression;
            Expression<Func<REFERRAL, bool>> instExpression;
            if (String.IsNullOrEmpty(station) || int.Parse(station) == 0)
            {
                instExpression = r => true;

            }
            else
            {

                //instExpression = s => s.REFERRALs.Any( t => t.STD_INSTITUTION_ID == int.Parse(station)) ;
                instExpression = r => r.STD_INSTITUTION_ID == int.Parse(station);
            }

            //whereList.Add(instExpression);
            whereReferralList.Add(instExpression);


            Expression<Func<REFERRAL, bool>> result = whereReferralList[0]; 
            
            //foreach (var condition in whereReferralList.Skip(1))
            //{
            //    result = Combine(result, condition);

            //}
            whereReferralList.Skip(1).ToList().ForEach(expr => result = Combine(result, expr));    
            

            linqFilter = linqFilter.SelectMany(p => p.REFERRALs).Where(result).OfType<TBI_REFERRAL>().Select(p => p.PATIENT).Distinct();
            
            return linqFilter;
        }

        private Expression<Func<T, bool>> Combine<T>(Expression<Func<T, bool>> first, Expression<Func<T, bool>> second)
        {

            var toInvoke = Expression.Invoke(second, first.Parameters.Cast<Expression>());

            return Expression.Lambda<Func<T, bool>>(Expression.AndAlso(first.Body, toInvoke), first.Parameters);

        } 


        //public IEnumerable<PATIENT> SelectByLastNameSearch(string searchString, string sort, int startRow, int maxRows)
        //{
        //    if (string.IsNullOrEmpty(sort))
        //    {
        //        sort = _defaultSortField;

        //    }
            
        //    using (_db = GetDataContext())
        //    {
        //        SetLoadWithForListViews(_db);
        //        IEnumerable<PATIENT> entities;
        //        entities = SelectByLastNameSearchLinqFilter(searchString).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();

        //        return entities;
        //    }
        //}


        //public int SelectByLastNameSearchCount(string searchString, string sort, int startRow, int maxRows)
        //{
        //    using (_db = GetDataContext())
        //    {
        //        SetLoadWithForListViews(_db);
        //        return SelectByLastNameSearchLinqFilter(searchString).Count();
        //    }
        //}

        //private IQueryable<PATIENT> SelectByLastNameSearchLinqFilter(string searchString)
        //{
        //    IQueryable<PATIENT> linqFilter = LinqAll();

        //    linqFilter = from t in linqFilter where t.LAST_NAME.Contains(searchString) select t;

        //    return linqFilter;
        //}

        #endregion

        

  

        #region Methods for Update

        public int Update(PATIENT patient)
        {

            _db = GetDataContext();
            _db.DeferredLoadingEnabled = false;

            int status = patient.EnforceBusinessRules(true, _db);
                
            patient.SynchroniseWithDataContext(_db); //this line traverses all entities, attaching all of them as appropriate to the data context.
                
            try
            {
                _db.SubmitChanges(ConflictMode.ContinueOnConflict);

            }
            catch
            {
                _db.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);
                _db.SubmitChanges(ConflictMode.ContinueOnConflict);  
            }

            _db.Dispose();

            return patient.PATIENT_ID;
        }

        public bool AddSurveyPatient(Survey_Patient surveyPatient)
        {
            bool returnStatus = false;
            BOSaveSuccessEventArgs eventArgs = new BOSaveSuccessEventArgs();

            surveyPatient.SetAsChangeTrackingRoot(EntityState.New, true);
            surveyPatient.SetAsInsertOnSubmit();

            _db = GetDataContext();
            _db.DeferredLoadingEnabled = false;
            surveyPatient.SynchroniseWithDataContext(_db);

            ChangeSet changeSet = _db.GetChangeSet();

            if (changeSet.Inserts.Count > 0)
            {
                try
                {
                    eventArgs.SavedItemId = -1;
                    eventArgs.SaveStatusArg = SaveStatus.SaveFail;

                    _db.SubmitChanges(ConflictMode.ContinueOnConflict);
                    eventArgs.SavedItemId = surveyPatient.SurveyPatientID;
                    returnStatus = true;
                    eventArgs.SaveStatusArg = SaveStatus.SaveSuccess;
                    //RaiseSaveEvent(this, eventArgs);
                }
                catch (ChangeConflictException)
                {
                    _db.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);
                    eventArgs.SavedItemId = surveyPatient.SurveyPatientID;
                    returnStatus = true;
                    //RaiseSaveEvent(this, eventArgs);
                }
                //catch (Exception ex)
                //{
                //    eventArgs.SavedItemId = -1;
                //    eventArgs.SaveStatusArg = SaveStatus.SaveFail;
                //    RaiseSaveEvent(this, eventArgs);
                //    System.Diagnostics.Debug.WriteLine(ex.ToString());
                //    //Console.Write(ex.Message);
                //}

                RaiseSaveEvent(this, eventArgs);
            }
            else
            {
                returnStatus = true;
            }

            _db.Dispose();

            return returnStatus;
        }

        #endregion

        #region EnforceBusinessRules

        public int EnforceBusinessRules(ref PATIENT patient)
        {
            _db = GetDataContext();
            int status = patient.EnforceBusinessRules(false, _db);
            _db.Dispose();

            return 0;
        }


        #endregion

        #region Methods to change foreign key references

        /// <summary>
        /// Method to return a gender entity (STD_GENDER) based on Code
        /// </summary>
        public STD_GENDER getGenderEntityFromCode(string code)
        {
            STD_GENDER newEntity = null;

            _db = GetDataContext();
            newEntity = (from se in _db.STD_GENDERs where se.CODE.Equals(code) select se).FirstOrDefault();
            _db.Dispose();
            
            return newEntity;

        }

        /// <summary>
        /// Method to return a maritalstatus entity (STD_MARITALSTATUS) based on Code
        /// </summary>
        public STD_MARITALSTATUS getMaritalStatusEntityFromCode(string code)
        {
            STD_MARITALSTATUS newEntity = null;

            _db = GetDataContext();
            newEntity = (from se in _db.STD_MARITALSTATUS where se.CODE.Equals(code) select se).FirstOrDefault();
            _db.Dispose();
        
            return newEntity;

        }

        /// <summary>
        /// Method to return a race entity (STD_RACE) based on Code
        /// </summary>
        public STD_RACE getRaceEntityFromCode(string code)
        {
            STD_RACE newEntity = null;

            _db = GetDataContext();
            newEntity = (from se in _db.STD_RACEs where se.HL7CODE.Equals(code) select se).FirstOrDefault();
            _db.Dispose();
        
            return newEntity;

        }

        /// <summary>
        /// Method to return a ethnicity entity (STD_ETHNICITY) based on Code
        /// </summary>
        public STD_ETHNICITY getEthnicityEntityFromCode(string code)
        {
            STD_ETHNICITY newEntity = null;

            _db = GetDataContext();
            newEntity = (from se in _db.STD_ETHNICITies where se.HL7VALUE.Equals(code) select se).FirstOrDefault();
            _db.Dispose();
        
            return newEntity;

        }

        /// <summary>
        /// Method to return a military service branch entity (STD_SERVICEBRANCH) based on Code
        /// </summary>
        public STD_SERVICEBRANCH getServiceBranchEntityFromCode(string code)
        {
            STD_SERVICEBRANCH newEntity = null;

            _db = GetDataContext();
            newEntity = (from se in _db.STD_SERVICEBRANCHes where se.CODE.Equals(code) select se).FirstOrDefault();
            _db.Dispose();
        
            return newEntity;

        }

        /// <summary>
        /// Method to return a military duty status entity (STD_MILITARYDUTYST) based on Code
        /// </summary>
        public STD_MILITARYDUTYST getMilitaryStatusDutyEntityFromCode(string code)
        {
            STD_MILITARYDUTYST newEntity = null;

            _db = GetDataContext();
            newEntity = (from se in _db.STD_MILITARYDUTYSTs where se.CODE.Equals(code) select se).FirstOrDefault();
            _db.Dispose();
        
            return newEntity;

        }

        public STD_ADDRESSTYPE getNewAddressType(string code)
        {
            STD_ADDRESSTYPE newAddressType;

            _db = GetDataContext();
            newAddressType = (from e in _db.STD_ADDRESSTYPEs where e.CODE == code select e).FirstOrDefault();
            _db.Dispose();

            return newAddressType;

        }

        public STD_REGISTRY getNewRegistry(string code)
        {
            STD_REGISTRY newRegistry;

            _db = GetDataContext();
            newRegistry = (from e in _db.STD_REGISTRies where e.CODE == code select e).FirstOrDefault();
            _db.Dispose();

            return newRegistry;

        }

        #endregion


    }
}

