﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq; 
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.Utilities;

namespace VeteransAffairs.Registries.BusinessManager
{
    public class LabResultsTrackingManager: BaseBO
    {

        public LabResultsTrackingManager() 
        {
            _defaultSortField = "LABRESULT_CHANGE_TRACKING_ID desc";
            
        }
        private IQueryable<LABRESULT_CHANGE_TRACKING> LinqAll()
        {
            //populate LinqAll
            IQueryable<LABRESULT_CHANGE_TRACKING> tempLinq = (from e in _db.LABRESULT_CHANGE_TRACKINGs 
                                                      select e);

            //TODO - add all business filtering rules 

            return tempLinq;

        }

        private IQueryable<LABRESULT_CHANGE_TRACKING> SelectByWorkflowLinqFilter(int id)
        {
            var linqFilter = LinqAll();

            linqFilter = from t in linqFilter
                         where t.WKF_CASE_ID == id
                         select t;

            return linqFilter;
        }

        public IEnumerable<LABRESULT_CHANGE_TRACKING> SelectByWorkflow(int id, string sort, int maxRows, int startRow)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;
            }

            IEnumerable<LABRESULT_CHANGE_TRACKING> objReturn = null;

            _db = GetDataContext();
            objReturn = (from t in SelectByWorkflowLinqFilter(id) select t).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
            _db.Dispose();

            return objReturn;
        }

        public int SelectAllCount(int id, string sort, int startRow, int maxRows)
        {
            int objReturn = 0;

            _db = GetDataContext();
            objReturn = SelectByWorkflowLinqFilter(id).Count();
            _db.Dispose();

            return objReturn;
        }

        public int Update(LABRESULT_CHANGE_TRACKING change)
        {
            int objReturn = 0;
            _db = GetDataContext();
            _db.DeferredLoadingEnabled = false;

            change.SynchroniseWithDataContext(_db); //this line traverses all entities, attaching all of them as appropriate to the data context.
            BOSaveSuccessEventArgs eventArgs = new BOSaveSuccessEventArgs();

            try
            {
                _db.SubmitChanges(ConflictMode.ContinueOnConflict);
                eventArgs.SavedItemId = change.LABRESULT_CHANGE_TRACKING_ID;
                eventArgs.SaveStatusArg = SaveStatus.SaveSuccess;
            }
            catch (ChangeConflictException)
            {
                _db.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);
                eventArgs.SavedItemId = change.LABRESULT_CHANGE_TRACKING_ID;
                eventArgs.SaveStatusArg = SaveStatus.SaveSuccess;
            }
            catch //(Exception ex)
            {
                eventArgs.SaveStatusArg = SaveStatus.SaveFail;
            }

            RaiseSaveEvent(this, eventArgs);
            _db.Dispose();
            objReturn = change.LABRESULT_CHANGE_TRACKING_ID;

            return objReturn;
        }
    }
}
