﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Text;
using System.Data;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;
using System.Transactions;


namespace VeteransAffairs.Registries.BusinessManager
{


    [Serializable()]
    public class InstitutionManager : BaseBO
    {
        private RegistriesCommonManager _commonManager = new RegistriesCommonManager();

        public InstitutionManager()
        {
            _defaultSortField = "ID";

        }


        private void SetLoadWith(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();

            lo.LoadWith<STD_INSTITUTION>(i => i.PATIENTs);
            lo.LoadWith<STD_INSTITUTION>(i => i.STD_STATE);
            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;

        }


        #region Methods for Select

        public IEnumerable<STD_INSTITUTION> Select()
        {
            IEnumerable<STD_INSTITUTION> objReturn = null;

            _db = GetDataContext();
            SetLoadWith(_db);
            objReturn = SelectLinqFilter().ToList();
            _db.Dispose();

            return objReturn;
        }

        public IEnumerable<STD_INSTITUTION> Select(string stationNumber)
        {
            IEnumerable<STD_INSTITUTION> objReturn = this.Select();

            if (objReturn != null)
                objReturn = objReturn.Where(w => w.STATIONNUMBER != null);
            if (objReturn != null)
                objReturn = objReturn.Where(w => w.STATIONNUMBER.StartsWith(stationNumber));

            return objReturn;
        }

        public IEnumerable<STD_INSTITUTION> Select(string sort, int startRow, int maxRows)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            IEnumerable<STD_INSTITUTION> objReturn = null;

            _db = GetDataContext();
            SetLoadWith(_db);
            objReturn = SelectLinqFilter().OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
            _db.Dispose();

            return objReturn;
        }

        public int SelectCount(string sort, int startRow, int maxRows)
        {
            int objReturn = 0;

            _db = GetDataContext();
            SetLoadWith(_db);
            objReturn = SelectLinqFilter().Count();
            _db.Dispose();

            return objReturn;
        }

        private IQueryable<STD_INSTITUTION> SelectLinqFilter()
        {
            IQueryable<STD_INSTITUTION> linqFilter = (from e in _db.STD_INSTITUTIONs
                                                      select e);
            return linqFilter;
        }

        #endregion

        #region Methods for SelectByID

        public STD_INSTITUTION SelectByID(int id)
        {
            return (from t in _commonManager.GetAllInstitutions() where t.ID == id select t).FirstOrDefault();
        }

        public STD_INSTITUTION GetInstitutionByInstitutionID(int id)
        {
            return (from t in _commonManager.GetAllInstitutions() where t.ID == id select t).FirstOrDefault();
        }

        public STD_INSTITUTION getInstitutionByStationNumber(string stationNumber)
        {
            return (from t in _commonManager.GetAllInstitutions()
                    where t.STATIONNUMBER == stationNumber
                    select t).FirstOrDefault();
        }

        public System.Nullable<int> getInstitutionIDByStationNumber(string stationNumber)
        {
            System.Nullable<int> id = null;

            if (!string.IsNullOrEmpty(stationNumber))
            {
                STD_INSTITUTION institution = getInstitutionByStationNumber(stationNumber);

                if (institution != null)
                {
                    id = institution.ID;
                }
            }

            return id;
        }


        #endregion

    }
}
