﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Text;
using System.Data;
using System.Data.Linq;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager
{
    public enum WorkFlowActivityTypes
    {
         KitSent = 1,
         SampleSent = 2,
         FragmentSent = 3,
         SampleReceived = 4,
         FragmentReceived = 5,
         LabWorkSent=6,
         LabWorkReceived=7,
         LetterSent = 8
    }

    public class BiomonitoringManager: BaseBO
    {
        public BiomonitoringManager() 
        {
            _defaultSortField = "WKF_CASE_ID";
            
        }
        
        
        private IQueryable<WKF_CASE> LinqAll()
        {
            //populate LinqAll
            return (from e in _db.WKF_CASEs
                    select e); 
            
        }

        private void SetLoadWith(RegistriesDataAccess db)
        {
            DataLoadOptions lo = new DataLoadOptions();
            lo.LoadWith<WKF_CASE>(i => i.PATIENT);
            lo.LoadWith<WKF_CASE>(i => i.REFERRAL);
            lo.LoadWith<WKF_CASE>(i => i.STD_WKFCASEST);
            lo.LoadWith<REFERRAL>(i => i.REFERRAL_DETAILs);
            lo.LoadWith<REFERRAL_DETAIL>(i => i.STD_HEALTHFACTOR);
            lo.LoadWith<PATIENT>(i => i.STD_INSTITUTION);
            db.LoadOptions = lo;
            db.DeferredLoadingEnabled = false;
        }

        public WKF_CASE GetWorkFlowCase(int workFlowCaseId)
        {
            using (_db = GetDataContext())
            {
                SetLoadWith(_db);
                //TODO - Apply institution check
                return (from t in LinqAll() where t.WKF_CASE_ID == workFlowCaseId select t).FirstOrDefault();
            }
        }

        public IEnumerable<WKF_CASE_ACTIVITY> GetCaseActivities(int workFlowCaseId)
        {
            using (_db = GetDataContext())
            {
                DataLoadOptions lo = new DataLoadOptions();
                lo.LoadWith<WKF_CASE_ACTIVITY>(i => i.SHIPPING_DETAILs);
                _db.LoadOptions = lo;
                _db.DeferredLoadingEnabled = false;
                return (from t in _db.WKF_CASE_ACTIVITies where t.WKF_CASE_ID == workFlowCaseId select t).ToList();
            }
        }
        
        /// <summary>
        /// Gets all the referral indicators for the referral id.
        /// </summary>
        /// <param name="referralId"></param>
        /// <returns>IEnumerable<sting></sting></returns>
        public IEnumerable<string> GetReferralIndicators(int referralId)
        {
            using (_db = GetDataContext())
            {
                DataLoadOptions lo = new DataLoadOptions();
                lo.LoadWith<REFERRAL>(i => i.REFERRAL_DETAILs);
                lo.LoadWith<REFERRAL_DETAIL>(i => i.STD_HEALTHFACTOR);
                _db.LoadOptions = lo;
                _db.DeferredLoadingEnabled = false;
                REFERRAL Referral = (from t in _db.REFERRALs where t.REFERRAL_ID==referralId select t).FirstOrDefault();
                return (from t in Referral.REFERRAL_DETAILs select t.STD_HEALTHFACTOR.CODE);
            }
        }
    }
}
    