﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace VeteransAffairs.Registries.Business
{
    //TODO - Move these enums
    public enum WorkflowCaseActivityStatus
    {
        New = 6,
        InProcess=1,
        Completed=2,
        Voided = 3,
        Tracking = 4,
        Received = 5,
        Accepted = 7,
        Closed = 9,
        Interpreted=10,
        AwaitingResults=11

    }
    [Serializable()]
    public partial class WKF_CASE_ACTIVITY
    {
        public bool MarkedForDeletion { get; set; }

        public DateTime? RECEIVED_DATE
        {
            get{
                if (this.SHIPPING_DETAILs == null || this.SHIPPING_DETAILs.Count() == 0)
                return null;
            else
            {
                if (this.SHIPPING_DETAILs[0].RECEIVED_DATE.HasValue)
                    return this.SHIPPING_DETAILs[0].RECEIVED_DATE.Value;
                else
                    return null;
            }
            }
        }

        public string WKF_STATUS
        {
            get
            {
                if (this.STD_WKFACTIVITYSTS_ID == Convert.ToInt16(WorkflowCaseActivityStatus.Tracking)) //TODO - Use enums -Ordered
                    return STD_WKFACTIVITYST.NAME;
                else if (this.STD_WKFACTIVITYSTS_ID == Convert.ToInt16(WorkflowCaseActivityStatus.Received)) //Received. There must be a shipping detail
                {
                    if (SHIPPING_DETAILs[0].RECEIVED_DATE.HasValue)
                        return WorkflowCaseActivityStatus.Received.ToString(); //During demo it was decided to remove this entry from the status table
                }
                else if(this.STD_WKFACTIVITYSTS_ID == Convert.ToInt16(WorkflowCaseActivityStatus.Voided))
                    return SHIPPING_DETAILs[0].STD_SHIPMENTST.NAME;
                return null;
            }
        }

    }
}
