﻿using System;
using System.Collections.Concurrent;

using System.Web.SessionState;

namespace VeteransAffairs.Registries.Business.Utilities
{

    [Serializable]
    public class SessionStore
    {
        private ConcurrentDictionary<string, string> _store;
        private ConcurrentDictionary<string, string> Store
        {
            get
            {
                if (_store == null)
                    _store = new ConcurrentDictionary<string, string>();

                return _store;
            }
        }

        private static SessionStore Instance(HttpSessionState session)
        {
            var sessionStore = session["SessionStore"] as SessionStore;
            if (sessionStore == null)
            {
                sessionStore = new SessionStore();
                session["SessionStore"] = sessionStore;
            }
            return sessionStore;
        }

        public static void Set(string key, string value, HttpSessionState session)
        {
            var sessionStore = Instance(session);

            if (sessionStore.Store.ContainsKey(key))
            {
                string currentValue = default(string);
                sessionStore.Store.TryGetValue(key, out currentValue);
                sessionStore.Store.TryUpdate(key, value, currentValue);
            }
            else
                sessionStore.Store.TryAdd(key, value);

            session["SessionStore"] = sessionStore;
        }

        public static string Get(string key, HttpSessionState session)
        {
            var sessionStore = Instance(session);

            string value = null;

            sessionStore.Store.TryGetValue(key, out value);

            return value;
        }

        public static string Remove(string key, HttpSessionState session)
        {
            var sessionStore = Instance(session);

            string value = null;

            if (sessionStore.Store.ContainsKey(key))
                sessionStore.Store.TryRemove(key, out value);

            return value;
        }
    }
}
