﻿using System;
using System.Collections.Concurrent;

using System.Web.SessionState;

namespace VeteransAffairs.Registries.Business.Utilities
{

    [Serializable]
    public class SessionStore<T>
    {
        private ConcurrentDictionary<string, T> _store;
        private ConcurrentDictionary<string, T> Store
        {
            get
            {
                if (_store == null)
                    _store = new ConcurrentDictionary<string, T>();

                return _store;
            }
        }

        private static string Key
        {
            get
            {
                return string.Format("SessionStore:{0}", typeof(T).Name);
            }
        }

        public static SessionStore<T> Instance(HttpSessionState session)
        {
            var sessionStore = session[Key] as SessionStore<T>;
            if (sessionStore == null)
            {
                sessionStore = new SessionStore<T>();
                session[Key] = sessionStore;
            }
            return sessionStore;
        }

        public static void Set(string key, T value, HttpSessionState session)
        {
            var sessionStore = Instance(session);

            if (sessionStore.Store.ContainsKey(key))
            {
                T currentValue = default(T);
                sessionStore.Store.TryGetValue(key, out currentValue);
                sessionStore.Store.TryUpdate(key, value, currentValue);
            }
            else
                sessionStore.Store.TryAdd(key, value);

            session[Key] = sessionStore;
        }

        public static T Get(string key, HttpSessionState session)
        {
            var sessionStore = Instance(session);

            T value = default(T);

            sessionStore.Store.TryGetValue(key, out value);

            return value;
        }

        public static T Remove(string key, HttpSessionState session)
        {
            var sessionStore = Instance(session);

            T value = default(T);

            if (sessionStore.Store.ContainsKey(key))
                sessionStore.Store.TryRemove(key, out value);

            session[Key] = sessionStore;

            return value;
        }
    }
}
