﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Configuration;
using AntiXssEnc = Microsoft.Security.Application;

namespace VeteransAffairs.Registries.Business.Utilities
{
    public static class Helpers
    {
        public const int InvalidSta3n = 0;

        private static string[] _countries = new string[] { 
         "Afghanistan", "Albania", "Algeria", "American Samoa", "Andorra", 
         "Angola", "Anguilla", "Antarctica", "Antigua And Barbuda", "Argentina", 
         "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan",
		   "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus",
		   "Belgium", "Belize", "Benin", "Bermuda", "Bhutan",
		   "Bolivia", "Bosnia Hercegovina", "Botswana", "Bouvet Island", "Brazil",
		   "Brunei Darussalam", "Bulgaria", "Burkina Faso", "Burundi", "Byelorussian SSR",
		   "Cambodia", "Cameroon", "Canada", "Cape Verde", "Cayman Islands",
		   "Central African Republic", "Chad", "Chile", "China", "Christmas Island",
		    "Colombia", "Comoros", "Congo", "Cook Islands",
		   "Costa Rica", "Cote D'Ivoire", "Croatia", "Cuba", "Cyprus",
		   "Czech Republic", "Czechoslovakia", "Denmark", "Djibouti", "Dominica",
		   "Dominican Republic", "East Timor", "Ecuador", "Egypt", "El Salvador",
		   "England", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia",
		   "Falkland Islands", "Faroe Islands", "Fiji", "Finland", "France",
		   "Gabon", "Gambia", "Georgia", "Germany", "Ghana",
		   "Gibraltar", "Great Britain", "Greece", "Greenland", "Grenada",
		   "Guadeloupe", "Guam", "Guatemela", "Guernsey", "Guiana",
		   "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Heard Islands",
		   "Honduras", "Hong Kong", "Hungary", "Iceland", "India",
		   "Indonesia", "Iran", "Iraq", "Ireland", "Isle Of Man",
		   "Israel", "Italy", "Jamaica", "Japan", "Jersey",
		   "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Korea, South",
		   "Korea, North", "Kuwait", "Kyrgyzstan", "Lao People's Dem. Rep.", "Latvia",
		   "Lebanon", "Lesotho", "Liberia", "Libya", "Liechtenstein",
		   "Lithuania", "Luxembourg", "Macau", "Macedonia", "Madagascar",
		   "Malawi", "Malaysia", "Maldives", "Mali", "Malta",
		   "Mariana Islands", "Marshall Islands", "Martinique", "Mauritania", "Mauritius",
		   "Mayotte", "Mexico", "Micronesia", "Moldova", "Monaco",
		   "Mongolia", "Montserrat", "Morocco", "Mozambique", "Myanmar",
		   "Namibia", "Nauru", "Nepal", "Netherlands", "Netherlands Antilles",
		   "Neutral Zone", "New Caledonia", "New Zealand", "Nicaragua", "Niger",
		   "Nigeria", "Niue", "Norfolk Island", "Northern Ireland", "Norway",
		   "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea",
		   "Paraguay", "Peru", "Philippines", "Pitcairn", "Poland",
		   "Polynesia", "Portugal", "Puerto Rico", "Qatar", "Reunion",
		   "Romania", "Russian Federation", "Rwanda", "Saint Helena", "Saint Kitts",
		   "Saint Lucia", "Saint Pierre", "Saint Vincent", "Samoa", "San Marino",
		   "Sao Tome and Principe", "Saudi Arabia", "Scotland", "Senegal", "Seychelles",
		   "Sierra Leone", "Singapore", "Slovakia", "Slovenia", "Solomon Islands",
		   "Somalia", "South Africa", "South Georgia", "Spain", "Sri Lanka",
		   "Sudan", "Suriname", "Svalbard", "Swaziland", "Sweden",
		   "Switzerland", "Syrian Arab Republic", "Taiwan", "Tajikista", "Tanzania",
		   "Thailand", "Togo", "Tokelau", "Tonga", "Trinidad and Tobago",
		   "Tunisia", "Turkey", "Turkmenistan", "Turks and Caicos Islands", "Tuvalu",
		   "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States",
		   "Uruguay", "Uzbekistan", "Vanuatu", "Vatican City State", "Venezuela",
		   "Vietnam", "Virgin Islands", "Wales", "Western Sahara", "Yemen",
		   "Yugoslavia", "Zaire", "Zambia", "Zimbabwe"};

        public static int ExtractSta3n(string s)
        {
            if (string.IsNullOrEmpty(s) || s.Length < 3)
                return InvalidSta3n;
            s = s.Substring(0, 3);
            int result;
            if (int.TryParse(s, out result))
                return result;
            return InvalidSta3n;
        }

        /// <summary>
        /// Returns an array with all countries
        /// </summary>     
        public static StringCollection GetCountries()
        {
            StringCollection countries = new StringCollection();
            countries.AddRange(_countries);
            return countries;
        }

        /// <summary>
        /// Returns sorted list of all countries
        /// </summary>
        /// <param name="insertEmpty"></param>
        /// <returns></returns>
        public static SortedList GetCountries(bool insertEmpty)
        {
            SortedList countries = new SortedList();
            if (insertEmpty)
                countries.Add("", "Please select one...");
            foreach (String country in _countries)
                countries.Add(country, country);
            return countries;
        }

        /// <summary>
        /// highlights controls on selection 
        /// </summary>
        /// <param name="container"></param>
        /// <param name="className"></param>
        public static void SetInputControlsHighlight(Control container, string className)
        {
            foreach (Control ctl in container.Controls)
            {
                if (ctl is TextBox || ctl is DropDownList ||
                    ctl is ListBox || ctl is CheckBox || ctl is RadioButton ||
                    ctl is RadioButtonList || ctl is CheckBoxList)
                {
                    WebControl wctl = ctl as WebControl;
                    if (wctl != null)
                    {
                        wctl.Attributes.Add("onfocus", string.Format("this.className = '{0}';", className));
                        wctl.Attributes.Add("onblur", "this.className = '';");
                    }
                }
                else
                {
                    if (ctl.Controls.Count > 0)
                        SetInputControlsHighlight(ctl, className);
                }
            }
        }

        public static Boolean isInteger(string valueToCheck)
        {
            long _tempInt;

            try
            {
                _tempInt = Convert.ToInt64(valueToCheck);
                return true;
            }
            catch
            {
                return false;
            }
        }

        public static Boolean isString(string valueToCheck)
        {
            string _tempString;

            try
            {
                _tempString = valueToCheck.ToString();
                return true;
            }
            catch
            {
                return false;
            }
        }

        public static string GetConfigEntry(string key)
        {
            string Val = string.Empty;
            if (WebConfigurationManager.AppSettings.Count > 0)
                Val = WebConfigurationManager.AppSettings.Get(key);

            return Val;
        }

        public static string GetDBConfigEntry(string key)
        {
            RegistriesLinqDataContext dc = new RegistriesLinqDataContext();

            var setting = (from s in dc.CRS_SETTINGSs
                           where s.NAME == key
                           select s.VALUE).SingleOrDefault();

            if (setting == null)
                setting = "";

            return setting;
        }

        /// <summary>
        /// FixStringToPreventXss: Run string thru Microsoft AntiXss Encoder
        /// </summary>
        /// <returns>Encoded string</returns>
        public static string FixStringToPreventXss(string stringToFix)
        {
            return AntiXssEnc.Encoder.HtmlEncode(stringToFix);
        }

        /// <summary>
        /// getCurrentServiceToUse: pulls from settings.  If null, returns MDWS, else returns either MDWS or VIA
        /// </summary>
        /// <returns></returns>
        public static string getCurrentServiceToUse(string configEntry)
        {        
            string resultStr = "VIA"; // We only use VIA now

            /*
            try
            {
                var setting = GetDBConfigEntry(configEntry);

                if (setting != null)
                {
                    switch (setting.ToString().ToLower())
                    {
                        case "mdws":
                            resultStr = "MDWS";
                            break;
                        case "via":
                            resultStr = "VIA";
                            break;
                        default:
                            resultStr = "MDWS";
                            break;
                    }
                }
            }
            catch (Exception e)
            {
                throw e;
                //Logging.WriteLogToFile("Error in GetCurrentServiceToUse(): " + e.Message);
            }
            */

            return resultStr;
        }

        public static int getIntFromString(string inString)
        {
            int returnInt = 0;

            int tempInt;
            bool result = int.TryParse(inString, out tempInt);
            if (result)
            {
                returnInt = tempInt;
            }

            return returnInt;
        }

        public static bool IsSessionVariableNullOrEmpty(object sessionVariable)
        {
            return string.IsNullOrEmpty(GetStringFromSessionVariable(sessionVariable));
        }

        public static string GetStringFromSessionVariable(object sessionVariable)
        {
            string result = string.Empty;

            if (sessionVariable != null)
            {
                result = sessionVariable.ToString();
            }

            return result;
        }

        public static int? getNullableIntFromString(string inString)
        {
            int? returnInt = null;

            int tempInt;
            bool result = int.TryParse(inString, out tempInt);
            if (result)
            {
                returnInt = tempInt;
            }

            return returnInt;
        }

        public static string getStringFromNullableInt(int? inInt)
        {
            string returnString = "";

            if (inInt.HasValue)
            {
                returnString = inInt.ToString();
            }

            return returnString;
        }

        public static DateTime? getNullableDateFromString(string inString)
        {
            DateTime? returnDate = null;

            DateTime tempDate;
            bool result = DateTime.TryParse(inString, out tempDate);
            if (result)
            {
                returnDate = tempDate;
            }

            return returnDate;
        }

        public static Char? getNullableCharFromString(string inString)
        {
            Char? returnChar = null;

            Char tempChar;
            bool result = Char.TryParse(inString, out tempChar);
            if (result)
            {
                returnChar = tempChar;
            }

            return returnChar;
        }

        public static string getNullableStringFromString(string inString)
        {
            string returnString = null;

            if (!String.IsNullOrEmpty(inString))
            {
                returnString = inString;
            }

            return returnString;
        }

        public static string getShortDateStringFromNullableDate(DateTime? inDate)
        {
            string returnString = "";

            if (inDate.HasValue)
            {
                returnString = Convert.ToDateTime(inDate).ToShortDateString();

            }

            return returnString;
        }
    }
}