#!/usr/bin/perl

###################################################################################
##
## This script is to be used to update the RegistriesLinqDataContext.designer.cs
## for the Fortify updates we need. 
##
## Steps:
##
## 1) Make whatever DBML updates are needed via the Design interface. This will 
##    generate a new file - RegistriesLinqDataContext.designer.cs.
## 2) Save the new RegistriesLinqDataContext.designer.cs file in a loca folder 
##    along with this Perl script.
## 3) Run the Perl script to do the replaces as seen below. It will generate a new 
##    output file named "RegistriesLinqDataContext.designer.output.cs"
## 4) Overwrite the contents of the auto-generated RegistriesLinqDataContext.designer.cs
##    with the contents of the RegistriesLinqDataContext.designer.output.cs file
##
## NOTE: There may be minor differences that require code updates after this is done.
##       For example, in some cases "Snum" may need to be modified to "snum" in a 
##       code file. This is a rare occurence however.
##
###################################################################################

open (InputDBML, "<RegistriesLinqDataContext.designer.cs") || die "Can't find RegistriesLinqDataContext.designer.cs\n";
open (OutputDBML, '>RegistriesLinqDataContext.designer.output.cs');
$x=0;

my $currDateTime = localtime(); 
my $line;
my $alreadyRun = "no"; 

while (my $info = <InputDBML>) {
	
	$line = $info;
	
	if (index($line, "Updated By DBML_Transformer") != -1) {
		print "Script has already been executed";
		<>;
		print OutputDBML "Script has already been executed, aborting";
		die "Script has been executed already\n";
		}

#	$line =~ s{</auto-generated>}{</auto-generated>\n//\n// Updated By DBML_Transformer: $currDateTime};
	$line =~ s{<auto-generated>}{\n// Updated By DBML_Transformer (DBML_Transformer.pl in the Utilities folder): $currDateTime\n//\n// <auto-generated>};
	
	# Change connection string	
	$line =~ s/RegistryConnectionString/RegistryDALConnectionString/;
	
	# Change SSN to Snum	
	$line =~ s/Storage="_SSN",/Name = "SSN", Storage = "_Snum",/;
	$line =~ s/public string SSN/public string Snum/;
	$line =~ s/_SSN/_Snum/;
	
	#Storage="_patientSSN"
	
	$line =~ s/Storage="_patientssn"/Name = "patientssn", Storage = "_patientsnum"/;
	$line =~ s/Storage="_PatientSSN"/Name = "PatientSSN", Storage = "_PatientSnum"/;
	$line =~ s/Storage="_PATIENTSSN"/Name = "PATIENTSSN", Storage = "_PATIENTSNUM"/;
	$line =~ s/Storage="_patientSSN"/Name = "patientSSN", Storage = "_patientSnum"/;
	
	$line =~ s/_patientssn/_patientsnum/;  
	$line =~ s/_PatientSSN/_PatientSnum/;  
	$line =~ s/_PATIENTSSN/_PATIENTSNUM/;  
	  
	$line =~ s/ patientSSN/ patientSnum/;
	$line =~ s/_patientSSN/_patientSnum/;
	$line =~ s/ patientssn/ patientsnum/;
	$line =~ s/ PatientSSN/ PatientSnum/;
	$line =~ s/ PATIENTSSN/ PATIENTSNUM/;
	$line =~ s/\Q("patientSSN"\E/("patientSnum"/;
	$line =~ s/\Q("patientssn"\E/("patientsnum"/;
	$line =~ s/\Q("patientssn"\E/("patientsnum"/;
	$line =~ s/\Q("PATIENTSSN"\E/("PATIENTSNUM"/;
	$line =~ s/\Q("PatientSSN"\E/("PatientSnum"/;
	
	$line =~ s/Onpatientssn/Onpatientsnum/;  
	$line =~ s/OnPatientSSN/OnPatientSnum/;  
	$line =~ s/OnPATIENTSSN/OnPATIENTSNUM/; 
	$line =~ s/OnpatientSSN/OnpatientSnum/;  
	
	$line =~ s/OnSSN/OnSnum/;
	$line =~ s/\QSendPropertyChanged("SSN"\E/SendPropertyChanged("Snum"/;
	$line =~ s/\QSendPropertyChanged("SSN"\E/SendPropertyChanged("Snum"/;

	$line =~ s/Storage="_NewSSN"/Name="NewSSN", Storage="_NewSnum"/;
	$line =~ s/ NewSSN/ NewSnum/;
	$line =~ s/_NewSSN/_NewSnum/;
	
	$line =~ s/public event PropertyChang/[field: System.NonSerialized()] \n\t\tpublic event PropertyChang/;

	print OutputDBML $line 
}

close InputDBML || die "Couldn't close RegistriesLinqDataContext.designer.cs";

print "Completed transformation";
<>;
##exit (0);