﻿using BitFactory.Logging;
using System.Configuration;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using Microsoft.Practices.EnterpriseLibrary.Data;

namespace VeteransAffairs.Registries.Business.Utilities
{
    public class CoreLogging
    {
        public static void WriteLogToFile(string LoginUserID, Exception ex)
        {
            string message = "Login UserId: " + LoginUserID + ":::Error: " +
                             ex.Message.ToString() + " ::: " + ex.StackTrace.ToString();

            WriteLogToFile(message);
        }

        public static void WriteLogToFile(string LoginUserID, string error)
        {
            string message = "Login UserId: " + LoginUserID + ":::Error: " + error;

            WriteLogToFile(message);
        }

        public static void WriteLogToFile(string message)
        {
            string path = GetLogLocation();

            Logger l = new FileLogger(path);

            l.LogError(message);

            if (ConfigurationManager.AppSettings["LogToDB"].ToString().Trim() == "true")
            {
                var returnVal = ExecuteScalar(
                                "RegistryConnectionString", "CRS_SP_INS_CRSDBLOG",
                                new object[] { 1, 0, "CORE Logger", message, "", "CORE Logger" });
            }
        }

        public static string GetLogLocation()
        {
            //Global g = new Global();
            return ConfigurationManager.AppSettings["LogsPath"].ToString() + @"\" + DateTime.Today.Year + @"\" + DateTime.Today.Month + @"\" + DateTime.Today.Day + ".log";
        }

        private static object ExecuteScalar(string connName, string spName, params object[] values)
        {
            object result = null;
            if (connName.Length > 0)
            {
                try
                {
                    Database db = DatabaseFactory.CreateDatabase(connName);
                    DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
                    result = db.ExecuteScalar(dbCommand);
                }
                catch (Exception ex)
                {
                    throw ex;
                }
            }
            return result;
        }
    }



}
