﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;



namespace VeteransAffairs.Registries.Business.Utilities
{
    public class RegistriesConfigurations : ConfigurationSection
    {
        

        [ConfigurationProperty("ContextCommandTimeout", DefaultValue = 30, IsRequired=false)]
        public int ContextCommandTimeout
        {
            get 
            {
                return int.Parse(this["ContextCommandTimeout"].ToString());

            }

        }
        
        [ConfigurationProperty("logLinq", DefaultValue = false, IsRequired=false)]  
        public bool LogLinq
        {
            get 
            {
                return bool.Parse(this["logLinq"].ToString());
                
            }
        }

        [ConfigurationProperty("DisplayUser", DefaultValue = true, IsRequired=false)]
        public bool DisplayUser
        {
            get 
            {
                return bool.Parse(this["DisplayUser"].ToString());
                
            }
        }

        [ConfigurationProperty("BaseReportPath", DefaultValue = "", IsRequired=false)]
        public string BaseReportPath
        {
            get 
            {
                return this["BaseReportPath"].ToString();
                
            }
        }

        [ConfigurationProperty("ReportingServer", DefaultValue = "", IsRequired=false)]
        public string ReportingServer
        {
            get 
            {
                return this["ReportingServer"].ToString();
 
            }
        }

        //TopInstitution
        [ConfigurationProperty("TopInstitution", DefaultValue = 1000001, IsRequired=false)]
        public int TopInstitution
        {
            get 
            {
                return int.Parse(this["TopInstitution"].ToString());

            }

        }

        public static RegistriesConfigurations GetConfig()
       {
           return ConfigurationManager.GetSection("RegistriesCustomSettings/RegistriesSettings") as RegistriesConfigurations;   
  

       }
    }
}
