﻿using System.Text;

namespace VeteransAffairs.Registries.Business.Utilities
{
    public sealed class CacheKey
    {
        private const char SEPARATOR = '|';
        private const string EMPTY_PART = "NONE";

        private readonly StringBuilder _builder;

        public CacheKey()
        {
            _builder = new StringBuilder();
        }

        public CacheKey(string cachedItemIdentifier)
        {
            _builder = new StringBuilder();

            AddPart(cachedItemIdentifier);
        }

        public CacheKey(
            string nameSpace, 
            string className, 
            string method)
        {
            _builder = new StringBuilder();

            AddPart(nameSpace);
            AddPart(className);
            AddPart(method);
        }

        public CacheKey AddPart<T>(T part)
        {
            string partString = EMPTY_PART;

            if (part != null)
                partString = part.ToString();

            _builder.Append($"{SEPARATOR}{partString}");

            return this;
        }

        public string Build()
        {
            return _builder.ToString();
        }
    }
}
