﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;

namespace VeteransAffairs.Registries.Business.Utilities
{
    public static class AssemblyTime
    {
        public static DateTime Get(string filepath)
        {
            const int peHeaderOffset = 60;
            const int linkerTimestampOffset = 8;
            byte[] b = new byte[2048];
            //Stream s = null;
            try
            {
                using (Stream s = new FileStream(filepath, FileMode.Open, FileAccess.Read))
                {
                    int rd = s.Read(b, 0, 2048);
                    if (rd == -1)
                        throw new System.IO.IOException("File is unusually small");
                }
            }
            catch { }
            //finally
            //{
            //    if (s != null)
            //    {
            //        s.Close();
            //    }
            //}

            int i = BitConverter.ToInt32(b, peHeaderOffset);
            int secondsSince1970 = BitConverter.ToInt32(b, i + linkerTimestampOffset);
            DateTime dt = new DateTime(1970, 1, 1, 0, 0, 0);
            dt = dt.AddSeconds(secondsSince1970);
            dt = dt.AddHours(TimeZone.CurrentTimeZone.GetUtcOffset(dt).Hours);
            return dt;
        }

        public static DateTime Get(Type type)
        {
            if (type != null)
            {
                if (AppDomain.CurrentDomain != null)
                {
                    Assembly[] assemblies = AppDomain.CurrentDomain.GetAssemblies();
                    if (assemblies != null && assemblies.Length > 0)
                    {
                        foreach (System.Reflection.Assembly a in assemblies)
                        {
                            Type[] types = a.GetExportedTypes();
                            if (types != null)
                            {
                                if (Array.IndexOf(types, type) != -1)
                                    return Get(a.Location);
                            }
                        }
                    }
                }
            }
            
            return DateTime.MinValue;
        }
    }
}
