﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.Specialized;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.Business
{
    [Serializable()]
    public partial class USER
    {
        #region private properties

        private ValidationErrorsCollection _BrokenRules = new ValidationErrorsCollection();

        private bool _itemChangedToInactive { get; set; }


        #endregion

        #region Public Properties

  
        /// <summary>
        /// Ref Property containing list of broken business rules.
        /// </summary>
        public ValidationErrorsCollection BrokenRules
        {
            get
            {
                return _BrokenRules;
            }
        }

 
        #endregion

        #region Entity Events

        

        #endregion

       #region Public Methods

        /// <summary>
        /// Method to remove all user_roles for an entity based on role id.
        /// </summary>
        /// <param name="userEntity">
        /// <param name="RoleID">
        /// <returns>USER</returns>
        public USER RemoveRoleFromUser(USER userEntity, int RoleID)
        {
            foreach (USER_ROLE userRole in userEntity.USER_ROLEs.Where(e => e.STD_ROLE_ID == RoleID))
            {
                //userRole.INACTIVE_FLAG = true;
                userRole.SetAsDeleteOnSubmit();
            }

            return userEntity;
        }

 
        #endregion

        #region Business Rules

        public int EnforceBusinessRules(bool SavingData, RegistriesDataAccess db)
        {
            _BrokenRules.Clear();

            //required fields
            //---------------------------------------------------
            
            //Username
            if (this.USERNAME == null || this.USERNAME.Length == 0)
            {
                _BrokenRules.Add(new ValidationError("USERNAME", "\"Username\" is required."));
            }
            //---------------------------------------------------
            
            //end required fields
            
            //set dependent fields
            //---------------------------------------------------
            if (SavingData && _itemChangedToInactive)
            {
                this.INACTIVE_DATE = db.GetSystemDate();

                //TO DO
                //clear all roles
                //clear all visn's
            }

            //set change date if not set to ensure a create date on insert
            if (SavingData)
            {
                this.PASSWORD_CREATE_DATE = db.GetSystemDate();
            }

            //set change date if not set to ensure a create date on insert
            if (SavingData) 
            {
                this.PASSWORD_CHANGE_DATE = db.GetSystemDate();
            }

            //set inactive date on user_roles that are being set to inactive
            if (SavingData)
            {
                foreach (USER_ROLE userRole in this.USER_ROLEs.Where(e => e.ItemChangedToInactive == true))
                {
                    userRole.INACTIVE_DATE = db.GetSystemDate();
                }
            }

            //---------------------------------------------------
            //end dependent fields


            //constraints
            //------------------------------------------------------------
           
            //username must be unique
            if (SavingData && this.USERNAME != null)
            {
                int countUsername = (from e in db.USERs 
                                     where e.USERNAME == this.USERNAME 
                                     && e.USER_ID != this.USER_ID
                                     select e).Count();

                if (countUsername > 0)
                {
                    _BrokenRules.Add(new ValidationError("USERNAME_NOT_UNIQUE", "The username entered is already in the system.  Username must be unique.  Please confirm that the username is correct."));
                }

            }

            //------------------------------------------------------------
            //end constraints
        
            return 0;
        }

        partial void OnINACTIVE_FLAGChanging(bool value)
        {
            if (this.INACTIVE_FLAG == false && value == true)
            {
                _itemChangedToInactive = true;
            }
        }
        
        #endregion

        #region Properties for Validator Controls
   

        #endregion

        

    }

 
}
