﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace VeteransAffairs.Registries.Business
{
    [Serializable()]
    public partial class TBI_TRACKING
    {

        #region Public Properties

        /// <summary>
        /// Property to inform if STD_TBIOTHER_CONSULT_STATUS is editable. Value set by value of NOT_APPLICABLE.
        /// </summary>
        public bool TbiOtherConsultStatusIsEditable {get;internal set;}
      
        /// <summary>
        /// Property to inform if ConsultNotSubmittedNotice should be displayed. Value set by value of STD_TBIOTHER_CONSULT_STATUS.
        /// </summary>
        public bool TbiOtherConsultNotSubmittedNotice { get; internal set; }

        /// <summary>
        /// Property to inform if NOT_APPLICABLE property was changed since object was instantiated.
        /// </summary>
        public bool TbiNotApplicablePropertyChanged { get; internal set; }

        #endregion


        #region Entity Events

        partial void OnLoaded()
        {
        }

        partial void OnCONSULT_NOT_APPLICABLE_FLAGChanged()
        {
            TbiNotApplicablePropertyChanged = true;
        }


        #endregion


        #region Properties for Validator Controls

        /// <summary>
        /// Property to inform if DATE_CONSULT_REFERRAL property is required.
        /// </summary>
        public bool TbiDateConsultReferralIsRequired { get; set; }


        #endregion

    }
}
