﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.Validation;

namespace VeteransAffairs.Registries.Business
{
    
    [Serializable()]
    public partial class TBI_REFERRAL
    {
        
        #region private properties

        private ValidationErrorsCollection _BrokenRules = new ValidationErrorsCollection();
        

        public enum Attempt : int
        {
            One = 0,
            Two = 1,
            Three = 2
        }
       
        public enum ResponsibleTeamCode : int
        {
            PMandR = 1,
            Neurology = 2,
            BehavioralHealth = 3,
            PrimaryCareWithSpecialtyTrainingInTbi = 4,
            Other = 5
        }
        public enum TbiReferralStatus : int
        {
            New = 1,
            InProcess = 2,
            Completed = 3,
        }

        public enum TbiReferralConsultStatus : int
        {
            ConsultNotSubmitted = 1,
            EvaluationWithoutReferral = 2
        }

        public enum TbiEvalDelayType : int
        {
            NO_SHOW = 1,
	        CANCELLATION_BY_PATIENT = 2,
	        CANCELLATION_BY_CLINIC = 3,
	        DELAY_IN_CONSULT = 4,
	        NO_DELAY = 5,
	        CLINIC_CAPACITY = 6,
	        DELAY_IN_SUCCESSFUL_PATIENT_CONTACT = 7
        }
        

        private int _referralStatus;
        private int _attempt1Status;
        private int _attempt2Status;
        private int _attempt3Status;
        private int _delayCompletingEvaluation1;
        private int _delayCompletingEvaluation2;
        private WKF_CASE_ACTIVITY _attempt1Activity;
        private WKF_CASE_ACTIVITY _attempt2Activity;
        private WKF_CASE_ACTIVITY _attempt3Activity;


        #endregion

        #region Public Properties



        //public TBI_REFERRAL()
        //{
        //    //int returnVal = EnforceBusinessRules(false);            
         
        //}

        /// <summary>
        /// Property to inform if the object is being loaded from a postback.
        /// </summary>
        public bool LoadedWithDisconnectedStateChanges { get; set; }


        /// <summary>
        /// Property to inform if STD_REFERRALST_ID is editable.
        /// </summary>
        public bool TbiReferralStatusIsEditable {get;internal set;}

   
        /// <summary>
        /// Ref Property containing list of broken business rules.
        /// </summary>
        public ValidationErrorsCollection BrokenRules
        {
            get
            {
                return _BrokenRules;
            }
        }

        /// <summary>
        /// Property to inform if OTHER_TBI_FACILITY_DSCR is editable.
        /// </summary>
        public bool TbiTeamTypeOtherIsEditable { get; internal set; }

        /// <summary>
        /// Property to indicate how many scheduled attempts where "NO SHOW", "CANCELLATION BY PATIENT"
        /// </summary>
        public int TbiNumberOfNoShows 
        {
            get
            {
                //string[] codes = { "NO SHOW", "CANCELLATION BY PATIENT" };
                int[] codes = { (int)TbiEvalDelayType.NO_SHOW, (int)TbiEvalDelayType.CANCELLATION_BY_PATIENT };
                
                var delays = (from activities in this.WKF_CASEs[0].WKF_CASE_ACTIVITies
                              where activities.STD_TBIEVALDELAYTYPE_ID != null
                              && activities.MarkedForDeletion == false
                              select activities);

                int num = 0;

                if (delays.Count() > 0)
                {
                    num = (from r in delays
                           //where codes.Contains(r.STD_TBIEVALDELAYTYPE.CODE)
                           where codes.Contains(r.STD_TBIEVALDELAYTYPE.ID)
                           select r).Count();
                }

                return num;
            }
        }

        /// <summary>
        /// Returns a Dictionary of Available Status for current state of referral. The key is the referral status ID and the value is a bool value the display name.
        /// </summary>
        public ListDictionary AvailableStatusList
        {
            get
            {
                return GetAvailableStatusList();
            }

        }


        #endregion

        #region Entity Events
        
        
        #endregion

       #region Public Methods

        /// <summary>
        /// Method to get amount of time to scheduled appointment from referral date (screening date)
        /// </summary>
        public Int32? GetTimeScheduledAppointmentTBITeam(int AttemptCount)
        {
            DateTime dt1;
            DateTime dt2;
            TimeSpan reslt;

            if (this.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_SCHEDULE_DATE == null)
            {
                dt1 = this.REFERRAL_DATE.GetValueOrDefault();
            }
            else
            {
                dt1 = this.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_SCHEDULE_DATE.GetValueOrDefault();
            }

            dt1 = this.REFERRAL_DATE.GetValueOrDefault();

            if (this.WKF_CASEs[0].WKF_CASE_ACTIVITies[AttemptCount].TBI_EVALUATION_SCHEDULE_DATE != null)
            {
                dt2 = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[AttemptCount].TBI_EVALUATION_SCHEDULE_DATE.GetValueOrDefault();

                reslt = dt2.Subtract(dt1);

                return reslt.Days;
            }
            else
            {
                return null;
            }
        }

        /// <summary>
        /// Method to get amount of time to complete 
        /// </summary>
        public Int32? GetTimeEvaluationCompleted()
        {
            DateTime dt1;
            DateTime dt2;
            TimeSpan reslt;

            if (this.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_SCHEDULE_DATE == null)
            {
                dt1 = this.REFERRAL_DATE.GetValueOrDefault();
            }
            else
            {
                dt1 = this.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_SCHEDULE_DATE.GetValueOrDefault();
            }

            dt1 = this.REFERRAL_DATE.GetValueOrDefault();

            if (this.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_COMPLETE_DATE != null)
            {
                dt2 = this.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_COMPLETE_DATE.GetValueOrDefault();

                reslt = dt2.Subtract(dt1);

                return reslt.Days;
            }
            else
            {
                return null;
            }

        }

        #endregion

        #region Business Rules

        public int EnforceBusinessRules(bool SavingData, RegistriesDataAccess db)
        {
            _BrokenRules.Clear();

            RuleObjectRelationshipsRequiredReferenceObjects(db);

            RuleAttemptsRelationshipsBasedOnPreviousAttemptData(SavingData, db);

            RuleRelationshipNotApplicableOtherConsultStatus();
            RuleRelationshipReferralStatusOtherConsultStatus(db);
            
            RuleDisplayConsultNotSubmittedNotice();
            RulePropertyBehaviorReferralStatus();

            RuleRelationshipTeamTypeToTeamTypeOther();

            RuleConfigurePropertiesForValidatorControls();

            RuleAddAttemptActivities(db);

            RuleSetItemAsNotNew(SavingData,db);

            return 0;
        }

        private void RuleSetItemAsNotNew(bool SavingData, RegistriesDataAccess db)
        {
            //if an item is saved then it is no longer new so move to pending if status is new
            if (SavingData && this.STD_REFERRALST != null && this.STD_REFERRALST.CODE == "TBI_NEW")
            {
                this.STD_REFERRALST = (from stat in db.STD_REFERRALSTs where stat.CODE == "TBI_IN PROCESS" select stat).FirstOrDefault();
            }
        }

        private void RuleObjectRelationshipsRequiredReferenceObjects(RegistriesDataAccess db) 
        {
            //TBI Referral requires 1 Workflow Case
            if (this.WKF_CASEs.Count() == 0)
            {
                WKF_CASE wkCase = new WKF_CASE();
                wkCase.CASE_NUMBER = string.Empty;

                wkCase.STD_WKFCASEST =
                    (from caseStatus in db.STD_WKFCASESTs where caseStatus.CODE == "NEW" select caseStatus).FirstOrDefault();

                wkCase.PATIENT =
                    (from patient in db.PATIENTs where patient.PATIENT_ID == this.PATIENT_ID select patient).FirstOrDefault();

                wkCase.STD_WKFCASETYPE =
                    (from wkType in db.STD_WKFCASETYPEs where wkType.CODE == "TBI WORKFLOW" select wkType).FirstOrDefault();
         
                this.WKF_CASEs.Add(wkCase);
            }

            //TBI Referral requires 1 TBI Tracking 
            if (this.WKF_CASEs[0].TBI_TRACKINGs.Count == 0)
            {
                TBI_TRACKING tracking = new TBI_TRACKING();
                tracking.PATIENT_ID = this.PATIENT_ID;
                this.WKF_CASEs[0].TBI_TRACKINGs.Add(tracking);
            }

            //TBI Referral requires at least 1 Activity
            if (this.WKF_CASEs.FirstOrDefault().WKF_CASE_ACTIVITies.Where(c => c.MarkedForDeletion == false).Count() == 0)
            {
                WKF_CASE_ACTIVITY activity1 = new WKF_CASE_ACTIVITY();

                activity1.TBI_CONTACT_ATTEMPT_COUNT = 1;

                activity1.STD_WKFACTIVITYTYPE =
                    (from activityType in db.STD_WKFACTIVITYTYPEs where activityType.CODE == "TBI 1 SCHEDULED" select activityType).FirstOrDefault();
                activity1.STD_WKFACTIVITYST =
                    (from activityStatus in db.STD_WKFACTIVITYSTs where activityStatus.CODE == "IN-PROCESS" select activityStatus).FirstOrDefault();
            
                activity1.REPRESENTATIVE_NAME = "";

                this.WKF_CASEs[0].WKF_CASE_ACTIVITies.Add(activity1);
            }

            this.WKF_CASEs[0].WKF_CASE_ACTIVITies.OrderBy(a => a.TBI_CONTACT_ATTEMPT_COUNT);
        
        }

        
        private void RuleAttemptsRelationshipsBasedOnPreviousAttemptData(bool SavingData, RegistriesDataAccess db) 
        {
            GetAttemptStatusAndDelayValues();

            

            if (_delayCompletingEvaluation2 != (int)TbiEvalDelayType.NO_SHOW
                && _delayCompletingEvaluation2 != (int)TbiEvalDelayType.CANCELLATION_BY_PATIENT
                && _attempt3Activity != null)
            {
                if (SavingData)
                {
                    if (_attempt3Activity != null)
                        _attempt3Activity.SetAsDeleteOnSubmit();
                    //db.WKF_CASE_ACTIVITies.DeleteOnSubmit(_attempt3Activity);
                }
                else
                {
                    //_attempt3Activity.SetAsDeleteOnSubmit();
                    _attempt3Activity.MarkedForDeletion = true;
 //                   this.WKF_CASEs[0].WKF_CASE_ACTIVITies.Remove(_attempt3Activity);
                }
            }

            if (_delayCompletingEvaluation1 != (int)TbiEvalDelayType.NO_SHOW
                && _delayCompletingEvaluation1 != (int)TbiEvalDelayType.CANCELLATION_BY_PATIENT
                && _attempt2Activity != null)
            {

                if (SavingData)
                {
                    _attempt2Activity.SetAsDeleteOnSubmit();
                    //db.WKF_CASE_ACTIVITies.DeleteOnSubmit(_attempt2Activity);
                }
                else
                {
                    //_attempt2Activity.SetAsDeleteOnSubmit();
                    _attempt2Activity.MarkedForDeletion = true;

 //                   this.WKF_CASEs[0].WKF_CASE_ACTIVITies.Remove(_attempt2Activity);
                }

                if (_attempt3Activity != null)
                {
                    if (SavingData)
                    {
                        _attempt3Activity.SetAsDeleteOnSubmit();
                        //db.WKF_CASE_ACTIVITies.DeleteOnSubmit(_attempt3Activity);
                    }
                    else
                    {
                        //_attempt3Activity.SetAsDeleteOnSubmit();
                        _attempt3Activity.MarkedForDeletion = true;
 //                       this.WKF_CASEs[0].WKF_CASE_ACTIVITies.Remove(_attempt3Activity);
                    }
                }
            }

        }
        

        private void RuleRelationshipNotApplicableOtherConsultStatus()
        {
            ValidationErrorsCollection brokenRuleExists;

            //Business Rule: STD_TBIREFERRALST is editable when CONSULT_NOT_APPLICABLE_FLAG is true
            if (this.WKF_CASEs[0].TBI_TRACKINGs.Count != 0)
            {
                TBI_TRACKING tbiTracking = this.WKF_CASEs[0].TBI_TRACKINGs[0];

                if (tbiTracking.CONSULT_NOT_APPLICABLE_FLAG == false)
                {
                    //popCalDtofReferral.RequiredDate = False
                    tbiTracking.TbiDateConsultReferralIsRequired = false;
                    
                    //ddlOtherConRefStatus.SelectedValue = ""
                    tbiTracking.STD_TBIREFERRALST = null;

                    //ddlOtherConRefStatus.Enabled = False
                    tbiTracking.TbiOtherConsultStatusIsEditable = false;

                    TbiOtherConsultStatusIsRequired = false;

                    brokenRuleExists = _BrokenRules.FindByPropertyName("STD_TBIREFERRALST");
                    if (brokenRuleExists.Count > 0)
                    {
                        _BrokenRules.Remove(brokenRuleExists.FirstOrDefault());
                    }
                }
                else
                {
                    //ddlOtherConRefStatus.Enabled = True
                    tbiTracking.TbiOtherConsultStatusIsEditable = true;
                    //txtDtofConsultReferral.Text = ""
                    if (tbiTracking.TbiNotApplicablePropertyChanged)
                    {
                        this.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_SCHEDULE_DATE = null;
                    }
                    
                    //popCalDtofReferral.RequiredDate = False
                    tbiTracking.TbiDateConsultReferralIsRequired = false;
            
                    TbiOtherConsultStatusIsRequired = true;

                    //Moved this section to RuleCheckIfCanComplete
                    //if (tbiTracking.STD_TBIREFERRALSTS_ID == null)
                    //{
                    //    brokenRuleExists = _BrokenRules.FindByPropertyName("STD_TBIREFERRALST");
                    //    if (brokenRuleExists.Count == 0)
                    //    {
                    //        _BrokenRules.Add(new ValidationError("STD_TBIREFERRALST", "\"Other Consult Referral Status\" is required when Not Applicable is Checked"));
                    //    }
                    //}
                    
                }
            }
            

        }

        private void RuleRelationshipReferralStatusOtherConsultStatus(RegistriesDataAccess db)
        {
            //TO DO : Need property to disallow complete status
            
            //Business Rule: When STD_TBIREFERRALST equals CONSULT NOT SUBMITTED then referral status needs to be pending
            if (this.WKF_CASEs[0].TBI_TRACKINGs[0] != null)
            {
                if  (
                    this.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBIREFERRALST != null
                    &&
                    this.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBIREFERRALST.CODE == "CONSULT NOT SUBMITTED"
                    )
                    {
                        //Changing logic to not reset status
                        //this.STD_REFERRALST = (from stat in db.STD_REFERRALSTs where stat.CODE == "TBI_IN PROCESS" select stat).FirstOrDefault();
                        TbiItemIsInConsultNotSubmittedStatus = true;
                        TbiAllowComplete = false;
                    }
                
            }
            
        }

        private void RuleRelationshipTeamTypeToTeamTypeOther()
        {
            //if STD_TBITEAMTYPE equals OTHER then team type other text property is editable
            if (this.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBITEAMTYPE != null
                &&
                this.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBITEAMTYPE.CODE == "OTHER")
            {
                TbiTeamTypeOtherIsEditable = true;
                TbiTeamTypeOtherIsRequired = true;
            }
            else 
            {
                TbiTeamTypeOtherIsEditable = false;
                TbiTeamTypeOtherIsRequired = false;
            }
        }       
        

        private void RuleDisplayConsultNotSubmittedNotice()
        {
            //Business Rule: ConsultNotSubmittedNotice should be displayed when STD_TBIREFERRALST equals 1.
            if (this.WKF_CASEs[0].TBI_TRACKINGs[0] != null)
            {
                TBI_TRACKING tbiTracking = this.WKF_CASEs[0].TBI_TRACKINGs[0];

                if (tbiTracking.STD_TBIREFERRALSTS_ID.HasValue)
                {
                    if (tbiTracking.STD_TBIREFERRALSTS_ID == (int)TbiReferralConsultStatus.ConsultNotSubmitted)
                    {
                        //lblmsg.Visible = False
                        tbiTracking.TbiOtherConsultNotSubmittedNotice = true;
                    }
                    else
                    {
                        //lblmsg.Visible = False
                        tbiTracking.TbiOtherConsultNotSubmittedNotice = false;
                    }
                }
                else
                {
                    //lblmsg.Visible = False
                    tbiTracking.TbiOtherConsultNotSubmittedNotice = false;
                }
            }
        }

        private void RulePropertyBehaviorReferralStatus ()
            {

                if (this.WKF_CASEs[0].TBI_TRACKINGs[0] != null)
                {
                    if (this.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBIREFERRALST != null
                        &&
                        this.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBIREFERRALSTS_ID == (int)TBI_REFERRAL.TbiReferralConsultStatus.ConsultNotSubmitted)
                    {
                        this.TbiReferralStatusIsEditable = false;
                    }
                    else 
                    { 
                        this.TbiReferralStatusIsEditable = true; 
                    }
                }
                else
                {
                    this.TbiReferralStatusIsEditable = true;
                }

            }

        private void RuleConfigurePropertiesForValidatorControls ()
        {
            
            GetAttemptStatusAndDelayValues();
            

            if (_referralStatus == 1 || _referralStatus == 2)
            {
                TbiOtherConsultStatusIsRequired = false;

                TbiAtemptsIsRequired = false;

                TbiDelayCompletingEvaluation = false;

                TbiDefinitiveTBIDiagnosis = false;

                TbiResponsibleTeamIsRequired = false;

                TbiDateConsultReferralIsRequired = false;

                TbiDateScheduledWithTBIEvaluationTeamIsRequired = false;

                TbiDateEvaluationCompletedIsRequired = false;

                TbiSecondDateScheduledIsRequired = false;
                
                TbiThirdDateScheduledIsRequired = false;

                TbiAttempts2IsRequired = false;
                TbiDelay2CompletingEvaluation = false;
                TbiAttempts3IsRequired = false;
                TbiDelay3CompletingEvaluation = false;
                
            }
            else if (_referralStatus == 3)
            {
                if (
                        this.TbiNumberOfNoShows == 3 
                        || _attempt1Status == 1 
                        || _attempt1Status == 4
                        || _attempt1Status == 5
                        
                        || _attempt2Status == 1 
                        || _attempt2Status == 4
                        || _attempt2Status == 5
                        
                        || _attempt3Status == 1 
                        || _attempt3Status == 4
                        || _attempt3Status == 5
                    )
                {
                    TbiOtherConsultStatusIsRequired = false;
                    TbiAtemptsIsRequired = false;
                    TbiDelayCompletingEvaluation = false;
                    TbiDefinitiveTBIDiagnosis = false;
                    TbiResponsibleTeamIsRequired = false;
                    
                    TbiDateConsultReferralIsRequired = false;
                    TbiDateScheduledWithTBIEvaluationTeamIsRequired = false;
                    TbiDateEvaluationCompletedIsRequired = false;

                    TbiSecondDateScheduledIsRequired = false;
                    TbiThirdDateScheduledIsRequired = false;

                    TbiAttempts2IsRequired = false;
                    TbiDelay2CompletingEvaluation = false;
                    TbiAttempts3IsRequired = false;
                    TbiDelay3CompletingEvaluation = false;
                }
                else
                {
                    TbiAtemptsIsRequired = true;
                    TbiDelayCompletingEvaluation = true;
                    TbiDefinitiveTBIDiagnosis = true;
                    TbiResponsibleTeamIsRequired = true;

                    //the only time date consult of consult / referral is not required for completing referral is
                    //when the consult not applicable checkbox is selected 
                    //and 
                    //other consult referral status dropdown is equal to evaluation without referral/consult.
                    if (this.WKF_CASEs[0].TBI_TRACKINGs[0].CONSULT_NOT_APPLICABLE_FLAG == true
                        &&
                        this.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBIREFERRALSTS_ID == (int)TbiReferralConsultStatus.EvaluationWithoutReferral
                        )
                            {
                                TbiDateConsultReferralIsRequired = false;
                            }
                            else
                            {
                                TbiDateConsultReferralIsRequired = true;
                            }

                    TbiDateScheduledWithTBIEvaluationTeamIsRequired = true;
                    TbiDateEvaluationCompletedIsRequired = true;

                    if (_delayCompletingEvaluation1 == (int)TbiEvalDelayType.NO_SHOW || _delayCompletingEvaluation1 == (int)TbiEvalDelayType.CANCELLATION_BY_PATIENT)
                    {
                        TbiSecondDateScheduledIsRequired = true;
                        TbiAttempts2IsRequired = true;
                        TbiDelay2CompletingEvaluation = true;
                    }
                    else
                    {
                        TbiSecondDateScheduledIsRequired = false;
                        TbiAttempts2IsRequired = false;
                        TbiDelay2CompletingEvaluation = false;
                    }

                    if (_delayCompletingEvaluation2 == (int)TbiEvalDelayType.NO_SHOW || _delayCompletingEvaluation2 == (int)TbiEvalDelayType.CANCELLATION_BY_PATIENT)
                    {
                        TbiThirdDateScheduledIsRequired = true;
                        TbiAttempts3IsRequired = true;
                        TbiDelay3CompletingEvaluation = true;
                    }
                    else
                    {
                        TbiThirdDateScheduledIsRequired = false;
                        TbiAttempts3IsRequired = false;
                        TbiDelay3CompletingEvaluation = false;
                    }

                    //from the old system save event
                    if (this.WKF_CASEs[0].TBI_TRACKINGs[0].REFERRAL_COMPLETE_DATE == null)
                    {
                        TbiEvaluationCompletedDateIsRequired = true;
                    }
                    else
                    {
                        TbiEvaluationCompletedDateIsRequired = false;
                    }

                    //from the old system save event
                    if (this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.One].TBI_EVALUATION_SCHEDULE_DATE == null)
                    {   
                        TbiDateScheduledWithTBIEvaluationTeamIsRequired = true;
                    }
                    else
                    {
                        TbiDateScheduledWithTBIEvaluationTeamIsRequired = false;
                    }
                    
                    //from the old system save event
                    if (_delayCompletingEvaluation1 == (int)TbiEvalDelayType.NO_SHOW
                        || _delayCompletingEvaluation1 == (int)TbiEvalDelayType.CANCELLATION_BY_PATIENT
                        ) 
                        //JH 6/10/2010 commenting out the OR for "(int)TbiEvalDelayType.CANCELLATION_BY_CLINIC since
                        // activities are only added for NO_SHOW and CANCELLATION_BY_PATIENT
                        //|| _delayCompletingEvaluation1 == (int)TbiEvalDelayType.CANCELLATION_BY_CLINIC)
                    {
                    
                        if (this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.Two].TBI_EVALUATION_SCHEDULE_DATE == null)
                        {   
                            TbiSecondDateScheduledIsRequired = true;
                        }
                        else
                        {
                            TbiSecondDateScheduledIsRequired = false;
                        }
    
                    }

                    //from the old system save event
                    if (_delayCompletingEvaluation2 == (int)TbiEvalDelayType.NO_SHOW
                        || _delayCompletingEvaluation2 == (int)TbiEvalDelayType.CANCELLATION_BY_PATIENT
                        )
                        //JH 6/10/2010 commenting out the OR for (int)TbiEvalDelayType.CANCELLATION_BY_CLINIC since
                        // activities are only added for NO_SHOW and CANCELLATION_BY_PATIENT
                        //|| _delayCompletingEvaluation2 == (int)TbiEvalDelayType.CANCELLATION_BY_CLINIC)
                    {
                    
                        if (this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.Three].TBI_EVALUATION_SCHEDULE_DATE == null)
                        {   
                            TbiThirdDateScheduledIsRequired = true;
                        }
                        else
                        {
                            TbiThirdDateScheduledIsRequired = false;
                        }
    
                    }

                }
            }
            else
            {
                TbiOtherConsultStatusIsRequired = false;
                TbiAtemptsIsRequired = false;
                TbiDelayCompletingEvaluation = false;
                TbiDefinitiveTBIDiagnosis = false;
                TbiResponsibleTeamIsRequired = false;

                TbiDateConsultReferralIsRequired = false;
                TbiDateScheduledWithTBIEvaluationTeamIsRequired = false;
                TbiDateEvaluationCompletedIsRequired = false;
                TbiSecondDateScheduledIsRequired = false;
                TbiThirdDateScheduledIsRequired = false;

                TbiAttempts2IsRequired = false;
                TbiDelay2CompletingEvaluation = false;
                TbiAttempts3IsRequired = false;
                TbiDelay3CompletingEvaluation = false;
            }

        }

        private void GetAttemptStatusAndDelayValues()
        {
            _referralStatus = this.STD_REFERRALSTS_ID;
            _attempt1Status = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.One].STD_TBISCHEDULESTS_ID.GetValueOrDefault(0);
            _attempt1Activity = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.One];

            int responsibleTeamId = this.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBITEAMTYPE_ID.GetValueOrDefault(0);

            _delayCompletingEvaluation1 = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.One].STD_TBIEVALDELAYTYPE_ID.GetValueOrDefault(0);


            if (this.WKF_CASEs[0].WKF_CASE_ACTIVITies.Where(c => c.MarkedForDeletion == false).Count() >= 2)
            {
                _attempt2Status = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.Two].STD_TBISCHEDULESTS_ID.GetValueOrDefault(0);
                _delayCompletingEvaluation2 = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.Two].STD_TBIEVALDELAYTYPE_ID.GetValueOrDefault(0);
                _attempt2Activity = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.Two];
            }
            else
            {
                _attempt2Status = 0;
                _delayCompletingEvaluation2 = 0;
            }

            if (this.WKF_CASEs[0].WKF_CASE_ACTIVITies.Where(c => c.MarkedForDeletion == false).Count() == 3)
            {
                _attempt3Status = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.Three].STD_TBISCHEDULESTS_ID.GetValueOrDefault(0);
                _attempt3Activity = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.Three];
            }
            else
            {
                _attempt3Status = 0;
            }
        }

        private ListDictionary GetAvailableStatusList()
        {
            
            int attempt1Status;
            int delayCompletingEvaluation2;
            int delayCompletingEvaluation3;

            ListDictionary _referralStatusEnableSettings = new ListDictionary();
            
            //configure which referral statuses are available
            //_referralStatusEnableSettings.Add(1, true); //1 NEW
            //_referralStatusEnableSettings.Add(2, true); //2	PENDING	
            //_referralStatusEnableSettings.Add(3, false); //3	DUPLICATE
            //_referralStatusEnableSettings.Add(4, false); //4	REJECTED
            //_referralStatusEnableSettings.Add(5, true); //5	COMPLETED
            //_referralStatusEnableSettings.Add(8, false); //NO ACTION REQUIRED
            //_referralStatusEnableSettings.Add(9, false); //REFERRAL INELIGIBLE

            _referralStatusEnableSettings.Add(1, true); //1 New
            _referralStatusEnableSettings.Add(2, true); //2	In Process
            _referralStatusEnableSettings.Add(3, true); //3	Completed

            //index of status list drop down list in old system
                //0 completed
                //1 in-process
                //2 pending

            //id's of status in old system
            //1 pending
            //2 in process
            //3 completed


            if (this.LoadedWithDisconnectedStateChanges)
            {
                if (this.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBIREFERRALST != null 
                    &&
                    this.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBIREFERRALSTS_ID == (int)TBI_REFERRAL.TbiReferralConsultStatus.ConsultNotSubmitted)
                {
                    _referralStatusEnableSettings[3] = false;
                    
                }
                else
                {
                    attempt1Status = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.One].STD_TBISCHEDULESTS_ID.GetValueOrDefault(0);

                    //int attempt2Status = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.Two].STD_TBISCHEDULESTS_ID.GetValueOrDefault(0);
                    //int attempt3Status = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.Three].STD_TBISCHEDULESTS_ID.GetValueOrDefault(0);
                    //int responsibleTeamId = this.WKF_CASEs[0].TBI_TRACKINGs[0].STD_TBITEAMTYPE_ID.GetValueOrDefault(0);

                    delayCompletingEvaluation2 = 0;
                    if (this.WKF_CASEs[0].WKF_CASE_ACTIVITies.Where(c => c.MarkedForDeletion == false).Count() > 1)
                    {
                        delayCompletingEvaluation2 = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.Two].STD_TBIEVALDELAYTYPE_ID.GetValueOrDefault(0);
                    }

                    delayCompletingEvaluation3 = 0;
                    if (this.WKF_CASEs[0].WKF_CASE_ACTIVITies.Where(c => c.MarkedForDeletion == false).Count() > 2)
                    {
                        delayCompletingEvaluation3 = this.WKF_CASEs[0].WKF_CASE_ACTIVITies[(int)Attempt.Three].STD_TBIEVALDELAYTYPE_ID.GetValueOrDefault(0);
                    }

                    if (attempt1Status == 1 || attempt1Status == 4 || attempt1Status == 5)
                    {
                        _referralStatusEnableSettings[1] = false;
                        _referralStatusEnableSettings[2] = false;
                    }
                    else
                    {
                        if (delayCompletingEvaluation2 == 1 || delayCompletingEvaluation2 == 2)
                        {
                            if (delayCompletingEvaluation3 == 1 || delayCompletingEvaluation3 == 2)
                            {
                                _referralStatusEnableSettings[1] = false;
                                _referralStatusEnableSettings[2] = false;
                            }
                            else
                            {
                                _referralStatusEnableSettings[1] = true;
                                _referralStatusEnableSettings[2] = true;
                            }
                        }
                        else
                        {
                            _referralStatusEnableSettings[1] = true;
                            _referralStatusEnableSettings[2] = true;
                        }
                    }
                }
            }

            _referralStatusEnableSettings[StatusWhenInitialized] = true;

            TbiAllowComplete = (bool)_referralStatusEnableSettings[3];

            return _referralStatusEnableSettings;
        }

        public void RuleAddAttemptActivities(RegistriesDataAccess db)
        { 
            if (this.TbiNumberOfNoShows > 0 && this.WKF_CASEs.FirstOrDefault().WKF_CASE_ACTIVITies.Where(c => c.MarkedForDeletion == false).Count() == 1 )
            {
                WKF_CASE_ACTIVITY activity2 = new WKF_CASE_ACTIVITY();

                activity2.TBI_CONTACT_ATTEMPT_COUNT = 2;

                activity2.STD_WKFACTIVITYTYPE =
                    (from activityType in db.STD_WKFACTIVITYTYPEs where activityType.CODE == "TBI 2 SCHEDULED" select activityType).FirstOrDefault();
                activity2.STD_WKFACTIVITYST =
                    (from activityStatus in db.STD_WKFACTIVITYSTs where activityStatus.CODE == "IN-PROCESS" select activityStatus).FirstOrDefault();
            
                activity2.REPRESENTATIVE_NAME = "";
                
                this.WKF_CASEs[0].WKF_CASE_ACTIVITies.Add(activity2);
          
            }

            if (this.TbiNumberOfNoShows > 1 && this.WKF_CASEs.FirstOrDefault().WKF_CASE_ACTIVITies.Where(c => c.MarkedForDeletion == false).Count() == 2)
            {

                WKF_CASE_ACTIVITY activity3 = new WKF_CASE_ACTIVITY();

                activity3.TBI_CONTACT_ATTEMPT_COUNT = 3;

                activity3.STD_WKFACTIVITYTYPE =
                    (from activityType in db.STD_WKFACTIVITYTYPEs where activityType.CODE == "TBI 3 SCHEDULED" select activityType).FirstOrDefault();
                activity3.STD_WKFACTIVITYST =
                    (from activityStatus in db.STD_WKFACTIVITYSTs where activityStatus.CODE == "IN-PROCESS" select activityStatus).FirstOrDefault();

                activity3.REPRESENTATIVE_NAME = "";

                this.WKF_CASEs[0].WKF_CASE_ACTIVITies.Add(activity3);

            }
                
        }


        //       A case can move to completed status if 
        //1)	all fields are completed 
        //          (except Responsible TBI Evaluation Team (Service/Clinic) Other which is activated only when ‘Other’ is selected for Responsible TBI Evaluation Team (Service/Clinic)).
        //2)	Any of Unable, Refused, or Unavailable are entered in the  Attempts to Contact Patient for Scheduling Purposes field.
        //3)	Any combination of 3 entries of either No Show or Cancellation by Patient for in the Delay in Completing Evaluation field(s).
        
        //when attemptStatus in (1,4,5) does not allow in process status
        //when delay 2 and 3 equal selection 1 or 2 then does not allow in process status

        //TLB.Fortify
        //private void RuleCheckIfCanComplete(RegistriesDataAccess db)
        //{
        //    ValidationErrorsCollection brokenRuleExists;

        //    TBI_TRACKING tbiTracking = this.WKF_CASEs[0].TBI_TRACKINGs[0];

        //    if (tbiTracking.STD_TBIREFERRALSTS_ID == null)
        //    {
        //        brokenRuleExists = _BrokenRules.FindByPropertyName("STD_TBIREFERRALST");
        //        if (brokenRuleExists.Count == 0)
        //        {
        //            _BrokenRules.Add(new ValidationError("STD_TBIREFERRALST", "\"Other Consult Referral Status\" is required when Not Applicable is Checked"));
        //        }
        //    }

        //}
        #endregion

        #region Properties for Validator Controls

        /// <summary>
        /// Property to inform if STD_TBIREFERRALSTS_ID is required.
        /// </summary>
        public bool TbiOtherConsultStatusIsRequired { get; internal set; }

        public bool TbiAtemptsIsRequired { get; internal set; }

        public bool TbiDelayCompletingEvaluation { get; internal set; }

        public bool TbiDefinitiveTBIDiagnosis { get; internal set; }

        public bool TbiResponsibleTeamIsRequired { get; internal set; }

        public bool TbiTeamTypeOtherIsRequired { get; internal set; }
       
        public bool TbiDateConsultReferralIsRequired { get; internal set; }

        public bool TbiDateScheduledWithTBIEvaluationTeamIsRequired { get; internal set; }

        public bool TbiAttempts2IsRequired { get; internal set; }

        public bool TbiSecondDateScheduledIsRequired { get; internal set; }

        public bool TbiDelay2CompletingEvaluation { get; internal set; }

        public bool TbiAttempts3IsRequired { get; internal set; }

        public bool TbiThirdDateScheduledIsRequired { get; internal set; }

        public bool TbiDelay3CompletingEvaluation { get; internal set; }

        public bool TbiEvaluationCompletedDateIsRequired { get; internal set; }
        
        public bool TbiDateEvaluationCompletedIsRequired { get; internal set; }

        public bool TbiAllowComplete { get; internal set; }

        public bool TbiItemIsInConsultNotSubmittedStatus { get; internal set; }
        
        
        #endregion

        

    }

 
}