﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Text;
using System.Data;
using System.Data.Linq;
using System.Configuration;
using System.Web;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;

namespace VeteransAffairs.Registries.BusinessManager
{
    [Serializable()]
    public class ShipmentType : BaseBO
    {
        

        public ShipmentType() 
        {
            _defaultSortField = "Id";

            
        }

        private IQueryable<STD_SHIPMENTTYPE> LinqAll() 
        {
            //populate LinqAll
            return (from sTypes in _db.STD_SHIPMENTTYPEs
                    //select new ShipmentTypeEntity { Id = sTypes.ID, Description = sTypes.DESCRIPTION, Code = sTypes.CODE });
                    select sTypes);
                    //add all business filtering rules 
        }

        #region Methods for Select 
        
            public IEnumerable<STD_SHIPMENTTYPE> Select(string sort, int startRow, int maxRows)
            {
                if (string.IsNullOrEmpty(sort))
                {
                    sort = _defaultSortField;

                }
                
                using (_db = GetDataContext())
                {
                    return SelectLinqFilter().OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
                }
            }

            public int SelectCount(string sort, int startRow, int maxRows)
            {
                using (_db = GetDataContext())
                {
                    return SelectLinqFilter().Count();
                }
            }

            private IQueryable<STD_SHIPMENTTYPE> SelectLinqFilter()
            {
                IQueryable<STD_SHIPMENTTYPE> linqFilter = LinqAll();
                return linqFilter;
            }

        #endregion

        #region Methods for SelectByCode

            public IEnumerable<STD_SHIPMENTTYPE> SelectByCode(string code, string sort, int startRow, int maxRows)
            {
                if (string.IsNullOrEmpty(sort))
                {
                    sort = _defaultSortField;

                }
                
                using (_db = GetDataContext())
                {
                    return SelectByCodeLinqFiltered(code).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
                }
            }

            public int SelectByCodeCount(string code, string sort, int startRow, int maxRows)
            {
                using (_db = GetDataContext())
                {
                    return SelectByCodeLinqFiltered(code).Count();
                }
            }

            private IQueryable<STD_SHIPMENTTYPE> SelectByCodeLinqFiltered(string code)
            {
                IQueryable<STD_SHIPMENTTYPE> linqFiltered = LinqAll();

                if (!string.IsNullOrEmpty(code))
                    linqFiltered = from t in linqFiltered where t.CODE.Contains(code) select t;
                return linqFiltered;
            }
            

        #endregion

        #region Methods for SelectByDescription


            public IEnumerable<STD_SHIPMENTTYPE> SelectByDescription(string description, string sort, int startRow, int maxRows)
            {
                if (string.IsNullOrEmpty(sort))
                {
                    sort = _defaultSortField;

                }

                using (_db = GetDataContext())
                {
                    return SelectByDescriptionLinqFilter(description).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
                }
            }

            public int SelectByDescriptionCount(string description, string sort, int startRow, int maxRows)
            {
                using (_db = GetDataContext())
                {
                    return SelectByDescriptionLinqFilter(description).Count();
                }
            }

            private IQueryable<STD_SHIPMENTTYPE> SelectByDescriptionLinqFilter(string description)
            {
                IQueryable<STD_SHIPMENTTYPE> linqFilter = LinqAll();

                if (!string.IsNullOrEmpty(description))
                    linqFilter = from t in linqFilter where t.DESCRIPTION.Contains(description) select t;
                return linqFilter;
            }
            
        
        #endregion

        #region code for old way

        //    private IEnumerable<ShipmentTypeEntity> SelectByCriteria(string description, string code)
        //{

        //    using (_db = GetDataContext())
        //    {

        //        return ApplyFilterSelectByCriteria(description, code).ToList(); 

        //    }

        //}

        //private IQueryable<ShipmentTypeEntity> ApplyFilterSelectByCriteria(string description, string code)
        //{
        //    IQueryable<ShipmentTypeEntity> types = LinqAll();

        //    if (!string.IsNullOrEmpty(description))
        //        //types.Where(st => st.Description.Contains(description));
        //        types = from t in types where t.Description.Contains(description) select t;


        //    if (!string.IsNullOrEmpty(code))
        //        //types.Where(st => st.Code.Contains(code));
        //        types = from t in types where t.Code.Contains(code) select t;

        //    return types;

        //}

        //public IEnumerable<ShipmentTypeEntity> RetrieveSelectByCriteria(string description, string code, string sort, int startRow, int maxRows)
        //{

        //    if (string.IsNullOrEmpty(sort))
        //    {
        //        sort = "Id";

        //    }

        //    using (_db = GetDataContext())
        //    {
        //        return ((SelectByCriteria(description, code).AsQueryable<ShipmentTypeEntity>()).OrderBy(sort).AsEnumerable<ShipmentTypeEntity>()).Skip(startRow).Take(maxRows).ToList();
        //    }
        //}

        //public int RowCountSelectByCriteria(string description, string code, string sort, int startRow, int maxRows)
        //{
        //    int myRowCount = 0;

        //    using (_db = GetDataContext())
        //    {
                
        //        IQueryable<ShipmentTypeEntity> types = ApplyFilterSelectByCriteria(description, code);

        //        myRowCount = types.Count();
        //    }

        //    return myRowCount;
        //}      

        #endregion
            
        public int Update(STD_SHIPMENTTYPE single)
        {
            throw new System.NotImplementedException();
            //saveAll(collection - of 1 )
        }

        public int Insert()
        {
            throw new System.NotImplementedException();
        }

        public int Delete()
        {
            throw new System.NotImplementedException();
        }

        //private int Save(single) {
        
        //_db.SubmitChanges()
        //}
        private int saveAll(STD_SHIPMENTTYPE collection)
        {
            //loop
            //    create linqEntities    
            //    attach
            //    make edits    
            //endloop

            //tran open
            //    _db.SubmitChanges()
            //tran close
            return 0;
        }


        #region Entity Passing Test

        private IQueryable<STD_SHIPMENTTYPE> LinqShipmentTypes()
        {
            return (from sTypes in _db.STD_SHIPMENTTYPEs select sTypes );
        }


        public IEnumerable<STD_SHIPMENTTYPE> SelectUsingLinqEntity(string code, string sort, int startRow, int maxRows)
        {
            if (string.IsNullOrEmpty(sort))
            {
                sort = _defaultSortField;

            }

            using (_db = GetDataContext())
            {
                return SelectUsingLinqEntityFilter(code).OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
            }
        }

        public int SelectUsingLinqEntityCount(string code, string sort, int startRow, int maxRows)
        {
            using (_db = GetDataContext())
            {
                return SelectUsingLinqEntityFilter(code).Count();
            }
        }

        private IQueryable<STD_SHIPMENTTYPE> SelectUsingLinqEntityFilter(string code)
        {
            IQueryable<STD_SHIPMENTTYPE> linqFilter = LinqShipmentTypes();

            if (!string.IsNullOrEmpty(code))
                linqFilter = from t in linqFilter where t.CODE.Contains(code) select t;
            return linqFilter;
        }

        public int UpdateUsingLinqEntity(STD_SHIPMENTTYPE singleSHIPMENTTYPE, STD_SHIPMENTTYPE original_singleSHIPMENTTYPE)
        {

            //UPDATED_BY
            //UPDATED_DATE


            using (_db = GetDataContext())
            {

                
                _db.STD_SHIPMENTTYPEs.Attach(singleSHIPMENTTYPE, original_singleSHIPMENTTYPE);

                //STD_SHIPMENTTYPE original = (from t in _db.STD_SHIPMENTTYPEs where t.ID == singleSHIPMENTTYPE.ID select t).Single();
                //_db.Refresh(RefreshMode.KeepCurrentValues, singleSHIPMENTTYPE);

                try
                {
                    _db.SubmitChanges(ConflictMode.ContinueOnConflict);

                }
                catch 
                {
                    _db.Refresh(RefreshMode.KeepCurrentValues, singleSHIPMENTTYPE);
                }

                
            }

            return 1;
        }


        #endregion
}
    
}
