﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.Data;
using System.Reflection;
using System.Linq.Expressions;
using System.ComponentModel;
using System.Configuration;
using VeteransAffairs.Registries.Business.Utilities; 


namespace VeteransAffairs.Registries.Business
{
    [Serializable()]
    public partial class STD_INSTITUTION
    {
        private string _fullVISNName;
        private string _fullStationName;
        private int _visnNumber;

        partial void  OnLoaded()
        {
            try
            {
                if (this.STD_INSTITUTION_PARENT == null)
                {
                    _fullVISNName = this.NAME;
                    _visnNumber = ExtractVISNNumber();
                }
                else
                {
                    _fullStationName = "(" + this.STATIONNUMBER + ") " + this.VISTANAME;
                    _fullVISNName = "(" + this.STD_INSTITUTION_PARENT.NAME + ") " + _fullStationName;
                    _visnNumber = ExtractVISNNumber();
                }
            }
            catch
            {
                _fullVISNName = "";
                _visnNumber = 0;
            }

        }

        private int ExtractVISNNumber()
        {
            if (_fullVISNName.StartsWith("VISN ", StringComparison.OrdinalIgnoreCase))
            {
                int result;
                if (int.TryParse(_fullVISNName.Substring(5), out result))
                    return result;
            }
            return 0;
        }


        public string FullVISNName
        {
            get
            {
                return _fullVISNName;
            }
        }

        public string FullStationName
        {
            get
            {
                return _fullStationName;
            }
        }

        public int VisnNumber
        {
            get
            {
                return _visnNumber;
            }
        }

        public static int TopInstitutionId
        {
            get
            {
                string value = ConfigurationManager.AppSettings.Get("TopInstitution");
                int tempInt;

                bool result = int.TryParse(value, out tempInt);
                if (result)
                {
                    return tempInt;
                }
                else
                {
                    return 0;
                }              
            }
        }

        private EntityRef<STD_INSTITUTION_PARENT> _STD_INSTITUTION_PARENT = default(EntityRef<STD_INSTITUTION_PARENT>);

        [Association(Name = "STD_INSTITUTION_PARENT_STD_INSTITUTION", Storage = "_STD_INSTITUTION_PARENT", ThisKey = "VISN_ID", OtherKey = "ID", IsForeignKey = true)]
        public STD_INSTITUTION_PARENT STD_INSTITUTION_PARENT
        {
            get
            {
                return this._STD_INSTITUTION_PARENT.Entity;
            }
            set
            {
                STD_INSTITUTION_PARENT previousValue = this._STD_INSTITUTION_PARENT.Entity;
                if (((previousValue != value)
                            || (this._STD_INSTITUTION_PARENT.HasLoadedOrAssignedValue == false)))
                {
                    this.SendPropertyChanging();
                    if ((previousValue != null))
                    {
                        this._STD_INSTITUTION_PARENT.Entity = null;
                        previousValue.STD_INSTITUTIONs.Remove(this);
                    }
                    this._STD_INSTITUTION_PARENT.Entity = value;
                    if ((value != null))
                    {
                        value.STD_INSTITUTIONs.Add(this);
                        this._VISN_ID = value.ID;
                    }
                    else
                    {
                        this._VISN_ID = default(Nullable<int>);
                    }
                    this.SendPropertyChanged("STD_INSTITUTION_PARENT");
                }
            }
        }
		
    }
}
